/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.FT;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PSH
extends AbstractSegment {
    public PSH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Report Type");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Report Form Identifier");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Report Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Report Interval Start Date");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Report Interval End Date");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity Manufactured");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity Distributed");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(329)}, "Quantity Distributed Method");
            this.add(FT.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity Distributed Comment");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity in Use");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(329)}, "Quantity in Use Method");
            this.add(FT.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity in Use Comment");
            this.add(NM.class, false, 8, 0, new Object[]{this.getMessage()}, "Number of Product Experience Reports Filed by Facility");
            this.add(NM.class, false, 8, 0, new Object[]{this.getMessage()}, "Number of Product Experience Reports Filed by Distributor");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PSH - this is probably a bug in the source code generator.", e);
        }
    }

    public ST getReportType() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getPsh1_ReportType() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getReportFormIdentifier() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getPsh2_ReportFormIdentifier() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getReportDate() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getPsh3_ReportDate() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getReportIntervalStartDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getPsh4_ReportIntervalStartDate() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getReportIntervalEndDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getPsh5_ReportIntervalEndDate() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public CQ getQuantityManufactured() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getPsh6_QuantityManufactured() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getQuantityDistributed() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getPsh7_QuantityDistributed() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getQuantityDistributedMethod() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getPsh8_QuantityDistributedMethod() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public FT getQuantityDistributedComment() {
        FT retVal = (FT)this.getTypedField(9, 0);
        return retVal;
    }

    public FT getPsh9_QuantityDistributedComment() {
        FT retVal = (FT)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getQuantityInUse() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getPsh10_QuantityInUse() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getQuantityInUseMethod() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPsh11_QuantityInUseMethod() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public FT getQuantityInUseComment() {
        FT retVal = (FT)this.getTypedField(12, 0);
        return retVal;
    }

    public FT getPsh12_QuantityInUseComment() {
        FT retVal = (FT)this.getTypedField(12, 0);
        return retVal;
    }

    public NM[] getNumberOfProductExperienceReportsFiledByFacility() {
        NM[] retVal = (NM[])this.getTypedField(13, new NM[0]);
        return retVal;
    }

    public NM[] getPsh13_NumberOfProductExperienceReportsFiledByFacility() {
        NM[] retVal = (NM[])this.getTypedField(13, new NM[0]);
        return retVal;
    }

    public int getNumberOfProductExperienceReportsFiledByFacilityReps() {
        return this.getReps(13);
    }

    public NM getNumberOfProductExperienceReportsFiledByFacility(int rep) {
        NM retVal = (NM)this.getTypedField(13, rep);
        return retVal;
    }

    public NM getPsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) {
        NM retVal = (NM)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPsh13_NumberOfProductExperienceReportsFiledByFacilityReps() {
        return this.getReps(13);
    }

    public NM insertNumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(13, rep);
    }

    public NM insertPsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(13, rep);
    }

    public NM removeNumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(13, rep);
    }

    public NM removePsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(13, rep);
    }

    public NM[] getNumberOfProductExperienceReportsFiledByDistributor() {
        NM[] retVal = (NM[])this.getTypedField(14, new NM[0]);
        return retVal;
    }

    public NM[] getPsh14_NumberOfProductExperienceReportsFiledByDistributor() {
        NM[] retVal = (NM[])this.getTypedField(14, new NM[0]);
        return retVal;
    }

    public int getNumberOfProductExperienceReportsFiledByDistributorReps() {
        return this.getReps(14);
    }

    public NM getNumberOfProductExperienceReportsFiledByDistributor(int rep) {
        NM retVal = (NM)this.getTypedField(14, rep);
        return retVal;
    }

    public NM getPsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) {
        NM retVal = (NM)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPsh14_NumberOfProductExperienceReportsFiledByDistributorReps() {
        return this.getReps(14);
    }

    public NM insertNumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(14, rep);
    }

    public NM insertPsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(14, rep);
    }

    public NM removeNumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(14, rep);
    }

    public NM removePsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(14, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new CQ(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(329));
            }
            case 8: {
                return new FT(this.getMessage());
            }
            case 9: {
                return new CQ(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(329));
            }
            case 11: {
                return new FT(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

