/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CP;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.CX;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PMT
extends AbstractSegment {
    public PMT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment/Remittance Advice Number");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment/Remittance Effective Date/Time");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment/Remittance Expiration Date/Time");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment Method");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment/Remittance Date/Time");
            this.add(CP.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment/Remittance Amount");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Check Number");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Payee Bank Identification");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Payee Transit Number");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Payee Bank Account ID");
            this.add(XON.class, true, 1, 0, new Object[]{this.getMessage()}, "Payment Organization");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "ESR-Code-Line");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PMT - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getPaymentRemittanceAdviceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPmt1_PaymentRemittanceAdviceNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getPaymentRemittanceEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getPmt2_PaymentRemittanceEffectiveDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getPaymentRemittanceExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getPmt3_PaymentRemittanceExpirationDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getPaymentMethod() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getPmt4_PaymentMethod() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getPaymentRemittanceDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getPmt5_PaymentRemittanceDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getPaymentRemittanceAmount() {
        CP retVal = (CP)this.getTypedField(6, 0);
        return retVal;
    }

    public CP getPmt6_PaymentRemittanceAmount() {
        CP retVal = (CP)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getCheckNumber() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getPmt7_CheckNumber() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public XON getPayeeBankIdentification() {
        XON retVal = (XON)this.getTypedField(8, 0);
        return retVal;
    }

    public XON getPmt8_PayeeBankIdentification() {
        XON retVal = (XON)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getPayeeTransitNumber() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getPmt9_PayeeTransitNumber() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public CX getPayeeBankAccountID() {
        CX retVal = (CX)this.getTypedField(10, 0);
        return retVal;
    }

    public CX getPmt10_PayeeBankAccountID() {
        CX retVal = (CX)this.getTypedField(10, 0);
        return retVal;
    }

    public XON getPaymentOrganization() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public XON getPmt11_PaymentOrganization() {
        XON retVal = (XON)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getESRCodeLine() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getPmt12_ESRCodeLine() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new CP(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new XON(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new XON(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

