/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v28.group.MDM_T02_COMMON_ORDER;
import ca.uhn.hl7v2.model.v28.group.MDM_T02_OBXNTE;
import ca.uhn.hl7v2.model.v28.segment.CON_;
import ca.uhn.hl7v2.model.v28.segment.EVN;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.PV1;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.TXA;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MDM_T02
extends AbstractMessage {
    public MDM_T02() {
        this(new DefaultModelClassFactory());
    }

    public MDM_T02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PV1.class, true, false);
            this.add(MDM_T02_COMMON_ORDER.class, false, true);
            this.add(TXA.class, true, false);
            this.add(CON_.class, false, true);
            this.add(MDM_T02_OBXNTE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MDM_T02 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public MDM_T02_COMMON_ORDER getCOMMON_ORDER() {
        return this.getTyped("COMMON_ORDER", MDM_T02_COMMON_ORDER.class);
    }

    public MDM_T02_COMMON_ORDER getCOMMON_ORDER(int rep) {
        return this.getTyped("COMMON_ORDER", rep, MDM_T02_COMMON_ORDER.class);
    }

    public int getCOMMON_ORDERReps() {
        return this.getReps("COMMON_ORDER");
    }

    public List<MDM_T02_COMMON_ORDER> getCOMMON_ORDERAll() throws HL7Exception {
        return this.getAllAsList("COMMON_ORDER", MDM_T02_COMMON_ORDER.class);
    }

    public void insertCOMMON_ORDER(MDM_T02_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", structure, rep);
    }

    public MDM_T02_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (MDM_T02_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public MDM_T02_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (MDM_T02_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }

    public TXA getTXA() {
        return this.getTyped("TXA", TXA.class);
    }

    public CON_ getCON_() {
        return this.getTyped("CON_", CON_.class);
    }

    public CON_ getCON_(int rep) {
        return this.getTyped("CON_", rep, CON_.class);
    }

    public int getCON_Reps() {
        return this.getReps("CON_");
    }

    public List<CON_> getCON_All() throws HL7Exception {
        return this.getAllAsList("CON_", CON_.class);
    }

    public void insertCON_(CON_ structure, int rep) throws HL7Exception {
        super.insertRepetition("CON_", structure, rep);
    }

    public CON_ insertCON_(int rep) throws HL7Exception {
        return (CON_)super.insertRepetition("CON_", rep);
    }

    public CON_ removeCON_(int rep) throws HL7Exception {
        return (CON_)super.removeRepetition("CON_", rep);
    }

    public MDM_T02_OBXNTE getOBXNTE() {
        return this.getTyped("OBXNTE", MDM_T02_OBXNTE.class);
    }

    public MDM_T02_OBXNTE getOBXNTE(int rep) {
        return this.getTyped("OBXNTE", rep, MDM_T02_OBXNTE.class);
    }

    public int getOBXNTEReps() {
        return this.getReps("OBXNTE");
    }

    public List<MDM_T02_OBXNTE> getOBXNTEAll() throws HL7Exception {
        return this.getAllAsList("OBXNTE", MDM_T02_OBXNTE.class);
    }

    public void insertOBXNTE(MDM_T02_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", structure, rep);
    }

    public MDM_T02_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (MDM_T02_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public MDM_T02_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (MDM_T02_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }
}

