/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.FN;
import ca.uhn.hl7v2.model.v28.datatype.HD;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.ST;

public class XCN
extends AbstractComposite {
    private Type[] data;

    public XCN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[25];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new ST(this.getMessage());
        this.data[7] = new CWE(this.getMessage());
        this.data[8] = new HD(this.getMessage());
        this.data[9] = new ID(this.getMessage(), 200);
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ID(this.getMessage(), 61);
        this.data[12] = new ID(this.getMessage(), 203);
        this.data[13] = new HD(this.getMessage());
        this.data[14] = new ID(this.getMessage(), 465);
        this.data[15] = new CWE(this.getMessage());
        this.data[16] = new ST(this.getMessage());
        this.data[17] = new ID(this.getMessage(), 444);
        this.data[18] = new DTM(this.getMessage());
        this.data[19] = new DTM(this.getMessage());
        this.data[20] = new ST(this.getMessage());
        this.data[21] = new CWE(this.getMessage());
        this.data[22] = new CWE(this.getMessage());
        this.data[23] = new ST(this.getMessage());
        this.data[24] = new ID(this.getMessage(), 904);
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getPersonIdentifier() {
        return this.getTyped(0, ST.class);
    }

    public ST getXcn1_PersonIdentifier() {
        return this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return this.getTyped(1, FN.class);
    }

    public FN getXcn2_FamilyName() {
        return this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getXcn3_GivenName() {
        return this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getXcn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getXcn5_SuffixEgJRorIII() {
        return this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public ST getXcn6_PrefixEgDR() {
        return this.getTyped(5, ST.class);
    }

    public ST getDegreeEgMD() {
        return this.getTyped(6, ST.class);
    }

    public ST getXcn7_DegreeEgMD() {
        return this.getTyped(6, ST.class);
    }

    public CWE getSourceTable() {
        return this.getTyped(7, CWE.class);
    }

    public CWE getXcn8_SourceTable() {
        return this.getTyped(7, CWE.class);
    }

    public HD getAssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public HD getXcn9_AssigningAuthority() {
        return this.getTyped(8, HD.class);
    }

    public ID getNameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ID getXcn10_NameTypeCode() {
        return this.getTyped(9, ID.class);
    }

    public ST getIdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ST getXcn11_IdentifierCheckDigit() {
        return this.getTyped(10, ST.class);
    }

    public ID getCheckDigitScheme() {
        return this.getTyped(11, ID.class);
    }

    public ID getXcn12_CheckDigitScheme() {
        return this.getTyped(11, ID.class);
    }

    public ID getIdentifierTypeCode() {
        return this.getTyped(12, ID.class);
    }

    public ID getXcn13_IdentifierTypeCode() {
        return this.getTyped(12, ID.class);
    }

    public HD getAssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public HD getXcn14_AssigningFacility() {
        return this.getTyped(13, HD.class);
    }

    public ID getNameRepresentationCode() {
        return this.getTyped(14, ID.class);
    }

    public ID getXcn15_NameRepresentationCode() {
        return this.getTyped(14, ID.class);
    }

    public CWE getNameContext() {
        return this.getTyped(15, CWE.class);
    }

    public CWE getXcn16_NameContext() {
        return this.getTyped(15, CWE.class);
    }

    public ST getNameValidityRange() {
        return this.getTyped(16, ST.class);
    }

    public ST getXcn17_NameValidityRange() {
        return this.getTyped(16, ST.class);
    }

    public ID getNameAssemblyOrder() {
        return this.getTyped(17, ID.class);
    }

    public ID getXcn18_NameAssemblyOrder() {
        return this.getTyped(17, ID.class);
    }

    public DTM getEffectiveDate() {
        return this.getTyped(18, DTM.class);
    }

    public DTM getXcn19_EffectiveDate() {
        return this.getTyped(18, DTM.class);
    }

    public DTM getExpirationDate() {
        return this.getTyped(19, DTM.class);
    }

    public DTM getXcn20_ExpirationDate() {
        return this.getTyped(19, DTM.class);
    }

    public ST getProfessionalSuffix() {
        return this.getTyped(20, ST.class);
    }

    public ST getXcn21_ProfessionalSuffix() {
        return this.getTyped(20, ST.class);
    }

    public CWE getAssigningJurisdiction() {
        return this.getTyped(21, CWE.class);
    }

    public CWE getXcn22_AssigningJurisdiction() {
        return this.getTyped(21, CWE.class);
    }

    public CWE getAssigningAgencyOrDepartment() {
        return this.getTyped(22, CWE.class);
    }

    public CWE getXcn23_AssigningAgencyOrDepartment() {
        return this.getTyped(22, CWE.class);
    }

    public ST getSecurityCheck() {
        return this.getTyped(23, ST.class);
    }

    public ST getXcn24_SecurityCheck() {
        return this.getTyped(23, ST.class);
    }

    public ID getSecurityCheckScheme() {
        return this.getTyped(24, ID.class);
    }

    public ID getXcn25_SecurityCheckScheme() {
        return this.getTyped(24, ID.class);
    }
}

