/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.TX;
import ca.uhn.hl7v2.model.v27.datatype.XAD;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM1
extends AbstractSegment {
    public OM1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Producer's Service/Test/Observation ID");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(125)}, "Permitted Data Types");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Specimen Required");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Producer ID");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Observation Description");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Other Service/Test/Observation IDs for the Observation");
            this.add(ST.class, true, 0, 0, new Object[]{this.getMessage()}, "Other Names");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Preferred Report Name for the Observation");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "Preferred Short Name or Mnemonic for the Observation");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Preferred Long Name for the Observation");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Orderability");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Identity of Instrument Used to Perform this Study");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Coded Representation of Method");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Portable Device Indicator");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Observation Producing Department/Section");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Telephone Number of Section");
            this.add(CWE.class, true, 1, 1, new Object[]{this.getMessage()}, "Nature of Service/Test/Observation");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Report Subheader");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Report Display Order");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Date/Time Stamp for Any Change in Definition for the Observation");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Effective Date/Time of Change");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Typical Turn-Around Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Processing Time");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(168)}, "Processing Priority");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(169)}, "Reporting Priority");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Outside Site(s) Where Observation May Be Performed");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Address of Outside Site(s)");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Phone Number of Outside Site");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Confidentiality Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Observations Required to Interpret this Observation");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Interpretation of Observations");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Contraindications to Observations");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Reflex Tests/Observations");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Rules that Trigger Reflex Testing");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Fixed Canned Message");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Preparation");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Procedure Medication");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Factors that may Affect the Observation");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Service/Test/Observation Performance Schedule");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Description of Test Methods");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Kind of Quantity Observed");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Point Versus Interval");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Challenge Information");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Relationship Modifier");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Target Anatomic Site Of Test");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Modality of Imaging Measurement");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM1 - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm11_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getProducerSServiceTestObservationID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOm12_ProducerSServiceTestObservationID() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ID[] getPermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(3, new ID[0]);
        return retVal;
    }

    public ID[] getOm13_PermittedDataTypes() {
        ID[] retVal = (ID[])this.getTypedField(3, new ID[0]);
        return retVal;
    }

    public int getPermittedDataTypesReps() {
        return this.getReps(3);
    }

    public ID getPermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public ID getOm13_PermittedDataTypes(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm13_PermittedDataTypesReps() {
        return this.getReps(3);
    }

    public ID insertPermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertOm13_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removePermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removeOm13_PermittedDataTypes(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID getSpecimenRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOm14_SpecimenRequired() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getProducerID() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getOm15_ProducerID() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getObservationDescription() {
        TX retVal = (TX)this.getTypedField(6, 0);
        return retVal;
    }

    public TX getOm16_ObservationDescription() {
        TX retVal = (TX)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getOtherServiceTestObservationIDsForTheObservation() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getOm17_OtherServiceTestObservationIDsForTheObservation() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public ST[] getOtherNames() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public ST[] getOm18_OtherNames() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public int getOtherNamesReps() {
        return this.getReps(8);
    }

    public ST getOtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public ST getOm18_OtherNames(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public int getOm18_OtherNamesReps() {
        return this.getReps(8);
    }

    public ST insertOtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST insertOm18_OtherNames(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST removeOtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST removeOm18_OtherNames(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST getPreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getOm19_PreferredReportNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getPreferredShortNameOrMnemonicForTheObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getOm110_PreferredShortNameOrMnemonicForTheObservation() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getPreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getOm111_PreferredLongNameForTheObservation() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOrderability() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getOm112_Orderability() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE[] getIdentityOfInstrumentUsedToPerformThisStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm113_IdentityOfInstrumentUsedToPerformThisStudy() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public int getIdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(13);
    }

    public CWE getIdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public CWE getOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getOm113_IdentityOfInstrumentUsedToPerformThisStudyReps() {
        return this.getReps(13);
    }

    public CWE insertIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE insertOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE removeIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE removeOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE[] getCodedRepresentationOfMethod() {
        CWE[] retVal = (CWE[])this.getTypedField(14, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm114_CodedRepresentationOfMethod() {
        CWE[] retVal = (CWE[])this.getTypedField(14, new CWE[0]);
        return retVal;
    }

    public int getCodedRepresentationOfMethodReps() {
        return this.getReps(14);
    }

    public CWE getCodedRepresentationOfMethod(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public CWE getOm114_CodedRepresentationOfMethod(int rep) {
        CWE retVal = (CWE)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOm114_CodedRepresentationOfMethodReps() {
        return this.getReps(14);
    }

    public CWE insertCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE insertOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(14, rep);
    }

    public CWE removeCodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public CWE removeOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(14, rep);
    }

    public ID getPortableDeviceIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getOm115_PortableDeviceIndicator() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE[] getObservationProducingDepartmentSection() {
        CWE[] retVal = (CWE[])this.getTypedField(16, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm116_ObservationProducingDepartmentSection() {
        CWE[] retVal = (CWE[])this.getTypedField(16, new CWE[0]);
        return retVal;
    }

    public int getObservationProducingDepartmentSectionReps() {
        return this.getReps(16);
    }

    public CWE getObservationProducingDepartmentSection(int rep) {
        CWE retVal = (CWE)this.getTypedField(16, rep);
        return retVal;
    }

    public CWE getOm116_ObservationProducingDepartmentSection(int rep) {
        CWE retVal = (CWE)this.getTypedField(16, rep);
        return retVal;
    }

    public int getOm116_ObservationProducingDepartmentSectionReps() {
        return this.getReps(16);
    }

    public CWE insertObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(16, rep);
    }

    public CWE insertOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(16, rep);
    }

    public CWE removeObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(16, rep);
    }

    public CWE removeOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(16, rep);
    }

    public XTN getTelephoneNumberOfSection() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public XTN getOm117_TelephoneNumberOfSection() {
        XTN retVal = (XTN)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getNatureOfServiceTestObservation() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getOm118_NatureOfServiceTestObservation() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getReportSubheader() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getOm119_ReportSubheader() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getOm120_ReportDisplayOrder() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public DTM getDateTimeStampForAnyChangeInDefinitionForTheObservation() {
        DTM retVal = (DTM)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getOm121_DateTimeStampForAnyChangeInDefinitionForTheObservation() {
        DTM retVal = (DTM)this.getTypedField(21, 0);
        return retVal;
    }

    public DTM getEffectiveDateTimeOfChange() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public DTM getOm122_EffectiveDateTimeOfChange() {
        DTM retVal = (DTM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getTypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getOm123_TypicalTurnAroundTime() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getProcessingTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getOm124_ProcessingTime() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public ID[] getProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(25, new ID[0]);
        return retVal;
    }

    public ID[] getOm125_ProcessingPriority() {
        ID[] retVal = (ID[])this.getTypedField(25, new ID[0]);
        return retVal;
    }

    public int getProcessingPriorityReps() {
        return this.getReps(25);
    }

    public ID getProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(25, rep);
        return retVal;
    }

    public ID getOm125_ProcessingPriority(int rep) {
        ID retVal = (ID)this.getTypedField(25, rep);
        return retVal;
    }

    public int getOm125_ProcessingPriorityReps() {
        return this.getReps(25);
    }

    public ID insertProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(25, rep);
    }

    public ID insertOm125_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(25, rep);
    }

    public ID removeProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(25, rep);
    }

    public ID removeOm125_ProcessingPriority(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(25, rep);
    }

    public ID getReportingPriority() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getOm126_ReportingPriority() {
        ID retVal = (ID)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE[] getOutsideSiteSWhereObservationMayBePerformed() {
        CWE[] retVal = (CWE[])this.getTypedField(27, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm127_OutsideSiteSWhereObservationMayBePerformed() {
        CWE[] retVal = (CWE[])this.getTypedField(27, new CWE[0]);
        return retVal;
    }

    public int getOutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(27);
    }

    public CWE getOutsideSiteSWhereObservationMayBePerformed(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public CWE getOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public int getOm127_OutsideSiteSWhereObservationMayBePerformedReps() {
        return this.getReps(27);
    }

    public CWE insertOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE insertOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE removeOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public CWE removeOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public XAD[] getAddressOfOutsideSiteS() {
        XAD[] retVal = (XAD[])this.getTypedField(28, new XAD[0]);
        return retVal;
    }

    public XAD[] getOm128_AddressOfOutsideSiteS() {
        XAD[] retVal = (XAD[])this.getTypedField(28, new XAD[0]);
        return retVal;
    }

    public int getAddressOfOutsideSiteSReps() {
        return this.getReps(28);
    }

    public XAD getAddressOfOutsideSiteS(int rep) {
        XAD retVal = (XAD)this.getTypedField(28, rep);
        return retVal;
    }

    public XAD getOm128_AddressOfOutsideSiteS(int rep) {
        XAD retVal = (XAD)this.getTypedField(28, rep);
        return retVal;
    }

    public int getOm128_AddressOfOutsideSiteSReps() {
        return this.getReps(28);
    }

    public XAD insertAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(28, rep);
    }

    public XAD insertOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(28, rep);
    }

    public XAD removeAddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(28, rep);
    }

    public XAD removeOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(28, rep);
    }

    public XTN getPhoneNumberOfOutsideSite() {
        XTN retVal = (XTN)this.getTypedField(29, 0);
        return retVal;
    }

    public XTN getOm129_PhoneNumberOfOutsideSite() {
        XTN retVal = (XTN)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getOm130_ConfidentialityCode() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getObservationsRequiredToInterpretThisObservation() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getOm131_ObservationsRequiredToInterpretThisObservation() {
        CWE retVal = (CWE)this.getTypedField(31, 0);
        return retVal;
    }

    public TX getInterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(32, 0);
        return retVal;
    }

    public TX getOm132_InterpretationOfObservations() {
        TX retVal = (TX)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getContraindicationsToObservations() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getOm133_ContraindicationsToObservations() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE[] getReflexTestsObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(34, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm134_ReflexTestsObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(34, new CWE[0]);
        return retVal;
    }

    public int getReflexTestsObservationsReps() {
        return this.getReps(34);
    }

    public CWE getReflexTestsObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(34, rep);
        return retVal;
    }

    public CWE getOm134_ReflexTestsObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(34, rep);
        return retVal;
    }

    public int getOm134_ReflexTestsObservationsReps() {
        return this.getReps(34);
    }

    public CWE insertReflexTestsObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(34, rep);
    }

    public CWE insertOm134_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(34, rep);
    }

    public CWE removeReflexTestsObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(34, rep);
    }

    public CWE removeOm134_ReflexTestsObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(34, rep);
    }

    public TX getRulesThatTriggerReflexTesting() {
        TX retVal = (TX)this.getTypedField(35, 0);
        return retVal;
    }

    public TX getOm135_RulesThatTriggerReflexTesting() {
        TX retVal = (TX)this.getTypedField(35, 0);
        return retVal;
    }

    public CWE getFixedCannedMessage() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public CWE getOm136_FixedCannedMessage() {
        CWE retVal = (CWE)this.getTypedField(36, 0);
        return retVal;
    }

    public TX getPatientPreparation() {
        TX retVal = (TX)this.getTypedField(37, 0);
        return retVal;
    }

    public TX getOm137_PatientPreparation() {
        TX retVal = (TX)this.getTypedField(37, 0);
        return retVal;
    }

    public CWE getProcedureMedication() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getOm138_ProcedureMedication() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public TX getFactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(39, 0);
        return retVal;
    }

    public TX getOm139_FactorsThatMayAffectTheObservation() {
        TX retVal = (TX)this.getTypedField(39, 0);
        return retVal;
    }

    public ST[] getServiceTestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(40, new ST[0]);
        return retVal;
    }

    public ST[] getOm140_ServiceTestObservationPerformanceSchedule() {
        ST[] retVal = (ST[])this.getTypedField(40, new ST[0]);
        return retVal;
    }

    public int getServiceTestObservationPerformanceScheduleReps() {
        return this.getReps(40);
    }

    public ST getServiceTestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(40, rep);
        return retVal;
    }

    public ST getOm140_ServiceTestObservationPerformanceSchedule(int rep) {
        ST retVal = (ST)this.getTypedField(40, rep);
        return retVal;
    }

    public int getOm140_ServiceTestObservationPerformanceScheduleReps() {
        return this.getReps(40);
    }

    public ST insertServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(40, rep);
    }

    public ST insertOm140_ServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(40, rep);
    }

    public ST removeServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(40, rep);
    }

    public ST removeOm140_ServiceTestObservationPerformanceSchedule(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(40, rep);
    }

    public TX getDescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(41, 0);
        return retVal;
    }

    public TX getOm141_DescriptionOfTestMethods() {
        TX retVal = (TX)this.getTypedField(41, 0);
        return retVal;
    }

    public CWE getKindOfQuantityObserved() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE getOm142_KindOfQuantityObserved() {
        CWE retVal = (CWE)this.getTypedField(42, 0);
        return retVal;
    }

    public CWE getPointVersusInterval() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public CWE getOm143_PointVersusInterval() {
        CWE retVal = (CWE)this.getTypedField(43, 0);
        return retVal;
    }

    public TX getChallengeInformation() {
        TX retVal = (TX)this.getTypedField(44, 0);
        return retVal;
    }

    public TX getOm144_ChallengeInformation() {
        TX retVal = (TX)this.getTypedField(44, 0);
        return retVal;
    }

    public CWE getRelationshipModifier() {
        CWE retVal = (CWE)this.getTypedField(45, 0);
        return retVal;
    }

    public CWE getOm145_RelationshipModifier() {
        CWE retVal = (CWE)this.getTypedField(45, 0);
        return retVal;
    }

    public CWE getTargetAnatomicSiteOfTest() {
        CWE retVal = (CWE)this.getTypedField(46, 0);
        return retVal;
    }

    public CWE getOm146_TargetAnatomicSiteOfTest() {
        CWE retVal = (CWE)this.getTypedField(46, 0);
        return retVal;
    }

    public CWE getModalityOfImagingMeasurement() {
        CWE retVal = (CWE)this.getTypedField(47, 0);
        return retVal;
    }

    public CWE getOm147_ModalityOfImagingMeasurement() {
        CWE retVal = (CWE)this.getTypedField(47, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new TX(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new XTN(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new DTM(this.getMessage());
            }
            case 21: {
                return new DTM(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(168));
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(169));
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new XAD(this.getMessage());
            }
            case 28: {
                return new XTN(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new TX(this.getMessage());
            }
            case 32: {
                return new CWE(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
            case 34: {
                return new TX(this.getMessage());
            }
            case 35: {
                return new CWE(this.getMessage());
            }
            case 36: {
                return new TX(this.getMessage());
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new TX(this.getMessage());
            }
            case 39: {
                return new ST(this.getMessage());
            }
            case 40: {
                return new TX(this.getMessage());
            }
            case 41: {
                return new CWE(this.getMessage());
            }
            case 42: {
                return new CWE(this.getMessage());
            }
            case 43: {
                return new TX(this.getMessage());
            }
            case 44: {
                return new CWE(this.getMessage());
            }
            case 45: {
                return new CWE(this.getMessage());
            }
            case 46: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

