/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.OSM_R26_PATIENT_VISIT_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.NK1;
import ca.uhn.hl7v2.model.v27.segment.PID;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.PV1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION
extends AbstractGroup {
    public OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PV1.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OSM_R26_PATIENT_VISIT_OBSERVATION.class, false, true, false);
            this.add(PID.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(NK1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OSM_R26_PATIENT_VISIT_OBSERVATION getPATIENT_VISIT_OBSERVATION() {
        OSM_R26_PATIENT_VISIT_OBSERVATION retVal = this.getTyped("PATIENT_VISIT_OBSERVATION", OSM_R26_PATIENT_VISIT_OBSERVATION.class);
        return retVal;
    }

    public OSM_R26_PATIENT_VISIT_OBSERVATION getPATIENT_VISIT_OBSERVATION(int rep) {
        OSM_R26_PATIENT_VISIT_OBSERVATION retVal = this.getTyped("PATIENT_VISIT_OBSERVATION", rep, OSM_R26_PATIENT_VISIT_OBSERVATION.class);
        return retVal;
    }

    public int getPATIENT_VISIT_OBSERVATIONReps() {
        return this.getReps("PATIENT_VISIT_OBSERVATION");
    }

    public List<OSM_R26_PATIENT_VISIT_OBSERVATION> getPATIENT_VISIT_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISIT_OBSERVATION", OSM_R26_PATIENT_VISIT_OBSERVATION.class);
    }

    public void insertPATIENT_VISIT_OBSERVATION(OSM_R26_PATIENT_VISIT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISIT_OBSERVATION", structure, rep);
    }

    public OSM_R26_PATIENT_VISIT_OBSERVATION insertPATIENT_VISIT_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_PATIENT_VISIT_OBSERVATION)super.insertRepetition("PATIENT_VISIT_OBSERVATION", rep);
    }

    public OSM_R26_PATIENT_VISIT_OBSERVATION removePATIENT_VISIT_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_PATIENT_VISIT_OBSERVATION)super.removeRepetition("PATIENT_VISIT_OBSERVATION", rep);
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PRT getPRT2() {
        PRT retVal = this.getTyped("PRT2", PRT.class);
        return retVal;
    }

    public PRT getPRT2(int rep) {
        PRT retVal = this.getTyped("PRT2", rep, PRT.class);
        return retVal;
    }

    public int getPRT2Reps() {
        return this.getReps("PRT2");
    }

    public List<PRT> getPRT2All() throws HL7Exception {
        return this.getAllAsList("PRT2", PRT.class);
    }

    public void insertPRT2(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT2", structure, rep);
    }

    public PRT insertPRT2(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT2", rep);
    }

    public PRT removePRT2(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT2", rep);
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }
}

