/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.RPT;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.TM;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class TQ1
extends AbstractSegment {
    public TQ1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - TQ1");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Quantity");
            this.add(RPT.class, false, 0, 540, new Object[]{this.getMessage()}, "Repeat Pattern");
            this.add(TM.class, false, 0, 20, new Object[]{this.getMessage()}, "Explicit Time");
            this.add(CQ.class, false, 0, 20, new Object[]{this.getMessage()}, "Relative Time and Units");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Service Duration");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Start date/time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "End date/time");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Priority");
            this.add(TX.class, false, 1, 250, new Object[]{this.getMessage()}, "Condition text");
            this.add(TX.class, false, 1, 250, new Object[]{this.getMessage()}, "Text instruction");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(472)}, "Conjunction");
            this.add(CQ.class, false, 1, 20, new Object[]{this.getMessage()}, "Occurrence duration");
            this.add(NM.class, false, 1, 10, new Object[]{this.getMessage()}, "Total occurrences");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating TQ1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDTQ1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getTq11_SetIDTQ1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CQ getQuantity() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    public CQ getTq12_Quantity() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    public RPT[] getRepeatPattern() {
        RPT[] retVal = (RPT[])this.getTypedField(3, new RPT[0]);
        return retVal;
    }

    public RPT[] getTq13_RepeatPattern() {
        RPT[] retVal = (RPT[])this.getTypedField(3, new RPT[0]);
        return retVal;
    }

    public int getRepeatPatternReps() {
        return this.getReps(3);
    }

    public RPT getRepeatPattern(int rep) {
        RPT retVal = (RPT)this.getTypedField(3, rep);
        return retVal;
    }

    public RPT getTq13_RepeatPattern(int rep) {
        RPT retVal = (RPT)this.getTypedField(3, rep);
        return retVal;
    }

    public int getTq13_RepeatPatternReps() {
        return this.getReps(3);
    }

    public RPT insertRepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.insertRepetition(3, rep);
    }

    public RPT insertTq13_RepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.insertRepetition(3, rep);
    }

    public RPT removeRepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.removeRepetition(3, rep);
    }

    public RPT removeTq13_RepeatPattern(int rep) throws HL7Exception {
        return (RPT)super.removeRepetition(3, rep);
    }

    public TM[] getExplicitTime() {
        TM[] retVal = (TM[])this.getTypedField(4, new TM[0]);
        return retVal;
    }

    public TM[] getTq14_ExplicitTime() {
        TM[] retVal = (TM[])this.getTypedField(4, new TM[0]);
        return retVal;
    }

    public int getExplicitTimeReps() {
        return this.getReps(4);
    }

    public TM getExplicitTime(int rep) {
        TM retVal = (TM)this.getTypedField(4, rep);
        return retVal;
    }

    public TM getTq14_ExplicitTime(int rep) {
        TM retVal = (TM)this.getTypedField(4, rep);
        return retVal;
    }

    public int getTq14_ExplicitTimeReps() {
        return this.getReps(4);
    }

    public TM insertExplicitTime(int rep) throws HL7Exception {
        return (TM)super.insertRepetition(4, rep);
    }

    public TM insertTq14_ExplicitTime(int rep) throws HL7Exception {
        return (TM)super.insertRepetition(4, rep);
    }

    public TM removeExplicitTime(int rep) throws HL7Exception {
        return (TM)super.removeRepetition(4, rep);
    }

    public TM removeTq14_ExplicitTime(int rep) throws HL7Exception {
        return (TM)super.removeRepetition(4, rep);
    }

    public CQ[] getRelativeTimeAndUnits() {
        CQ[] retVal = (CQ[])this.getTypedField(5, new CQ[0]);
        return retVal;
    }

    public CQ[] getTq15_RelativeTimeAndUnits() {
        CQ[] retVal = (CQ[])this.getTypedField(5, new CQ[0]);
        return retVal;
    }

    public int getRelativeTimeAndUnitsReps() {
        return this.getReps(5);
    }

    public CQ getRelativeTimeAndUnits(int rep) {
        CQ retVal = (CQ)this.getTypedField(5, rep);
        return retVal;
    }

    public CQ getTq15_RelativeTimeAndUnits(int rep) {
        CQ retVal = (CQ)this.getTypedField(5, rep);
        return retVal;
    }

    public int getTq15_RelativeTimeAndUnitsReps() {
        return this.getReps(5);
    }

    public CQ insertRelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.insertRepetition(5, rep);
    }

    public CQ insertTq15_RelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.insertRepetition(5, rep);
    }

    public CQ removeRelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.removeRepetition(5, rep);
    }

    public CQ removeTq15_RelativeTimeAndUnits(int rep) throws HL7Exception {
        return (CQ)super.removeRepetition(5, rep);
    }

    public CQ getServiceDuration() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getTq16_ServiceDuration() {
        CQ retVal = (CQ)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getTq17_StartDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getTq18_EndDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getPriority() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public CWE[] getTq19_Priority() {
        CWE[] retVal = (CWE[])this.getTypedField(9, new CWE[0]);
        return retVal;
    }

    public int getPriorityReps() {
        return this.getReps(9);
    }

    public CWE getPriority(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getTq19_Priority(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getTq19_PriorityReps() {
        return this.getReps(9);
    }

    public CWE insertPriority(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertTq19_Priority(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removePriority(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeTq19_Priority(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public TX getConditionText() {
        TX retVal = (TX)this.getTypedField(10, 0);
        return retVal;
    }

    public TX getTq110_ConditionText() {
        TX retVal = (TX)this.getTypedField(10, 0);
        return retVal;
    }

    public TX getTextInstruction() {
        TX retVal = (TX)this.getTypedField(11, 0);
        return retVal;
    }

    public TX getTq111_TextInstruction() {
        TX retVal = (TX)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getConjunction() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getTq112_Conjunction() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getOccurrenceDuration() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public CQ getTq113_OccurrenceDuration() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getTotalOccurrences() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getTq114_TotalOccurrences() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CQ(this.getMessage());
            }
            case 2: {
                return new RPT(this.getMessage());
            }
            case 3: {
                return new TM(this.getMessage());
            }
            case 4: {
                return new CQ(this.getMessage());
            }
            case 5: {
                return new CQ(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new TX(this.getMessage());
            }
            case 10: {
                return new TX(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(472));
            }
            case 12: {
                return new CQ(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

