/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.SLT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SLR_S28
extends AbstractMessage {
    public SLR_S28() {
        this(new DefaultModelClassFactory());
    }

    public SLR_S28(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(SLT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SLR_S28 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public SLT getSLT() {
        return this.getTyped("SLT", SLT.class);
    }

    public SLT getSLT(int rep) {
        return this.getTyped("SLT", rep, SLT.class);
    }

    public int getSLTReps() {
        return this.getReps("SLT");
    }

    public List<SLT> getSLTAll() throws HL7Exception {
        return this.getAllAsList("SLT", SLT.class);
    }

    public void insertSLT(SLT structure, int rep) throws HL7Exception {
        super.insertRepetition("SLT", structure, rep);
    }

    public SLT insertSLT(int rep) throws HL7Exception {
        return (SLT)super.insertRepetition("SLT", rep);
    }

    public SLT removeSLT(int rep) throws HL7Exception {
        return (SLT)super.removeRepetition("SLT", rep);
    }
}

