/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.model.v251.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ROL
extends AbstractSegment {
    public ROL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Role Instance ID");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Role-ROL");
            this.add(XCN.class, true, 0, 250, new Object[]{this.getMessage()}, "Role Person");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Role Begin Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Role End Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Role Duration");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Role Action Reason");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Type");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Organization Unit Type");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Office/Home Address/Birthplace");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Phone");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ROL - this is probably a bug in the source code generator.", e);
        }
    }

    public EI getRoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getRol1_RoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getRol2_ActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRoleROL() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRol3_RoleROL() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN[] getRolePerson() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public XCN[] getRol4_RolePerson() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public int getRolePersonReps() {
        return this.getReps(4);
    }

    public XCN getRolePerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getRol4_RolePerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getRol4_RolePersonReps() {
        return this.getReps(4);
    }

    public XCN insertRolePerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertRol4_RolePerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removeRolePerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removeRol4_RolePerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public TS getRoleBeginDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRol5_RoleBeginDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getRoleEndDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getRol6_RoleEndDateTime() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getRoleDuration() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRol7_RoleDuration() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRoleActionReason() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRol8_RoleActionReason() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE[] getProviderType() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public CE[] getRol9_ProviderType() {
        CE[] retVal = (CE[])this.getTypedField(9, new CE[0]);
        return retVal;
    }

    public int getProviderTypeReps() {
        return this.getReps(9);
    }

    public CE getProviderType(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public CE getRol9_ProviderType(int rep) {
        CE retVal = (CE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRol9_ProviderTypeReps() {
        return this.getReps(9);
    }

    public CE insertProviderType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE insertRol9_ProviderType(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(9, rep);
    }

    public CE removeProviderType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE removeRol9_ProviderType(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(9, rep);
    }

    public CE getOrganizationUnitType() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getRol10_OrganizationUnitType() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getOfficeHomeAddressBirthplace() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public XAD[] getRol11_OfficeHomeAddressBirthplace() {
        XAD[] retVal = (XAD[])this.getTypedField(11, new XAD[0]);
        return retVal;
    }

    public int getOfficeHomeAddressBirthplaceReps() {
        return this.getReps(11);
    }

    public XAD getOfficeHomeAddressBirthplace(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getRol11_OfficeHomeAddressBirthplace(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getRol11_OfficeHomeAddressBirthplaceReps() {
        return this.getReps(11);
    }

    public XAD insertOfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertRol11_OfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeOfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeRol11_OfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XTN[] getPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public XTN[] getRol12_Phone() {
        XTN[] retVal = (XTN[])this.getTypedField(12, new XTN[0]);
        return retVal;
    }

    public int getPhoneReps() {
        return this.getReps(12);
    }

    public XTN getPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public XTN getRol12_Phone(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getRol12_PhoneReps() {
        return this.getReps(12);
    }

    public XTN insertPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN insertRol12_Phone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN removePhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    public XTN removeRol12_Phone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

