/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.NMD_N02_CLOCK_AND_STATS_WITH_NOTES;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class NMD_N02
extends AbstractMessage {
    public NMD_N02() {
        this(new DefaultModelClassFactory());
    }

    public NMD_N02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NMD_N02_CLOCK_AND_STATS_WITH_NOTES.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NMD_N02 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NMD_N02_CLOCK_AND_STATS_WITH_NOTES getCLOCK_AND_STATS_WITH_NOTES() {
        return this.getTyped("CLOCK_AND_STATS_WITH_NOTES", NMD_N02_CLOCK_AND_STATS_WITH_NOTES.class);
    }

    public NMD_N02_CLOCK_AND_STATS_WITH_NOTES getCLOCK_AND_STATS_WITH_NOTES(int rep) {
        return this.getTyped("CLOCK_AND_STATS_WITH_NOTES", rep, NMD_N02_CLOCK_AND_STATS_WITH_NOTES.class);
    }

    public int getCLOCK_AND_STATS_WITH_NOTESReps() {
        return this.getReps("CLOCK_AND_STATS_WITH_NOTES");
    }

    public List<NMD_N02_CLOCK_AND_STATS_WITH_NOTES> getCLOCK_AND_STATS_WITH_NOTESAll() throws HL7Exception {
        return this.getAllAsList("CLOCK_AND_STATS_WITH_NOTES", NMD_N02_CLOCK_AND_STATS_WITH_NOTES.class);
    }

    public void insertCLOCK_AND_STATS_WITH_NOTES(NMD_N02_CLOCK_AND_STATS_WITH_NOTES structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES", structure, rep);
    }

    public NMD_N02_CLOCK_AND_STATS_WITH_NOTES insertCLOCK_AND_STATS_WITH_NOTES(int rep) throws HL7Exception {
        return (NMD_N02_CLOCK_AND_STATS_WITH_NOTES)super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES", rep);
    }

    public NMD_N02_CLOCK_AND_STATS_WITH_NOTES removeCLOCK_AND_STATS_WITH_NOTES(int rep) throws HL7Exception {
        return (NMD_N02_CLOCK_AND_STATS_WITH_NOTES)super.removeRepetition("CLOCK_AND_STATS_WITH_NOTES", rep);
    }
}

