/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ECR
extends AbstractSegment {
    public ECR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Command Response");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time Completed");
            this.add(ST.class, false, 0, 65536, new Object[]{this.getMessage()}, "Command Response Parameters");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ECR - this is probably a bug in the source code generator.", e);
        }
    }

    public CE getCommandResponse() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getEcr1_CommandResponse() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDateTimeCompleted() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getEcr2_DateTimeCompleted() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public ST[] getCommandResponseParameters() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public ST[] getEcr3_CommandResponseParameters() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public int getCommandResponseParametersReps() {
        return this.getReps(3);
    }

    public ST getCommandResponseParameters(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public ST getEcr3_CommandResponseParameters(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public int getEcr3_CommandResponseParametersReps() {
        return this.getReps(3);
    }

    public ST insertCommandResponseParameters(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST insertEcr3_CommandResponseParameters(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST removeCommandResponseParameters(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    public ST removeEcr3_CommandResponseParameters(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

