/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CNS
extends AbstractSegment {
    public CNS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Starting Notification Reference Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Ending Notification Reference Number");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Starting Notification Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Ending Notification Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Starting Notification Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Ending Notification Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CNS - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getStartingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getCns1_StartingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getEndingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getCns2_EndingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getStartingNotificationDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getCns3_StartingNotificationDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEndingNotificationDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getCns4_EndingNotificationDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getStartingNotificationCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getCns5_StartingNotificationCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getEndingNotificationCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getCns6_EndingNotificationCode() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

