/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.OMS_O05_ORDER;
import ca.uhn.hl7v2.model.v24.group.OMS_O05_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMS_O05
extends AbstractMessage {
    public OMS_O05() {
        this(new DefaultModelClassFactory());
    }

    public OMS_O05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMS_O05_PATIENT.class, false, false);
            this.add(OMS_O05_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMS_O05 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMS_O05_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OMS_O05_PATIENT.class);
    }

    public OMS_O05_ORDER getORDER() {
        return this.getTyped("ORDER", OMS_O05_ORDER.class);
    }

    public OMS_O05_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, OMS_O05_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OMS_O05_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OMS_O05_ORDER.class);
    }

    public void insertORDER(OMS_O05_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OMS_O05_ORDER insertORDER(int rep) throws HL7Exception {
        return (OMS_O05_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OMS_O05_ORDER removeORDER(int rep) throws HL7Exception {
        return (OMS_O05_ORDER)super.removeRepetition("ORDER", rep);
    }
}

