/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.REF_I12_RESULTS_NOTES;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class REF_I12_OBSERVATION
extends AbstractGroup {
    public REF_I12_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(REF_I12_RESULTS_NOTES.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating REF_I12_OBSERVATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public REF_I12_RESULTS_NOTES getRESULTS_NOTES() {
        REF_I12_RESULTS_NOTES retVal = this.getTyped("RESULTS_NOTES", REF_I12_RESULTS_NOTES.class);
        return retVal;
    }

    public REF_I12_RESULTS_NOTES getRESULTS_NOTES(int rep) {
        REF_I12_RESULTS_NOTES retVal = this.getTyped("RESULTS_NOTES", rep, REF_I12_RESULTS_NOTES.class);
        return retVal;
    }

    public int getRESULTS_NOTESReps() {
        return this.getReps("RESULTS_NOTES");
    }

    public List<REF_I12_RESULTS_NOTES> getRESULTS_NOTESAll() throws HL7Exception {
        return this.getAllAsList("RESULTS_NOTES", REF_I12_RESULTS_NOTES.class);
    }

    public void insertRESULTS_NOTES(REF_I12_RESULTS_NOTES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS_NOTES", structure, rep);
    }

    public REF_I12_RESULTS_NOTES insertRESULTS_NOTES(int rep) throws HL7Exception {
        return (REF_I12_RESULTS_NOTES)super.insertRepetition("RESULTS_NOTES", rep);
    }

    public REF_I12_RESULTS_NOTES removeRESULTS_NOTES(int rep) throws HL7Exception {
        return (REF_I12_RESULTS_NOTES)super.removeRepetition("RESULTS_NOTES", rep);
    }
}

