/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.BAR_P01_INSURANCE;
import ca.uhn.hl7v2.model.v24.group.BAR_P01_PROCEDURE;
import ca.uhn.hl7v2.model.v24.segment.ACC;
import ca.uhn.hl7v2.model.v24.segment.AL1;
import ca.uhn.hl7v2.model.v24.segment.DB1;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.DRG;
import ca.uhn.hl7v2.model.v24.segment.GT1;
import ca.uhn.hl7v2.model.v24.segment.NK1;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.PV1;
import ca.uhn.hl7v2.model.v24.segment.PV2;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.model.v24.segment.UB1;
import ca.uhn.hl7v2.model.v24.segment.UB2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BAR_P01_VISIT
extends AbstractGroup {
    public BAR_P01_VISIT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PV1.class, false, false, false);
            this.add(PV2.class, false, false, false);
            this.add(ROL.class, false, true, false);
            this.add(DB1.class, false, true, false);
            this.add(OBX.class, false, true, false);
            this.add(AL1.class, false, true, false);
            this.add(DG1.class, false, true, false);
            this.add(DRG.class, false, false, false);
            this.add(BAR_P01_PROCEDURE.class, false, true, false);
            this.add(GT1.class, false, true, false);
            this.add(NK1.class, false, true, false);
            this.add(BAR_P01_INSURANCE.class, false, true, false);
            this.add(ACC.class, false, false, false);
            this.add(UB1.class, false, false, false);
            this.add(UB2.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BAR_P01_VISIT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PV1 getPV1() {
        PV1 retVal = this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PV2 getPV2() {
        PV2 retVal = this.getTyped("PV2", PV2.class);
        return retVal;
    }

    public ROL getROL() {
        ROL retVal = this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public DB1 getDB1() {
        DB1 retVal = this.getTyped("DB1", DB1.class);
        return retVal;
    }

    public DB1 getDB1(int rep) {
        DB1 retVal = this.getTyped("DB1", rep, DB1.class);
        return retVal;
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        DG1 retVal = this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG retVal = this.getTyped("DRG", DRG.class);
        return retVal;
    }

    public BAR_P01_PROCEDURE getPROCEDURE() {
        BAR_P01_PROCEDURE retVal = this.getTyped("PROCEDURE", BAR_P01_PROCEDURE.class);
        return retVal;
    }

    public BAR_P01_PROCEDURE getPROCEDURE(int rep) {
        BAR_P01_PROCEDURE retVal = this.getTyped("PROCEDURE", rep, BAR_P01_PROCEDURE.class);
        return retVal;
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<BAR_P01_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", BAR_P01_PROCEDURE.class);
    }

    public void insertPROCEDURE(BAR_P01_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public BAR_P01_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (BAR_P01_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public BAR_P01_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (BAR_P01_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public GT1 getGT1(int rep) {
        GT1 retVal = this.getTyped("GT1", rep, GT1.class);
        return retVal;
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public BAR_P01_INSURANCE getINSURANCE() {
        BAR_P01_INSURANCE retVal = this.getTyped("INSURANCE", BAR_P01_INSURANCE.class);
        return retVal;
    }

    public BAR_P01_INSURANCE getINSURANCE(int rep) {
        BAR_P01_INSURANCE retVal = this.getTyped("INSURANCE", rep, BAR_P01_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<BAR_P01_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", BAR_P01_INSURANCE.class);
    }

    public void insertINSURANCE(BAR_P01_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public BAR_P01_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (BAR_P01_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public BAR_P01_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (BAR_P01_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        ACC retVal = this.getTyped("ACC", ACC.class);
        return retVal;
    }

    public UB1 getUB1() {
        UB1 retVal = this.getTyped("UB1", UB1.class);
        return retVal;
    }

    public UB2 getUB2() {
        UB2 retVal = this.getTyped("UB2", UB2.class);
        return retVal;
    }
}

