/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CN;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EVN
extends AbstractSegment {
    public EVN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(3)}, "Event Type Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Recorded Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time Planned Event");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(62)}, "Event Reason Code");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Operator ID");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Event Occurred");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EVN - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getEventTypeCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getEvn1_EventTypeCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getRecordedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getEvn2_RecordedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimePlannedEvent() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getEvn3_DateTimePlannedEvent() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getEventReasonCode() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getEvn4_EventReasonCode() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CN getOperatorID() {
        CN retVal = (CN)this.getTypedField(5, 0);
        return retVal;
    }

    public CN getEvn5_OperatorID() {
        CN retVal = (CN)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getEventOccurred() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getEvn6_EventOccurred() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(3));
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(62));
            }
            case 4: {
                return new CN(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

