/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.ORF_R02_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.QRD;
import ca.uhn.hl7v2.model.v23.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORF_R02
extends AbstractMessage {
    public ORF_R02() {
        this(new DefaultModelClassFactory());
    }

    public ORF_R02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(ORF_R02_QUERY_RESPONSE.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORF_R02 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public ORF_R02_QUERY_RESPONSE getQUERY_RESPONSE() {
        return this.getTyped("QUERY_RESPONSE", ORF_R02_QUERY_RESPONSE.class);
    }

    public ORF_R02_QUERY_RESPONSE getQUERY_RESPONSE(int rep) {
        return this.getTyped("QUERY_RESPONSE", rep, ORF_R02_QUERY_RESPONSE.class);
    }

    public int getQUERY_RESPONSEReps() {
        return this.getReps("QUERY_RESPONSE");
    }

    public List<ORF_R02_QUERY_RESPONSE> getQUERY_RESPONSEAll() throws HL7Exception {
        return this.getAllAsList("QUERY_RESPONSE", ORF_R02_QUERY_RESPONSE.class);
    }

    public void insertQUERY_RESPONSE(ORF_R02_QUERY_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("QUERY_RESPONSE", structure, rep);
    }

    public ORF_R02_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R02_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }

    public ORF_R02_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception {
        return (ORF_R02_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

