/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.CSU_C09_STUDY_PHASE;
import ca.uhn.hl7v2.model.v23.group.CSU_C09_VISIT;
import ca.uhn.hl7v2.model.v23.segment.CSR;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CSU_C09_PATIENT
extends AbstractGroup {
    public CSU_C09_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CSU_C09_VISIT.class, false, false, false);
            this.add(CSR.class, true, false, false);
            this.add(CSU_C09_STUDY_PHASE.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C09_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID retVal = this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CSU_C09_VISIT getVISIT() {
        CSU_C09_VISIT retVal = this.getTyped("VISIT", CSU_C09_VISIT.class);
        return retVal;
    }

    public CSR getCSR() {
        CSR retVal = this.getTyped("CSR", CSR.class);
        return retVal;
    }

    public CSU_C09_STUDY_PHASE getSTUDY_PHASE() {
        CSU_C09_STUDY_PHASE retVal = this.getTyped("STUDY_PHASE", CSU_C09_STUDY_PHASE.class);
        return retVal;
    }

    public CSU_C09_STUDY_PHASE getSTUDY_PHASE(int rep) {
        CSU_C09_STUDY_PHASE retVal = this.getTyped("STUDY_PHASE", rep, CSU_C09_STUDY_PHASE.class);
        return retVal;
    }

    public int getSTUDY_PHASEReps() {
        return this.getReps("STUDY_PHASE");
    }

    public List<CSU_C09_STUDY_PHASE> getSTUDY_PHASEAll() throws HL7Exception {
        return this.getAllAsList("STUDY_PHASE", CSU_C09_STUDY_PHASE.class);
    }

    public void insertSTUDY_PHASE(CSU_C09_STUDY_PHASE structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_PHASE", structure, rep);
    }

    public CSU_C09_STUDY_PHASE insertSTUDY_PHASE(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHASE)super.insertRepetition("STUDY_PHASE", rep);
    }

    public CSU_C09_STUDY_PHASE removeSTUDY_PHASE(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHASE)super.removeRepetition("STUDY_PHASE", rep);
    }
}

