/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.date;

import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.util.Calendar;

public class CalendarRange
extends Range<Calendar> {
    private static final long serialVersionUID = 1L;

    public CalendarRange() {
    }

    public CalendarRange(Calendar start, Calendar end, RangeNotation notation) {
        super(start, end, notation);
    }

    @Override
    public boolean intersect(Range<Calendar> range) {
        if (range == null) {
            throw new NullPointerException("range");
        }
        this.valid();
        range.valid();
        Calendar start1 = this.toClosedStart((Calendar)this.start, this.notation);
        Calendar end1 = this.toClosedEnd((Calendar)this.end, this.notation);
        Calendar start2 = this.toClosedStart((Calendar)range.start, range.notation);
        Calendar end2 = this.toClosedEnd((Calendar)range.end, range.notation);
        return RangeNotation.CLOSED.inRange(start2, start1, end1) || RangeNotation.CLOSED.inRange(end2, start1, end1) || RangeNotation.CLOSED.inRange(start1, start2, end2) || RangeNotation.CLOSED.inRange(end1, start2, end2);
    }

    private Calendar toClosedEnd(Calendar end, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case RIGHT_CLOSED: {
                return end;
            }
            case OPEN: 
            case LEFT_CLOSED: {
                Calendar newEnd = (Calendar)end.clone();
                newEnd.add(14, -1);
                return newEnd;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    private Calendar toClosedStart(Calendar start, RangeNotation notation) {
        switch (notation) {
            case CLOSED: 
            case LEFT_CLOSED: {
                return start;
            }
            case RIGHT_CLOSED: 
            case OPEN: {
                Calendar newStart = (Calendar)start.clone();
                newStart.add(14, 1);
                return newStart;
            }
        }
        throw new IllegalArgumentException("invalid notation " + (Object)((Object)notation));
    }

    public LocalDateRange toLocalDateRange() {
        LocalDate dstart = this.start == null ? null : LocalDate.fromCalendar((Calendar)this.start);
        LocalDate dend = this.end == null ? null : LocalDate.fromCalendar((Calendar)this.end);
        return new LocalDateRange(dstart, dend, this.notation);
    }
}

