/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.config.ConfigKey;
import ca.infodata.util1.config.ConfigurationException;

public class StringConfigKey
extends ConfigKey<String> {
    public StringConfigKey(String ... keys) {
        super(keys);
    }

    public StringConfigKey setDefaultValue(String value) {
        return (StringConfigKey)super.setDefaultValue(value);
    }

    @Override
    protected String convertFoundValueToT(Object value) {
        if (value == null) {
            return (String)this.getDefaultValue();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (StringUtils.isBlank(s)) {
                return (String)this.getDefaultValue();
            }
            return (String)value;
        }
        return String.valueOf(value);
    }

    @Override
    String getCheckedProperty() throws ConfigurationException {
        String s = (String)this.getProperty();
        if (StringUtils.isBlank(s)) {
            throw new ConfigurationException(this.getKey() + " string config key cannot be empty");
        }
        return s;
    }
}

