/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Random random = new Random();
    private static final String PLAIN_ASCII = "AaEeIiOoUuAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaEeIiOoUuYyAaCc";
    private static final String UNICODE = "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff\u00c5\u00e5\u00c7\u00e7";
    private static final char[] accentsUpper = new char[14];
    private static final char[] accentsLower;
    private static final char[][] accentsToNormal;
    private static Pattern aPattern;
    private static Pattern ePattern;
    private static Pattern iPattern;
    private static Pattern oPattern;
    private static Pattern uPattern;
    private static Pattern cPattern;
    private static Pattern aPatternl;
    private static Pattern ePatternl;
    private static Pattern iPatternl;
    private static Pattern oPatternl;
    private static Pattern uPatternl;
    private static Pattern cPatternl;
    public static final String ABBR_ENDING_DEFAULT = "[...]";
    public static final String ABBR_ENDING_NONE = "";
    public static Pattern alphaNumericFullPattern;

    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    public static String removeAccent(String s) {
        s = aPattern.matcher(s).replaceAll("A");
        s = ePattern.matcher(s).replaceAll("E");
        s = iPattern.matcher(s).replaceAll("I");
        s = oPattern.matcher(s).replaceAll("O");
        s = uPattern.matcher(s).replaceAll("U");
        s = cPattern.matcher(s).replaceAll("C");
        s = aPatternl.matcher(s).replaceAll("a");
        s = ePatternl.matcher(s).replaceAll("e");
        s = iPatternl.matcher(s).replaceAll("i");
        s = oPatternl.matcher(s).replaceAll("o");
        s = uPatternl.matcher(s).replaceAll("u");
        s = cPatternl.matcher(s).replaceAll("c");
        return s;
    }

    public static String convertNonAscii(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int pos = UNICODE.indexOf(c);
            if (pos > -1) {
                sb.append(PLAIN_ASCII.charAt(pos));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String NormalizeToUppercase(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.convertNonAscii(s.toUpperCase()).replaceAll("[^\\p{ASCII}]", ABBR_ENDING_NONE);
    }

    public static String NormalizeToLowercase(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.convertNonAscii(s.toLowerCase()).replaceAll("[^\\p{ASCII}]", ABBR_ENDING_NONE);
    }

    public static String leftPad(String s, int i, char c) {
        return org.apache.commons.lang.StringUtils.leftPad(s, i, c);
    }

    public static String rightPad(String s, int i, char c) {
        return org.apache.commons.lang.StringUtils.rightPad(s, i, c);
    }

    public static String left(String s, int i) {
        return org.apache.commons.lang.StringUtils.left(s, i);
    }

    public static String defaultString(String s) {
        return org.apache.commons.lang.StringUtils.defaultString(s);
    }

    public static String defaultString(String s, String d) {
        return org.apache.commons.lang.StringUtils.defaultString(s, d);
    }

    public static String defaultString2(Object s, String d) {
        if (s == null) {
            return d;
        }
        return String.valueOf(s);
    }

    public static boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        if (StringUtils.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtils.isNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnInteger(String s) {
        if (StringUtils.isBlank(s)) {
            return false;
        }
        s = s.trim();
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        while (i < s.length()) {
            if (!StringUtils.isNumeric(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String replaceOnce(String source, String searchFor, String replaceFor) {
        return org.apache.commons.lang.StringUtils.replaceOnce(source, searchFor, replaceFor);
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String strip(String s) {
        return org.apache.commons.lang.StringUtils.strip(s);
    }

    public static String right(String s, int i) {
        return org.apache.commons.lang.StringUtils.right(s, i);
    }

    public static String deleteWhitespace(String s) {
        return org.apache.commons.lang.StringUtils.deleteWhitespace(s);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean isBlank(CharSequence s) {
        return s == null || s.length() == 0 || s.toString().trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !StringUtils.isBlank(s);
    }

    public static String substring(String s, Integer beginIndex, Integer endIndex) {
        int end;
        int start = beginIndex == null ? 0 : beginIndex;
        int n = end = endIndex == null ? s.length() : endIndex.intValue();
        if (start < 0) {
            start = s.length() + start;
        }
        if (end < 0) {
            end = s.length() + end;
        }
        return s.substring(start, end);
    }

    public static String substringBetween(String s1, String s2, String s3) {
        return org.apache.commons.lang.StringUtils.substringBetween(s1, s2, s3);
    }

    public static String substringAfter(String s1, String s2) {
        return org.apache.commons.lang.StringUtils.substringAfter(s1, s2);
    }

    public static String substringBeforeLast(String s, String sep) {
        return org.apache.commons.lang.StringUtils.substringBeforeLast(s, sep);
    }

    public static String[] split(String s) {
        return StringUtils.split(s, null);
    }

    public static String[] split(String s, String sep) {
        if (s == null) {
            return null;
        }
        return s.split(sep == null ? " " : sep);
    }

    public static String[] split(String s, char sep) {
        return StringUtils.split(s, String.valueOf(sep));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileToString(String fileName) {
        String fileToStr = ABBR_ENDING_NONE;
        File file = new File(fileName);
        if (file.exists()) {
            FileReader fileReader = null;
            try {
                int c;
                fileReader = new FileReader(file);
                while ((c = fileReader.read()) != -1) {
                    if (c == 10) continue;
                    fileToStr = fileToStr + (char)c;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return fileToStr;
    }

    public static String word(String s, int i, String sep) {
        String[] st = StringUtils.split(s, sep);
        if (st.length > i - 1) {
            return StringUtils.strip(st[i - 1]);
        }
        return ABBR_ENDING_NONE;
    }

    public static String word(String s, int i) {
        return StringUtils.word(s, i, " ");
    }

    public static String removeNoneCharAtStartEnd(String s) {
        String c;
        int indStart;
        String nc = " \n\r\t";
        int indEnd = s.length() - 1;
        for (indStart = 0; indStart < indEnd && nc.indexOf(c = String.valueOf(s.charAt(indStart))) != -1; ++indStart) {
        }
        while (indStart < indEnd && nc.indexOf(c = String.valueOf(s.charAt(indEnd))) != -1) {
            --indEnd;
        }
        return s.substring(indStart, indEnd + 1);
    }

    public static String removeMultiSpace(String s) {
        return s.replaceAll("  +", " ");
    }

    public static String removeCarriage(String s) {
        return s.replaceAll("[\\n\\t\\r]", " ");
    }

    public static String abbreviateToWord(String s, int maxLength) {
        return StringUtils.abbreviateToWord(s, maxLength, ABBR_ENDING_DEFAULT);
    }

    public static String abbreviateToWord(String s, int maxLength, String endingString) {
        if (s.length() < maxLength) {
            return s;
        }
        int endingLength = 0;
        if (endingString != null && endingString.length() > 0) {
            endingLength = endingString.length();
        } else {
            endingString = ABBR_ENDING_NONE;
        }
        String txt = s.substring(0, maxLength - endingLength);
        boolean hitSeparator = false;
        while (txt.length() > 0) {
            String c = txt.substring(txt.length() - 1, txt.length());
            if (c.equals(".")) {
                txt = txt + endingString;
                break;
            }
            if (c.equals(" ") || c.equals("\n") || c.equals("\t") || c.equals("\r") || c.equals(",")) {
                hitSeparator = true;
            } else if (hitSeparator) {
                txt = txt + endingString;
                break;
            }
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }

    public static String abbreviateToWordExtra(String s, int maxLength) {
        return StringUtils.abbreviateToWordExtra(s, maxLength, ABBR_ENDING_DEFAULT);
    }

    public static String abbreviateToWordExtra(String s, int maxLength, String endingString) {
        return StringUtils.abbreviateToWord(StringUtils.removeMultiSpace(StringUtils.removeCarriage(s)), maxLength, endingString);
    }

    public static int reverseIndexOf(CharSequence s, int fromIndex, char c) {
        int len = s.length();
        for (int i = fromIndex; i >= 0 && i < len; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int reverseIndexOf(CharSequence s, int fromIndex, char ... c) {
        int len = s.length();
        for (int i = fromIndex; i >= 0 && i < len; --i) {
            if (Arrays.binarySearch(c, s.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int reverseIndexOfSpace(CharSequence s, int fromIndex) {
        int len = s.length();
        for (int i = fromIndex; i >= 0 && i < len; --i) {
            if (!Character.isSpaceChar(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String joinNonBlank(String separator, Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cant be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cant be null");
        }
        boolean from = false;
        int to = objects.length;
        int end = to - 1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < to; ++i) {
            String s;
            Object o = objects[i];
            if (o == null || StringUtils.isBlank(s = o.toString())) continue;
            builder.append(s);
            if (i == end) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String join(String separator, Object ... objects) {
        return StringUtils.join(objects, separator);
    }

    public static String join(Object[] array, String separator) {
        return StringUtils.join(array, 0, array == null ? 0 : array.length, separator);
    }

    public static String join(Object[] array, int from, int to, String separator) {
        if (array == null) {
            throw new IllegalArgumentException("array cant be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cant be null");
        }
        int end = to - 1;
        StringBuilder builder = new StringBuilder();
        for (int i = from; i < to; ++i) {
            builder.append(array[i]);
            if (i == end) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String join(T[] array, char separator, ProviderAR<T, String> stringProvider) {
        if (array == null) {
            throw new IllegalArgumentException("array cant be null");
        }
        boolean useDefaultToString = stringProvider == null;
        int end = array.length - 1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (useDefaultToString) {
                builder.append(array[i]);
            } else {
                builder.append(stringProvider.get(array[i]));
            }
            if (i == end) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String join(Iterable<T> iterable, String separator) {
        return StringUtils.join(iterable, separator, 50);
    }

    public static <T> String join(Iterable<T> iterable, String separator, int resultSizeHint) {
        if (iterable == null) {
            throw new IllegalArgumentException("iterable cant be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cant be null");
        }
        StringBuilder builder = new StringBuilder(resultSizeHint);
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String join(Iterable<? extends T> iterable, String separator, ProviderAR<T, String> stringProvider) {
        if (iterable == null) {
            throw new IllegalArgumentException("collection cant be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cant be null");
        }
        if (stringProvider == null) {
            throw new IllegalArgumentException("stringProvider cant be null");
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            builder.append(stringProvider.get(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static <T> String join(Iterable<T> iterable, String separator, ProviderAR<T, String> stringProvider, PredicateA<T> predicate) {
        if (iterable == null) {
            throw new IllegalArgumentException("collection cant be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("separator cant be null");
        }
        if (stringProvider == null) {
            throw new IllegalArgumentException("stringProvider cant be null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        StringBuilder builder = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.evaluate(next)) continue;
            builder.append(stringProvider.get(next));
            if (!iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String padLeft(String source, int newStringLenght, char paddingChar) {
        return StringUtils.pad(source, newStringLenght, paddingChar, true);
    }

    public static String padRight(String source, int newStringLenght, char paddingChar) {
        return StringUtils.pad(source, newStringLenght, paddingChar, false);
    }

    private static String pad(String source, int newStringLenght, char paddingChar, boolean left) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        int length = source.length();
        if (length >= newStringLenght) {
            return source;
        }
        StringBuilder builder = new StringBuilder(newStringLenght);
        builder.append(source);
        char[] padding = new char[newStringLenght - length];
        Arrays.fill(padding, paddingChar);
        if (left) {
            builder.insert(0, padding);
        } else {
            builder.append(padding);
        }
        return builder.toString();
    }

    public static String toAlphanumeric(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (!StringUtils.isAlphanumeric(charArray[i]) && !StringUtils.isSpace(charArray[i])) continue;
            b.append(charArray[i]);
        }
        return b.toString();
    }

    public static String toAlphanumericExtended(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!StringUtils.isAlphanumeric(c) && !StringUtils.isSpace(c) && !StringUtils.isAccent(c)) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static boolean isAlphanumeric(String s) {
        if (s == null) {
            return false;
        }
        return alphaNumericFullPattern.matcher(s).matches();
    }

    public static boolean isSpace(char c) {
        return c == ' ';
    }

    public static boolean isAlpha(char c) {
        return StringUtils.isAlphaLower(c) || StringUtils.isAlphaUpper(c);
    }

    public static boolean isAlphaUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphaLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAlphanumeric(char c) {
        return StringUtils.isAlpha(c) || StringUtils.isNumeric(c);
    }

    public static boolean isAccent(char c) {
        return StringUtils.isAccentLower(c) || StringUtils.isAccentUpper(c);
    }

    public static boolean isAccentLower(char c) {
        return Arrays.binarySearch(accentsLower, c) >= 0;
    }

    public static boolean isAccentUpper(char c) {
        return Arrays.binarySearch(accentsUpper, c) >= 0;
    }

    public static String removeAccents(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        char[] charArray = text.toCharArray();
        for (int i = 0; i < accentsToNormal.length; ++i) {
            StringUtils.replace(charArray, accentsToNormal[i][0], accentsToNormal[i][1]);
        }
        return String.valueOf(charArray);
    }

    private static void replace(char[] source, char oldChar, char newChar) {
        if (oldChar != newChar) {
            for (int i = 0; i < source.length; ++i) {
                if (source[i] != oldChar) continue;
                source[i] = newChar;
            }
        }
    }

    public static String replace(String source, int offset, CharSequence by) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        offset = StringUtils.index(source, offset);
        int newLength = Math.max(source.length(), by == null ? 0 : by.length() + offset);
        StringBuilder b = new StringBuilder(newLength);
        b.append(source);
        b.delete(offset, Math.min(source.length(), by == null ? 0 : by.length() + offset));
        if (by != null) {
            b.insert(offset, by);
        }
        return b.toString();
    }

    public static String replace(String source, int index, char c) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        index = StringUtils.index(source, index);
        StringBuilder b = new StringBuilder(source);
        b.delete(index, index + 1);
        b.insert(index, c);
        return b.toString();
    }

    public static int index(CharSequence source, int index) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return index < 0 ? source.length() + index : index;
    }

    public static StringBuilder replace(StringBuilder builder, String source, String by) {
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (by == null) {
            throw new NullPointerException("by");
        }
        int fromIndex = 0;
        int indexOf = builder.indexOf(source, fromIndex);
        while (indexOf != -1) {
            builder.replace(indexOf, indexOf + source.length(), by);
            fromIndex = indexOf + 2;
            indexOf = builder.indexOf(source, fromIndex);
        }
        return builder;
    }

    public static void scramble(char[] sequence) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        for (int i = 0; i < sequence.length; ++i) {
            int index = random.nextInt(sequence.length);
            char temp = sequence[i];
            sequence[i] = sequence[index];
            sequence[index] = temp;
        }
    }

    public static char[] random(char[] group, int len) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (group.length == 0) {
            throw new IllegalArgumentException("group should not be empty");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len should be > 0");
        }
        int groupLen = group.length;
        char[] sequence = new char[len];
        for (int i = 0; i < len; ++i) {
            sequence[i] = group[random.nextInt(groupLen)];
        }
        StringUtils.scramble(sequence);
        return sequence;
    }

    public static String doubleChar(String text, String c) {
        String s = ABBR_ENDING_NONE;
        int i = text.indexOf(c);
        while (i >= 0) {
            s = s + text.substring(0, i + c.length());
            s = s + c;
            text = text.substring(i + c.length());
            i = text.indexOf(c);
        }
        s = s + text;
        return s;
    }

    public static String capitalize(String s) {
        return org.apache.commons.lang.StringUtils.capitalize(s);
    }

    public static String reverse(String texte) {
        return org.apache.commons.lang.StringUtils.reverse(texte);
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        return org.apache.commons.lang.StringUtils.indexOf(str, searchStr, startPos);
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase();
    }

    public static boolean areEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean areEqualsIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static int compareAscii(String s1, String s2) {
        String s22;
        String s11 = StringUtils.convertNonAscii(s1);
        if (s11 == (s22 = StringUtils.convertNonAscii(s2))) {
            return 0;
        }
        if (s11 == null) {
            return -1;
        }
        if (s22 == null) {
            return 1;
        }
        return s11.compareToIgnoreCase(s22);
    }

    public static String truncate(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        if (s.length() < maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    public static String toLength(char theMaskChar, int lengthOfMask) {
        char[] s = new char[lengthOfMask];
        Arrays.fill(s, theMaskChar);
        return String.valueOf(s);
    }

    public static String remove(String str, String remove) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(remove, ABBR_ENDING_NONE);
    }

    public static String replace(String source, String searchString, String replacement) {
        if (source == null || searchString == null || replacement == null) {
            return source;
        }
        return source.replaceAll(searchString, replacement);
    }

    public static String toUpperCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public static int[] splitToInt(String s, String sep) {
        if (s.length() == 0) {
            return new int[0];
        }
        String[] split = s.split(sep);
        int[] ints = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            int n;
            ints[i] = n = Integer.parseInt(split[i]);
        }
        return ints;
    }

    public static String[] splitNonDescructive(String s, char c) {
        ArrayList<String> list = new ArrayList<String>(5);
        int fromIndex = 0;
        while (true) {
            int indexOf;
            if ((indexOf = s.indexOf(c, fromIndex)) == -1) {
                if (fromIndex < s.length()) {
                    list.add(s.substring(fromIndex));
                    break;
                }
                if (s.charAt(s.length() - 1) != c) break;
                list.add(ABBR_ENDING_NONE);
                break;
            }
            list.add(s.substring(fromIndex, indexOf));
            fromIndex = indexOf + 1;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String safeToString(Logger logger, Object e2) {
        try {
            return String.valueOf(e2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get string for " + e2.getClass().getName(), e);
            return "[FailedToString]";
        }
    }

    static {
        StringUtils.accentsUpper[0] = 192;
        StringUtils.accentsUpper[1] = 194;
        StringUtils.accentsUpper[2] = 196;
        StringUtils.accentsUpper[3] = 201;
        StringUtils.accentsUpper[4] = 200;
        StringUtils.accentsUpper[5] = 202;
        StringUtils.accentsUpper[6] = 203;
        StringUtils.accentsUpper[7] = 206;
        StringUtils.accentsUpper[8] = 207;
        StringUtils.accentsUpper[9] = 212;
        StringUtils.accentsUpper[10] = 214;
        StringUtils.accentsUpper[11] = 199;
        StringUtils.accentsUpper[12] = 217;
        StringUtils.accentsUpper[13] = 220;
        Arrays.sort(accentsUpper);
        accentsLower = new char[14];
        StringUtils.accentsLower[0] = 224;
        StringUtils.accentsLower[1] = 226;
        StringUtils.accentsLower[2] = 228;
        StringUtils.accentsLower[3] = 233;
        StringUtils.accentsLower[4] = 232;
        StringUtils.accentsLower[5] = 234;
        StringUtils.accentsLower[6] = 235;
        StringUtils.accentsLower[7] = 238;
        StringUtils.accentsLower[8] = 239;
        StringUtils.accentsLower[9] = 244;
        StringUtils.accentsLower[10] = 246;
        StringUtils.accentsLower[11] = 231;
        StringUtils.accentsLower[12] = 249;
        StringUtils.accentsLower[13] = 252;
        Arrays.sort(accentsLower);
        accentsToNormal = new char[28][2];
        StringUtils.accentsToNormal[0][0] = 224;
        StringUtils.accentsToNormal[0][1] = 97;
        StringUtils.accentsToNormal[1][0] = 192;
        StringUtils.accentsToNormal[1][1] = 65;
        StringUtils.accentsToNormal[2][0] = 226;
        StringUtils.accentsToNormal[2][1] = 97;
        StringUtils.accentsToNormal[3][0] = 194;
        StringUtils.accentsToNormal[3][1] = 65;
        StringUtils.accentsToNormal[4][0] = 228;
        StringUtils.accentsToNormal[4][1] = 97;
        StringUtils.accentsToNormal[5][0] = 228;
        StringUtils.accentsToNormal[5][1] = 65;
        StringUtils.accentsToNormal[6][0] = 233;
        StringUtils.accentsToNormal[6][1] = 101;
        StringUtils.accentsToNormal[7][0] = 201;
        StringUtils.accentsToNormal[7][1] = 69;
        StringUtils.accentsToNormal[8][0] = 232;
        StringUtils.accentsToNormal[8][1] = 101;
        StringUtils.accentsToNormal[9][0] = 200;
        StringUtils.accentsToNormal[9][1] = 69;
        StringUtils.accentsToNormal[10][0] = 234;
        StringUtils.accentsToNormal[10][1] = 101;
        StringUtils.accentsToNormal[11][0] = 202;
        StringUtils.accentsToNormal[11][1] = 69;
        StringUtils.accentsToNormal[12][0] = 235;
        StringUtils.accentsToNormal[12][1] = 101;
        StringUtils.accentsToNormal[13][0] = 203;
        StringUtils.accentsToNormal[13][1] = 69;
        StringUtils.accentsToNormal[14][0] = 238;
        StringUtils.accentsToNormal[14][1] = 105;
        StringUtils.accentsToNormal[15][0] = 206;
        StringUtils.accentsToNormal[15][1] = 73;
        StringUtils.accentsToNormal[16][0] = 239;
        StringUtils.accentsToNormal[16][1] = 105;
        StringUtils.accentsToNormal[17][0] = 207;
        StringUtils.accentsToNormal[17][1] = 73;
        StringUtils.accentsToNormal[18][0] = 244;
        StringUtils.accentsToNormal[18][1] = 111;
        StringUtils.accentsToNormal[19][0] = 212;
        StringUtils.accentsToNormal[19][1] = 79;
        StringUtils.accentsToNormal[20][0] = 246;
        StringUtils.accentsToNormal[20][1] = 111;
        StringUtils.accentsToNormal[21][0] = 214;
        StringUtils.accentsToNormal[21][1] = 79;
        StringUtils.accentsToNormal[22][0] = 231;
        StringUtils.accentsToNormal[22][1] = 99;
        StringUtils.accentsToNormal[23][0] = 199;
        StringUtils.accentsToNormal[23][1] = 67;
        StringUtils.accentsToNormal[24][0] = 249;
        StringUtils.accentsToNormal[24][1] = 117;
        StringUtils.accentsToNormal[25][0] = 217;
        StringUtils.accentsToNormal[25][1] = 85;
        StringUtils.accentsToNormal[26][0] = 252;
        StringUtils.accentsToNormal[26][1] = 117;
        StringUtils.accentsToNormal[27][0] = 220;
        StringUtils.accentsToNormal[27][1] = 85;
        aPattern = Pattern.compile("[\u00c0\u00c2]");
        ePattern = Pattern.compile("[\u00c9\u00c8\u00ca\u00cb]");
        iPattern = Pattern.compile("[\u00ce\u00df]");
        oPattern = Pattern.compile("[\u00d4\u00d6]");
        uPattern = Pattern.compile("[\u00d9\u00db]");
        cPattern = Pattern.compile("[\u00c7]");
        aPatternl = Pattern.compile("[\u00e0\u00e2]");
        ePatternl = Pattern.compile("[\u00e9\u00e8\u00ea\u00eb]");
        iPatternl = Pattern.compile("[\u00ee\u00ef]");
        oPatternl = Pattern.compile("[\u00f4\u00f6]");
        uPatternl = Pattern.compile("[\u00f9\u00fb]");
        cPatternl = Pattern.compile("[\u00e7]");
        alphaNumericFullPattern = Pattern.compile("[a-zA-Z0-9]*");
    }
}

