/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.ChainnedMessageAdapter;
import ca.infodata.readhl7.DataTypeUtils;
import ca.uhn.hl7v2.model.v24.datatype.XPN;
import ca.uhn.hl7v2.model.v24.group.REF_I12_PROVIDER_CONTACT;
import ca.uhn.hl7v2.model.v24.message.REF_I12;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.PRD;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RefI12Handler
extends ChainnedMessageAdapter<REF_I12> {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());

    public RefI12Handler(REF_I12 hl7Message) {
        super(hl7Message);
    }

    @Override
    public String getDocName() {
        logger.log(Level.FINE, "hl7Message.getPROVIDER_CONTACTReps()=" + ((REF_I12)this.hl7Message).getPROVIDER_CONTACTReps());
        for (int i = 0; i < ((REF_I12)this.hl7Message).getPROVIDER_CONTACTReps(); ++i) {
            REF_I12_PROVIDER_CONTACT providerContact = ((REF_I12)this.hl7Message).getPROVIDER_CONTACT(i);
            PRD prd = providerContact.getPRD();
            logger.log(Level.FINE, "prd.getProviderRole(0).getIdentifier()='" + prd.getProviderRole(0).getIdentifier() + '\'');
            if (!"RP".equals(prd.getProviderRole(0).getIdentifier().getValue())) continue;
            XPN xpn = prd.getProviderName(0);
            StringBuilder sb = new StringBuilder();
            String temp = xpn.getPrefixEgDR().getValue();
            if (temp != null) {
                sb.append(temp);
                sb.append(' ');
            }
            if ((temp = xpn.getGivenName().getValue()) != null) {
                sb.append(temp);
                sb.append(' ');
            }
            if ((temp = xpn.getFamilyName().getSurname().getValue()) != null) {
                sb.append(temp);
            }
            String name = sb.toString();
            logger.log(Level.FINE, "xpn/name=" + name);
            return name;
        }
        return null;
    }

    @Override
    public String getMessageStructureType() {
        return "REF_I12";
    }

    @Override
    public MSH getMsh() {
        return ((REF_I12)this.hl7Message).getMSH();
    }

    @Override
    public PID getPid() {
        return ((REF_I12)this.hl7Message).getPID();
    }

    @Override
    public String getFileNum() {
        return "";
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

