/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.ChainnedMessageAdapter;
import ca.infodata.readhl7.DataTypeUtils;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v24.message.OUL_R21;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.PID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OUL_R21Handler
extends ChainnedMessageAdapter<OUL_R21> {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());

    public OUL_R21Handler(OUL_R21 hl7Message) {
        super(hl7Message);
    }

    private OUL_R21_ORDER_OBSERVATION getOrderObservation() throws HL7Exception {
        return ((OUL_R21)this.hl7Message).getORDER_OBSERVATION();
    }

    @Override
    public String getMessageStructureType() {
        try {
            OUL_R21_ORDER_OBSERVATION orderObservation = this.getOrderObservation();
            for (int i = 0; i < orderObservation.getNTEReps(); ++i) {
                NTE nte = orderObservation.getNTE(i);
                if (nte.getCommentType().getText().getValue() == null || nte.getCommentType().getText().getValue().length() <= 0) continue;
                return "OUL_R21:" + nte.getCommentType().getText().getValue();
            }
        }
        catch (HL7Exception e) {
            logger.log(Level.SEVERE, "Unexpected error", e);
        }
        return null;
    }

    @Override
    public MSH getMsh() {
        return ((OUL_R21)this.hl7Message).getMSH();
    }

    @Override
    public PID getPid() {
        return ((OUL_R21)this.hl7Message).getPATIENT().getPID();
    }

    @Override
    public String getDocName() {
        return ((OUL_R21)this.hl7Message).getVersion();
    }

    @Override
    public String getFileNum() {
        return "";
    }

    @Override
    public String getPrelDate() {
        return null;
    }

    @Override
    public String getOBRSpecimen(int i) {
        return null;
    }

    @Override
    public String getOBXEquipment(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUserCheck(int i, int j) {
        return null;
    }

    @Override
    public String getSpecimenName(int j) {
        return null;
    }

    @Override
    public String[] getDspLines() {
        return null;
    }

    @Override
    public String getPdfFromObx55(int j) {
        return null;
    }

    @Override
    public String getPerformingOrganisation(int i, int j) {
        return null;
    }

    @Override
    public String getOBXLoincIdentifier(int i, int j) {
        return null;
    }
}

