/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.Doit;
import ca.infodata.readhl7.MessageHandler;
import ca.infodata.util1.JoinList;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.resource.XMLResource;

public class Main {
    private static Pattern patScript = Pattern.compile("<script.*</script>", 32);
    private static Pattern patDivClass = Pattern.compile("<div class=\"show-on-print-only\".*</div>", 32);
    private static String[] searchFor1 = new String[]{"&gt;", "&lt;"};
    private static String[] replaceBy1 = new String[]{"GreaterThan", "LowerThan"};
    private static String[] searchFor2 = new String[]{"LowerThan", "GreaterThan", "&"};
    private static String[] replaceBy2 = new String[]{StringEscapeUtils.escapeXml("<"), StringEscapeUtils.escapeXml(">"), StringEscapeUtils.escapeXml("&")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String dir = "/Users/pdrolet/labo_test/test/";
        File dirFile = new File("/Users/pdrolet/labo_test/test/");
        File[] files = dirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
        ArrayList<File> lstFiles = new ArrayList<File>();
        final String toDo = null;
        for (File hl7File : files) {
            if (hl7File.isDirectory()) {
                File[] hl7Files;
                for (File hl7File2 : hl7Files = hl7File.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return (name.toLowerCase().endsWith("hl7") || name.toLowerCase().endsWith("hl7s")) && toDo == null || name.equals(toDo);
                    }
                })) {
                    lstFiles.add(hl7File2);
                }
                continue;
            }
            if (!hl7File.getName().toLowerCase().endsWith("hl7") && !hl7File.getName().toLowerCase().endsWith("hl7s") || toDo != null && !hl7File.getName().equals(toDo)) continue;
            lstFiles.add(hl7File);
        }
        String[] name = new String[lstFiles.size()];
        int k = 0;
        for (File file : lstFiles) {
            name[k++] = file.getAbsolutePath();
        }
        boolean doprocess = false;
        JoinList jl = new JoinList("','");
        boolean doPdf = true;
        Doit d = new Doit();
        for (String fileName : name) {
            String hl7Body = "";
            File file = null;
            FileInputStream is = null;
            BufferedReader br = null;
            file = new File(fileName);
            try {
                String str;
                is = new FileInputStream(file);
                String UTF8 = fileName.contains("_LABRES") || fileName.contains("/HCV_") || fileName.contains("/CHUL_") || fileName.contains("/CCR_") || fileName.contains("/RAD-") || fileName.contains("/IUCPQ_") || fileName.contains("/15147/") || fileName.contains("/HSFA_") || fileName.contains("/_2021") || fileName.contains("/PORT_") ? "ISO8859_1" : "UTF8";
                int BUFFER_SIZE = 8192;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8), BUFFER_SIZE);
                StringBuilder strBd = new StringBuilder();
                while ((str = br.readLine()) != null) {
                    strBd.append(str + "\n");
                }
                hl7Body = strBd.toString();
                doprocess = true;
            }
            catch (IOException ie) {
                doprocess = false;
                ie.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            MessageHandler handler = d.getHandler(hl7Body);
            if (handler != null) {
                String[] an = handler.getAccessionNum().split(",");
                jl.add(an[0].trim());
            }
            String htmlText = null;
            try {
                System.out.println("DOING: " + fileName);
                htmlText = d.getHtmlFromHl7(hl7Body, fileName).replace("%-", "__PC-").replace("#-", "__NB-");
                FileUtils.write(new File("/Users/pdrolet/labo_test/test/" + fileName.substring("/Users/pdrolet/labo_test/test/".length()).replace(".hl7", "2.html").replace(".HL7", "2.html")), (CharSequence)htmlText, StandardCharsets.UTF_8, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!doPdf || htmlText == null) continue;
            try {
                byte[] htmlToPdf = Main.htmlToPdf(htmlText);
                FileUtils.writeByteArrayToFile(new File("/Users/pdrolet/labo_test/test/" + fileName.substring("/Users/pdrolet/labo_test/test/".length()) + "-OFYS.pdf"), htmlToPdf, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("('" + jl.toString() + "')");
    }

    private static byte[] htmlToPdf(String html) throws HtmlParsingException {
        try {
            html = patScript.matcher(html).replaceAll("");
            html = html.replaceAll("&quot;", "");
            html = patDivClass.matcher(html).replaceAll("");
            html = StringUtils.replaceEach(html, searchFor1, replaceBy1);
            html = StringEscapeUtils.unescapeHtml(html);
            html = StringUtils.replaceEach(html, searchFor2, replaceBy2);
            ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes("UTF-8"));
            Document doc = XMLResource.load(is).getDocument();
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(doc, null);
            renderer.layout();
            ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
            renderer.createPDF(os);
            byte[] pdf = os.toByteArray();
            return pdf;
        }
        catch (Exception e) {
            throw new HtmlParsingException(e, html);
        }
    }

    public static class HtmlParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public String html;

        public HtmlParsingException(Throwable cause, String html) {
            super(cause);
            this.html = html;
        }
    }
}

