/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.Doit;
import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.tools.Messages;
import ca.infodata.readhl7.tools.Utils;
import ca.infodata.util1.JoinList;
import com.googlecode.jatl.Html;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class LaboHtmlFormatter {
    public static String CLIQUER_CLIPBOARD = Messages.getString("CLIQUER_CLIPBOARD");
    public static String NO_DOSSIER = Messages.getString("NO_DOSSIER");
    public static String PERFORM_ORG = Messages.getString("PERFORM_ORG");
    public static String OTHER_VALUES = Messages.getString("OTHER_VALUES");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final StringWriter writer = new StringWriter();
    private final Html html = new Html(this.writer);
    private static final String JQUERY = "jquery-1.11.3.min.js";
    private static final String EXCANVAS = "excanvas.min.js";
    private static final String FLOT_CSS = "flot.css";
    private static final String JFLOT = "jquery.flot.min.js";
    private static final String JFLOT_TIME = "jquery.flot.time.js";
    private static final String JBULLE = "laboBulle.js";
    private static final String jUrl = "http://www.ofys.ca/formulaires/";
    public static String JQUERY_STRING = LaboHtmlFormatter.getStringFromFile("jquery-1.11.3.min.js", "http://www.ofys.ca/formulaires/jquery/");
    public static String JBULLE_STRING = LaboHtmlFormatter.getStringFromFile("laboBulle.js", "http://www.ofys.ca/formulaires/").replace("__TIMEFORMAT__", "%y/%m").replace("__OTHER_VALUES__", OTHER_VALUES);
    public static String EXCANVAS_STRING = LaboHtmlFormatter.getStringFromFile("excanvas.min.js", "http://www.ofys.ca/formulaires/flot/");
    public static String JFLOT_STRING = LaboHtmlFormatter.getStringFromFile("jquery.flot.min.js", "http://www.ofys.ca/formulaires/flot/");
    public static String JFLOT_TIME_STRING = LaboHtmlFormatter.getStringFromFile("jquery.flot.time.js", "http://www.ofys.ca/formulaires/flot/");
    public static String FLOT_CSS_STRING = LaboHtmlFormatter.getStringFromFile("flot.css", "http://www.ofys.ca/formulaires/flot/");
    final String[] escapedChar = new String[]{"\\F\\", "\\R\\", "\\S\\", "\\T\\", "\\E\\", "\\.br\\"};
    final String[] replaceChar = new String[]{"|", "~", "^", "&", "\\", "~"};
    private String fileName = null;

    public LaboHtmlFormatter(MessageHandler h, String f) {
        this.fileName = f;
        this.formatHl7Message(h);
    }

    public LaboHtmlFormatter(MessageHandler h) {
        this.formatHl7Message(h);
    }

    private String rp(String s) {
        return s == null ? null : StringUtils.replaceEach(s, this.escapedChar, this.replaceChar);
    }

    public String formatHl7Message(MessageHandler h) {
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setHeader(this.html);
        this.setTopTable(this.html, h);
        this.setSectionLabo(this.html, h);
        this.setSectionDSP(this.html, h);
        this.setFooter(this.html);
        return this.writer.toString();
    }

    public String getHtml() {
        return "<!DOCTYPE html>" + this.writer.toString();
    }

    private void setSectionDSP(Html h, MessageHandler m) {
        String[] dspLines = m.getDspLines();
        if (dspLines != null && dspLines.length > 0) {
            String ffcc0 = "#FFFFFF";
            ((Html)((Html)((Html)((Html)((Html)((Html)h.table()).style("page-break-inside:avoid;")).bgcolor("#FFFFFF")).border("0")).cellpadding("0")).cellspacing("0")).width("100%");
            ((Html)((Html)((Html)((Html)((Html)h.tr()).td()).style("line-height: 6px; overflow:hidden;")).raw("&nbsp;")).end()).end();
            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).align("middle")).bgcolor("#FFFFFF")).classAttr("titre")).text(Messages.getString("titre.dsp.section"))).end()).end();
            for (String line : dspLines) {
                ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).bgcolor("#FFFFFF")).classAttr("text1dsp")).raw(Utils.replaceCharToHtmlChar(line))).end()).end();
            }
            ((Html)h.end()).end();
        }
    }

    private void setSectionLabo(Html h, MessageHandler m) {
        int linenum = 0;
        String highlight = "#E0E0FFL";
        String ffcc0 = "#FFCC00";
        int OBRCount = m.getOBRCount();
        int index = 0;
        String obrNamePrec = "";
        String lastHead = "___";
        boolean needNewTableHeader = true;
        JoinList jlObrComment = new JoinList(", ");
        jlObrComment.setNoDuplicate(true);
        jlObrComment.setAllowBlank(false);
        jlObrComment.setTrim(true);
        for (int j = 0; j < OBRCount; ++j) {
            String specimen = m.getOBRSpecimen(j);
            if (StringUtils.isNotBlank(specimen)) {
                specimen = " (" + this.rp(specimen) + ")";
            }
            if (StringUtils.isBlank(specimen) && StringUtils.isNotBlank(specimen = m.getSpecimenName(j))) {
                specimen = " (" + this.rp(specimen) + ")";
            }
            int obrCommentCount = m.getOBRCommentCount(j);
            boolean sameLastHead = false;
            String obrComments = "";
            if (j > 0) {
                h.end();
            }
            if (obrCommentCount > 0) {
                for (int l = 0; l < obrCommentCount; ++l) {
                    String obrComment = m.getOBRComment(j, l);
                    jlObrComment.add(obrComment);
                }
                obrComments = jlObrComment.toString();
                sameLastHead = lastHead.equals(obrComments);
                if (!sameLastHead) {
                    needNewTableHeader = true;
                    ((Html)((Html)((Html)((Html)((Html)((Html)h.table()).style("page-break-inside:avoid;")).bgcolor("#205999")).border("0")).cellpadding("0")).cellspacing("0")).width("100%");
                    lastHead = obrComments;
                    ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("2")).style("line-height: 6px; overflow:hidden;")).raw("&nbsp;")).end()).end();
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).bgcolor("#FFCC00")).width("600")).valign("bottom")).div()).classAttr("Title2")).raw(Utils.replaceCharToHtmlChar(lastHead))).classAttr("txt1")).text(specimen)).end()).end();
                    ((Html)((Html)((Html)((Html)h.td()).width("*")).raw("&nbsp;")).end()).end();
                    h.end();
                }
            }
            boolean obrFlag = false;
            int obxCount = m.getOBXCount(j);
            if (needNewTableHeader) {
                needNewTableHeader = false;
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellspacing("0")).cellpadding("2")).classAttr("tableBgColor")).name("tblDiscs")).id("tblDiscs");
                ((Html)h.tr()).classAttr("Field2");
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("24%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formTestName"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("16%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formResult"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("5%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formAbn"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("16%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formReferenceRange"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("13%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formUnits"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("20%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formDateTimeCompleted"))).end();
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).width("6%")).align("middle")).valign("bottom")).classAttr("Cell")).text(Messages.getString("oscarMDS.segmentDisplay.formNew"))).end();
                h.end();
            } else {
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellspacing("0")).cellpadding("2")).classAttr("tableBgColor")).name("tblDiscs")).id("tblDiscs");
                h.tr();
                ((Html)((Html)h.td()).width("24%")).end();
                ((Html)((Html)h.td()).width("16%")).end();
                ((Html)((Html)h.td()).width("5%")).end();
                ((Html)((Html)h.td()).width("16%")).end();
                ((Html)((Html)h.td()).width("13%")).end();
                ((Html)((Html)h.td()).width("20%")).end();
                ((Html)((Html)h.td()).width("6%")).end();
                h.end();
            }
            String obrName = this.rp(m.getOBRName(j));
            if (!jlObrComment.isEmpty()) {
                jlObrComment = new JoinList(", ");
                jlObrComment.setNoDuplicate(true);
                jlObrComment.setAllowBlank(false);
                jlObrComment.setTrim(true);
            }
            if (!(obrFlag || obrName.equals("") || obrNamePrec.contains(obrName))) {
                ((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "");
                ((Html)((Html)((Html)((Html)((Html)((Html)h.td()).colspan("6")).valign("top")).align("left")).text(obrName)).end()).end();
                obrFlag = true;
            }
            obrNamePrec = obrName;
            String obxUserCheckPrec = "";
            String obxNamePrec = "|-_-|";
            for (int k = 0; k < obxCount; ++k) {
                String obxResultOrig = StringUtils.defaultIfEmpty(m.getOBXResult(j, k), "").trim();
                if (obxResultOrig.toLowerCase().contains("base64")) continue;
                String obxResult2 = this.rp(obxResultOrig);
                String obxName = this.rp(m.getOBXName(j, k));
                String obxIdent = m.getOBXIdentifier(j, k);
                if (obxResult2.startsWith(obxName)) {
                    obxName = "";
                }
                String obxAbnFlag = m.getOBXAbnormalFlag(j, k).trim();
                String obxRef = m.getOBXReferenceRange(j, k).trim();
                String obxUnit = m.getOBXUnits(j, k).trim();
                String obxTime = m.getTimeStamp(j, k).trim();
                String obxStatus = m.getOBXResultStatus(j, k).trim();
                int obxCommentCount = m.getOBXCommentCount(j, k);
                String performingOrg = this.rp(m.getPerformingOrganisation(j, k));
                String poNameTile = "";
                if (performingOrg != null && !"".equals(performingOrg) && !"null".equals(performingOrg)) {
                    poNameTile = PERFORM_ORG + ":\n" + performingOrg;
                }
                if ((StringUtils.isEmpty(obxName) || obxName.trim().length() == 1) && (StringUtils.isEmpty(obxResult2) || "-".equals(obxResult2))) {
                    for (int l = 0; l < obxCommentCount; ++l) {
                        String[] dividedString;
                        for (String sss : dividedString = m.getOBXComment(j, k, l).split("[\n]|[~]")) {
                            if (sss.length() <= 1) continue;
                            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).colspan("6")).align("left")).span()).style("margin:0px 0px 0px 1em;")).raw(Utils.replaceCharToHtmlChar(sss))).end()).end()).end();
                        }
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).colspan("6")).align("left")).span()).raw("&nbsp;")).end()).end()).end();
                    }
                    continue;
                }
                String obxTypeCode = m.getOBXIdentifier(j, k).replace(".", "__PT__").replace("%", "__PC__").replace("#", "__NB__");
                String obxLoincCode = m.getOBXLoincIdentifier(j, k);
                if (!obxStatus.equals("DNS")) {
                    int l;
                    String lineClass = "NormalRes";
                    if (obxAbnFlag != null && (obxAbnFlag.startsWith("L") || obxAbnFlag.startsWith("B"))) {
                        lineClass = "HiLoRes";
                    } else if (obxResult2.toUpperCase().startsWith("POS") || obxAbnFlag != null && (obxAbnFlag.equals("A") || obxAbnFlag.startsWith("H") || m.isOBXAbnormal(j, k))) {
                        lineClass = "AbnormalRes";
                    }
                    String obxValueType = StringUtils.defaultIfEmpty(m.getOBXValueType(j, k), "");
                    if (obxValueType.equalsIgnoreCase("FT")) {
                        String[] dividedString = this.divideStringAtFirstNewline(obxResult2);
                        ((Html)((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "")).classAttr(lineClass);
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).title("Suivre ce test / Track this test")).valign("top")).align("left")).style("cursor:pointer;")).onclick("addLaboFollow(['" + obxTypeCode + "','" + obxLoincCode + "','" + obxName + "']);")).raw(obrFlag ? "&nbsp; &nbsp; &nbsp;" : "&nbsp;")).text(obxName)).end();
                        String obxResult = dividedString[0];
                        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).onclick("copyToCB('" + obxName + ": " + obxResult + "');")).align("right")).classAttr("topopup")).title(CLIQUER_CLIPBOARD)).id(obxTypeCode + "-" + index++)).text(obxResult)).end();
                        ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxAbnFlag)).end();
                        ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxRef)).end();
                        ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxUnit)).end();
                        ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxTime)).end();
                        ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxStatus)).end();
                        h.end();
                        if (dividedString[1] != null) {
                            ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("6")).style("padding-left:10px;")).text(dividedString[1])).end()).end();
                        }
                    } else if (obxValueType.equals("TX")) {
                        String[] dividedString = obxResultOrig.split("[\n]|[~]|(__[ ]{1,2})");
                        boolean allCols = false;
                        if (obxRef.length() > 0 || obxUnit.length() > 0) {
                            allCols = true;
                        }
                        String[] stringArray = dividedString;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String sss = stringArray[i];
                            int underl = sss.indexOf("__");
                            if (underl > -1) {
                                sss = sss.substring(0, underl);
                            }
                            if (sss.length() <= 1) continue;
                            if (obxName != null) {
                                if ("LABMIC".equals(obxIdent) || "LABGEN".equals(obxIdent)) {
                                    ((Html)h.tr()).classAttr("text1");
                                } else {
                                    ((Html)((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "")).classAttr(lineClass);
                                }
                                if (!obxName.equals(obxNamePrec)) {
                                    ((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).raw(obrFlag ? "&nbsp; &nbsp; &nbsp;" : "&nbsp;")).text(obxName)).end();
                                } else {
                                    ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).raw("&nbsp;")).end();
                                }
                                if (allCols) {
                                    ((Html)((Html)((Html)((Html)h.td()).align("right")).valign("top")).raw(Utils.replaceCharToHtmlChar(sss.trim()))).end();
                                    if (obxRef.length() == 0) {
                                        ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).align("left")).valign("top")).text(obxAbnFlag)).end();
                                    } else {
                                        ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxAbnFlag)).end();
                                        ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxRef)).end();
                                    }
                                    ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxUnit)).end();
                                } else {
                                    if (sss.trim().length() > 80) {
                                        sss = WordUtils.wrap(sss.trim(), 80);
                                    }
                                    if (obxTime.trim().length() == 0) {
                                        ((Html)((Html)((Html)((Html)h.td()).colspan("5")).align("left")).raw(Utils.replaceCharToHtmlChar(sss))).end();
                                    } else {
                                        ((Html)((Html)((Html)((Html)h.td()).colspan("4")).align("left")).raw(Utils.replaceCharToHtmlChar(sss))).end();
                                        ((Html)((Html)((Html)h.td()).align("center")).text(obxTime)).end();
                                    }
                                }
                                ((Html)((Html)((Html)h.td()).align("center")).text(obxStatus)).end();
                                h.end();
                                obxNamePrec = obxName;
                                continue;
                            }
                            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text0")).style("margin:0px 0px 0px 1em;")).td()).colspan("7")).raw(Utils.replaceCharToHtmlChar(sss.trim()))).end()).end();
                        }
                    } else if (obxValueType.equals("ST")) {
                        boolean doNotShowObxName;
                        boolean allCols = false;
                        if (obxRef.length() > 0 || obxUnit.length() > 0) {
                            allCols = true;
                        }
                        String split = obxResultOrig.indexOf("~") != -1 ? "~" : null;
                        split = split == null && obxResultOrig.indexOf("\n") != -1 ? "\n" : split;
                        String string = split = split == null && obxResultOrig.indexOf("\\R\\") != -1 ? "\\R\\" : split;
                        if (split == null) {
                            obxResult2 = WordUtils.wrap(obxResultOrig, 100);
                        } else {
                            StringBuilder sbResult = new StringBuilder(obxResultOrig.length() + 10);
                            String[] splitRes = obxResultOrig.split(split);
                            for (l = 0; l < splitRes.length; ++l) {
                                String sss = splitRes[l].trim();
                                if (sss.length() > 110) {
                                    sss = WordUtils.wrap(sss, 100);
                                }
                                sbResult.append(this.rp(splitRes[l])).append("\n");
                            }
                            obxResult2 = sbResult.toString();
                        }
                        boolean bl = doNotShowObxName = obxNamePrec.equals(obxName) || obxName.equals(obrName);
                        if (obxName.toLowerCase().startsWith("comment") || obxName.toLowerCase().startsWith("note") || obxName.toLowerCase().startsWith("information")) {
                            ((Html)h.tr()).classAttr("text1");
                            ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("7")).align("left")).valign("top")).raw(Utils.replaceCharToHtmlChar(obxResult2))).end();
                            h.end();
                        } else if (!allCols) {
                            if (doNotShowObxName) {
                                ((Html)h.tr()).classAttr("text1");
                                ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("7")).align("left")).valign("top")).raw(Utils.replaceCharToHtmlChar(obxResult2))).end();
                            } else {
                                ((Html)((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "")).classAttr(lineClass);
                                ((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).raw(obrFlag ? "&nbsp; &nbsp; &nbsp;" : "&nbsp;")).text(obxName)).end();
                                if (obxTime.trim().length() == 0) {
                                    ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("5")).align("left")).valign("top")).raw(Utils.replaceCharToHtmlChar(obxResult2))).end();
                                } else {
                                    ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("4")).align("left")).valign("top")).raw(Utils.replaceCharToHtmlChar(obxResult2))).end();
                                    ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxTime)).end();
                                }
                                ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxStatus)).end();
                            }
                            h.end();
                        } else {
                            ((Html)((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "")).classAttr(lineClass);
                            if (doNotShowObxName) {
                                ((Html)((Html)((Html)h.td()).align("left")).raw("&nbsp;")).end();
                            } else {
                                ((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).raw(obrFlag ? "&nbsp; &nbsp; &nbsp;" : "&nbsp;")).text(obxName)).end();
                            }
                            ((Html)((Html)((Html)((Html)h.td()).align("right")).valign("top")).raw(Utils.replaceCharToHtmlChar(obxResult2))).end();
                            if (obxRef.length() == 0) {
                                ((Html)((Html)((Html)((Html)((Html)h.td()).colspan("2")).align("left")).valign("top")).text(obxAbnFlag)).end();
                            } else {
                                ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxAbnFlag)).end();
                                ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxRef)).end();
                            }
                            ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxUnit)).end();
                            ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxTime)).end();
                            ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxStatus)).end();
                            h.end();
                        }
                        obxNamePrec = obxName;
                    } else if (obxValueType.equals("NM") || obxValueType.equals("SN") || obxValueType.equals("CWE") || obxValueType.equals("CE")) {
                        String obxResult = obxResult2;
                        String split = obxResult2.indexOf("~") != -1 ? "~" : null;
                        split = split == null && obxResult2.indexOf("\n") != -1 ? "\n" : split;
                        split = split == null && obxResult2.indexOf("\\R\\") != -1 ? "\\R\\" : split;
                        String string = split = split == null && obxResult2.indexOf("\\u000d") != -1 ? "\\u000d" : split;
                        if (obxResult.length() < 40 && split == null) {
                            String equip;
                            if (obxResult.contains("?") && StringUtils.isNotBlank(equip = m.getOBXEquipment(j, k))) {
                                obxResult = equip + " " + obxResult;
                            }
                            ((Html)((Html)h.tr()).bgcolor(linenum % 2 == 1 ? "#E0E0FFL" : "")).classAttr(lineClass);
                            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).title("Suivre ce test / Track this test")).valign("top")).align("left")).style("cursor:pointer;")).onclick("addLaboFollow(['" + obxTypeCode + "','" + obxLoincCode + "','" + obxName + "']);")).raw(obrFlag ? "&nbsp; &nbsp; &nbsp;" : "&nbsp;")).text(obxName)).end();
                            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).onclick("copyToCB('" + obxName + ": " + obxResult + "');")).align("right")).classAttr("topopup")).title(CLIQUER_CLIPBOARD)).id(obxTypeCode + "-" + index++)).text(obxResult)).end();
                            ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxAbnFlag)).end();
                            String[] refRanges = obxRef.split("-");
                            String refRangeModif = refRanges.length == 2 && refRanges[0].trim().length() == 0 ? obxRef.replace('-', '<') : obxRef;
                            ((Html)((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).title(obxRef)).text(refRangeModif)).end();
                            ((Html)((Html)((Html)((Html)h.td()).align("left")).valign("top")).text(obxUnit)).end();
                            ((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxTime)).end();
                            ((Html)((Html)((Html)((Html)((Html)h.td()).align("center")).valign("top")).text(obxStatus)).end()).end();
                        } else {
                            String[] dividedString = split != null ? obxResult.split(split) : WordUtils.wrap(obxResult, 180, "~", false).split("~");
                            String[] stringArray = dividedString;
                            l = stringArray.length;
                            for (int sss = 0; sss < l; ++sss) {
                                String sss2 = stringArray[sss];
                                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).align("left")).colspan("6")).style("margin:0px 0px 0px 1em;")).text(sss2)).end()).end();
                            }
                        }
                        String userCheck = m.getOBXUserCheck(j, k);
                        if (userCheck != null && !userCheck.isEmpty() && !userCheck.equals(obxUserCheckPrec)) {
                            ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).align("left")).colspan("6")).style("margin:0px 0px 0px 1em;")).raw(Utils.replaceCharToHtmlChar(userCheck))).end()).end();
                            obxUserCheckPrec = userCheck;
                        }
                        obxNamePrec = obxName;
                    }
                }
                if (obxCommentCount <= 0) continue;
                ((Html)((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).colspan("7")).table()).width("100%")).border("0")).cellspacing("0")).cellpadding("2")).classAttr("tableBgColor");
                for (int l = 0; l < obxCommentCount; ++l) {
                    String[] dividedString;
                    String obxComment = m.getOBXComment(j, k, l);
                    for (String sss : dividedString = obxComment.split("[~]|(__[ ]{1,2})")) {
                        if (sss.length() > 126) {
                            String[] ssss;
                            for (String z : ssss = WordUtils.wrap(sss, 126).split("\n")) {
                                ((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).raw(Utils.replaceCharToHtmlChar(z))).end()).end();
                            }
                            continue;
                        }
                        if (sss.length() <= 1) continue;
                        ((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).td()).raw(Utils.replaceCharToHtmlChar(sss))).end()).end();
                    }
                    if (l + 1 < obxCommentCount) continue;
                    ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).classAttr("text1")).style("line-height:0.5em;margin:0px;")).td()).align("left")).raw("&nbsp;")).end()).end();
                }
                ((Html)((Html)h.end()).end()).end();
            }
        }
        try {
            h.end();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTopTable(Html h, MessageHandler m) {
        ((Html)((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("1")).cellspacing("0")).cellpadding("3")).bgcolor("#7999CC")).style("bordercolordark=\"#bfcbe3\"");
        ((Html)((Html)((Html)((Html)h.tr()).td()).width("66%")).align("middle")).classAttr("Cell");
        ((Html)((Html)((Html)h.div()).classAttr("Field2")).text(Messages.getString("oscarMDS.segmentDisplay.formDetailResults"))).end();
        h.end();
        ((Html)((Html)((Html)h.td()).width("33%")).align("middle")).classAttr("Cell");
        ((Html)((Html)((Html)h.div()).classAttr("Field2")).text(Messages.getString("oscarMDS.segmentDisplay.formResultsInfo"))).end();
        ((Html)h.end()).end();
        ((Html)((Html)((Html)h.tr()).td()).bgcolor("white")).valign("top");
        ((Html)((Html)((Html)((Html)((Html)h.table()).valign("top")).border("0")).cellpadding("2")).cellspacing("0")).width("100%");
        ((Html)((Html)((Html)((Html)((Html)h.tr()).valign("top")).td()).valign("top")).width("33%")).align("left");
        ((Html)((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellpadding("2")).cellspacing("0")).valign("top");
        ((Html)((Html)((Html)h.tr()).td()).valign("top")).align("left");
        ((Html)((Html)((Html)((Html)((Html)h.table()).valign("top")).border("0")).cellpadding("3")).cellspacing("0")).width("100%");
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formPatientName") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)h.div()).classAttr("FieldData")).nowrap("nowrap")).text(Doit.HIDE_NAME ? m.getPatientName().replaceAll("[a-zA-Z]", "X") : m.getPatientName());
        ((Html)h.end()).end();
        ((Html)((Html)((Html)h.td()).colspan("2")).end()).end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formDateBirth") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)h.div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getDOB());
        ((Html)h.end()).end();
        ((Html)((Html)((Html)h.td()).colspan("2")).end()).end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formAge") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)h.div()).classAttr("FieldData")).text(m.getAge());
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formSex") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)h.td()).align("left")).nowrap(null);
        ((Html)((Html)h.div()).classAttr("FieldData")).text(m.getSex());
        ((Html)((Html)h.end()).end()).end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formHealthNumber") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)h.div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getHealthNum());
        ((Html)h.end()).end();
        ((Html)((Html)((Html)h.td()).colspan("2")).end()).end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)((Html)h.div()).align("left")).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formPatientLocation") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)h.td()).colspan("2")).nowrap(null);
        ((Html)((Html)((Html)((Html)h.div()).align("left")).classAttr("FieldData")).nowrap("nowrap")).text(m.getPatientLocation());
        ((Html)h.end()).end();
        h.end();
        h.end();
        h.end();
        ((Html)((Html)h.td()).width("33%")).valign("top");
        ((Html)((Html)((Html)((Html)((Html)h.table()).valign("top")).border("0")).cellpadding("3")).cellspacing("0")).width("100%");
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)((Html)h.div()).align("left")).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formHomePhone") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)((Html)h.div()).align("left")).classAttr("FieldData")).nowrap("nowrap")).text(m.getHomePhone());
        ((Html)h.end()).end();
        h.end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)((Html)h.div()).align("left")).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formWorkPhone") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)((Html)h.div()).align("left")).classAttr("FieldData")).nowrap("nowrap")).text(m.getWorkPhone());
        ((Html)h.end()).end();
        h.end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)h.tr()).td()).div()).nowrap(null)).end()).end()).end();
        List<String> headers = m.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            ((Html)((Html)h.tr()).td()).nowrap(null);
            ((Html)((Html)((Html)((Html)((Html)h.div()).align("left")).classAttr("FieldData")).nowrap("nowrap")).strong()).text(Messages.getString("code_prevenance"));
            ((Html)((Html)h.end()).end()).end();
            ((Html)h.td()).nowrap(null);
            ((Html)((Html)((Html)h.div()).align("left")).classAttr("FieldData")).nowrap("nowrap");
            h.text(StringUtils.left(headers.get(0), 12));
            ((Html)((Html)h.end()).end()).end();
        }
        h.end();
        h.end();
        h.end();
        h.end();
        h.end();
        h.end();
        h.end();
        h.end();
        ((Html)((Html)h.td()).bgcolor("white")).valign("top");
        ((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellspacing("0")).cellpadding("1");
        ((Html)h.tr()).td();
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formDateRequest") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getServiceDate())).end()).end()).end();
        ((Html)h.tr()).td();
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formDatePrel") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getPrelDate())).end()).end()).end();
        ((Html)h.tr()).td();
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formDateService") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.td()).div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getMsgDate())).end()).end()).end();
        ((Html)h.tr()).td();
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formReportStatus") + ": ")).end();
        ((Html)h.end()).end();
        ((Html)((Html)((Html)h.td()).div()).classAttr("FieldData")).nowrap("nowrap");
        String orderStatus = m.getOrderStatus();
        if (orderStatus.equals("F")) {
            h.text(Messages.getString("oscarMDS.segmentDisplay.Final"));
        } else if (orderStatus.equals("C")) {
            h.text(Messages.getString("oscarMDS.segmentDisplay.Corrected"));
        } else if (orderStatus.equals("A")) {
            h.text(Messages.getString("oscarMDS.segmentDisplay.Canceled"));
        } else if (orderStatus.equals("I")) {
            h.text(Messages.getString("oscarMDS.segmentDisplay.InProgress"));
        } else if (orderStatus.equals("P")) {
            h.text(Messages.getString("oscarMDS.segmentDisplay.Partial"));
        } else {
            h.text(Messages.getString("oscarMDS.segmentDisplay.Partial"));
        }
        ((Html)((Html)((Html)h.end()).end()).end()).end();
        ((Html)((Html)((Html)((Html)h.table()).tr()).td()).end()).end();
        ((Html)((Html)h.tr()).td()).nowrap(null);
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(NO_DOSSIER + ": ")).end();
        ((Html)h.end()).end();
        ((Html)h.td()).nowrap(null);
        ((Html)((Html)((Html)h.div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getFileNum());
        ((Html)h.end()).end();
        h.end();
        ((Html)h.tr()).td();
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formAccession") + ": ")).end();
        ((Html)h.end()).end();
        h.td();
        ((Html)((Html)((Html)h.div()).classAttr("FieldData")).nowrap("nowrap")).text(m.getAccessionNum());
        ((Html)h.end()).end();
        h.end();
        h.end();
        h.end();
        h.end();
        ((Html)((Html)((Html)h.tr()).td()).bgcolor("white")).colspan("2");
        ((Html)((Html)((Html)((Html)h.table()).width("100%")).border("0")).cellspacing("0")).cellpadding("9");
        ((Html)((Html)((Html)h.tr()).bgcolor("white")).classAttr("FieldData")).td();
        ((Html)((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formRequestingClient") + ": ")).end()).text(Doit.HIDE_NAME ? m.getDocName().replaceAll("[a-zA-Z]", "X") : m.getDocName());
        h.end();
        ((Html)((Html)h.td()).bgcolor("white")).align("right");
        ((Html)h.div()).classAttr("FieldData");
        ((Html)((Html)h.strong()).text(Messages.getString("oscarMDS.segmentDisplay.formCCClient") + ": ")).end();
        ((Html)((Html)((Html)h.text(Doit.HIDE_NAME ? m.getCCDocs().replaceAll("[a-zA-Z]", "X") : m.getCCDocs())).end()).end()).end();
        ((Html)((Html)((Html)h.end()).end()).end()).end();
    }

    private void setHeader(Html h) {
        JBULLE_STRING = LaboHtmlFormatter.getStringFromFile(JBULLE, jUrl).replace("__TIMEFORMAT__", "%y/%m").replace("__OTHER_VALUES__", OTHER_VALUES);
        JFLOT_STRING = LaboHtmlFormatter.getStringFromFile(JFLOT, "http://www.ofys.ca/formulaires/flot/");
        ((Html)((Html)((Html)((Html)((Html)((Html)((Html)h.html()).head()).meta()).charset("utf-8")).meta()).httpEquiv("X-UA-Compatible")).content("IE=edge")).raw("<style>" + FLOT_CSS_STRING + "</style><script type=\"text/javascript\">" + JQUERY_STRING + "</script><script type=\"text/javascript\">" + EXCANVAS_STRING + "</script><script type=\"text/javascript\">" + JFLOT_STRING + "</script><script type=\"text/javascript\">" + JFLOT_TIME_STRING + "</script><script type=\"text/javascript\">" + JBULLE_STRING + "</script>");
        this.setStyle(this.html);
        ((Html)h.end()).body();
    }

    private void setFooter(Html h) {
        ((Html)((Html)((Html)h.div()).classAttr("show-on-print-only")).text("print-by-and-date-time")).end();
        String printButton = "<div name=\"FunctionButtons\" class=\"DoNotPrint\"><table><tr><td class=\"subjectline\"><input value=\"Imprimer / Print\" name=\"PrintButton\" onclick=\"javascript:window.print()\" type=\"button\"></td></tr></table></div>";
        h.raw(printButton);
        h.endAll();
    }

    private void setStyle(Html h) {
        ((Html)((Html)((Html)h.style()).type("text/css")).raw("<!-- .RollRes {font-weight:700;font-size:8pt;color:white;font-family:Verdana,Arial,Helvetica}.RollRes a:link {color:white}.RollRes a:hover {color:white}.RollRes a:visited {color:white}.RollRes a:active {color:white}.AbnormalRollRes {font-weight:700;font-size:8pt;color:red;font-family:Verdana,Arial,Helvetica}.AbnormalRollRes a:link {color:red}.AbnormalRollRes a:hover {color:red}.AbnormalRollRes a:visited {color:red}.AbnormalRollRes a:active {color:red}.CorrectedRollRes {font-weight:700;font-size:8pt;color:yellow;font-family:Verdana,Arial,Helvetica}.CorrectedRollRes a:link {color:yellow}.CorrectedRollRes a:hover {color:yellow}.CorrectedRollRes a:visited {color:yellow}.CorrectedRollRes a:active {color:yellow}.AbnormalRes {font-weight:bold;font-size:8pt;color:red;font-family:Verdana,Arial,Helvetica}.AbnormalRes a:link {color:red}.AbnormalRes a:hover {color:red}.AbnormalRes a:visited {color:red}.AbnormalRes a:active {color:red}.NormalRes {font-weight:bold;font-size:8pt;color:black;font-family:Verdana,Arial,Helvetica}.NormalRes a:link {color:black}.NormalRes a:hover {color:black}.NormalRes a:visited {color:black}.NormalRes a:active {color:black}.HiLoRes {font-weight:bold;font-size:8pt;color:blue;font-family:Verdana,Arial,Helvetica}.HiLoRes a:link {color:blue}.HiLoRes a:hover {color:blue}.HiLoRes a:visited {color:blue}.HiLoRes a:active {color:blue}.CorrectedRes {font-weight:bold;font-size:8pt;color:#E000D0;font-family:Verdana,Arial,Helvetica}.CorrectedRes a:link {color:#6da997}.CorrectedRes a:hover {color:#6da997}.CorrectedRes a:visited {color:#6da997}.CorrectedRes a:active {color:#6da997}.Field {font-weight:bold;font-size:8.5pt;color:black;font-family:Verdana,Arial,Helvetica}div.Field a:link {color:black}div.Field a:hover {color:black}div.Field a:visited {color:black}div.Field a:active {color:black}.Field2 {font-weight:bold;font-size:8pt;color:#ffffff;font-family:Verdana,Arial,Helvetica}div.FieldData {font-weight:normal;font-size:8pt;color:black;font-family:Verdana,Arial,Helvetica}div.Field3 {font-weight:normal;font-size:8pt;color:black;font-style:italic;font-family:Verdana,Arial,Helvetica}div.Title {font-weight:800;font-size:10pt;color:white;font-family:Verdana,Arial,Helvetica;padding-top:4pt;padding-bottom:2pt}div.Title a:link {color:white}div.Title a:hover {color:white}div.Title a:visited {color:white}div.Title a:active {color:white}div.Title2 {font-weight:bolder;font-size:9pt;color:black;text-indent:5pt;font-family:Verdana,Arial,Helvetica;padding:2pt 6pt 2pt 2pt}div.Title2 a:link {color:black}div.Title2 a:hover {color:black}div.Title2 a:visited {color:black}div.Title2 a:active {color:black}.Cell {background-color:#7999CC;border-left:thin solid #CCCCFF;border-right:thin solid #6666CC; border-top:thin solid #CCCCFF;border-bottom:thin solid #6666CC}.Cell2 {background-color:#376c95;border-left-style:none;border-left-width:medium;border-right-style:none;border-right-width:medium; border-top:thin none #bfcbe3;border-bottom-style:none;border-bottom-width:medium}.Cell3 {background-color:#add9c7;border-left:thin solid #dbfdeb;border-right:thin solid #5d9987; border-top:thin solid #dbfdeb;border-bottom:thin solid #5d9987}.CellHdr {background-color:#cbe5d7;border-right-style:none;border-right-width:medium;border-bottom-style:none;border-bottom-width:medium}.Nav {font-weight:bold;font-size:8pt;color:black;font-family:Verdana,Arial,Helvetica}.PageLink a:link {font-size:8pt;color:white}.PageLink a:hover {color:red}.PageLink a:visited {font-size:9pt;color:yellow}.PageLink a:active {font-size:12pt;color:yellow}.PageLink {font-family:Verdana}.titre{black;font-family: monospace;font-size:1em;font-weight:bolder;}@media screen {.text1 {font-size:0.8em;line-height:1;color:black;font-family: monospace;}.text1dsp {font-size:0.7em;line-height:1.3;color:black;font-family: monospace;}.po-name {font-size:0.8em;line-height:1;color:black;font-style:italic;}.text0 {font-size:0.8em;line-height:1.3;color:black;font-family: monospace;}.tableBgColor {background-color:#ECFAFF}}@media print {.text1 {font-size:0.7em;line-height:1.1;color:black;font-family: monospace;}.text1dsp {font-size:0.6em;line-height:1.3;color:black;font-family: monospace;}.po-name {font-size:0.6em;line-height:1;color:black;font-style:italic;}.text0 {font-size:0.6em;line-height:1.3;color:black;font-family: monospace;}.tableBgColor {background-color:#FFFFFF}}div.txt1 {font-size:8pt;color:black;font-family:Verdana,Arial}.red {color:red}.white {color:white} -->")).end();
        h.raw("<style type=\"text/css\" media=\"screen\">.show-on-print-only{display:none;}</style><style type=\"text/css\" media=\"print\">.show-on-print-only{display:block;}</style>");
        h.raw("<style type=\"text/css\" media=\"print\">.DoNotPrint{display:none;}</style>");
    }

    public String[] divideStringAtFirstNewline(String s) {
        int i = s.indexOf("<br />");
        String[] ret = new String[2];
        if (i == -1) {
            ret[0] = new String(s);
            ret[1] = null;
        } else {
            ret[0] = s.substring(0, i);
            ret[1] = s.substring(i + 6);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromFile(String file, String url) {
        String s;
        block10: {
            s = file;
            try {
                s = IOUtils.toString(LaboHtmlFormatter.class.getResourceAsStream(file), "UTF-8");
            }
            catch (IOException e1) {
                InputStream in = null;
                try {
                    in = new URL(url + file).openStream();
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (in == null) break block10;
                try {
                    try {
                        s = IOUtils.toString(in, "UTF-8");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly(in);
            }
        }
        return s;
    }
}

