/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.CtlDocumentPK;
import java.io.Serializable;

public class CtlDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String REF = "CtlDocument";
    public static String PROP_STATUS = "status";
    public static String PROP_MODULE_ID = "moduleId";
    public static String PROP_ID = "id";
    private int hashCode = Integer.MIN_VALUE;
    private CtlDocumentPK id;
    private Integer moduleId;
    private String status;

    public CtlDocument() {
        this.initialize();
    }

    public CtlDocument(CtlDocumentPK id) {
        this.setId(id);
        this.initialize();
    }

    public CtlDocument(CtlDocumentPK id, Integer moduleId) {
        this.setId(id);
        this.setModuleId(moduleId);
        this.initialize();
    }

    protected void initialize() {
    }

    public CtlDocumentPK getId() {
        return this.id;
    }

    public void setId(CtlDocumentPK id) {
        this.id = id;
        this.hashCode = Integer.MIN_VALUE;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isDemographicDocument() {
        return this.id.getModule() != null && this.id.getModule().equals("demographic");
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof CtlDocument)) {
            return false;
        }
        CtlDocument ctlDocument = (CtlDocument)obj;
        if (null == this.getId() || null == ctlDocument.getId()) {
            return false;
        }
        return this.getId().equals(ctlDocument.getId());
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.hashCode) {
            if (null == this.getId()) {
                return super.hashCode();
            }
            String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
            this.hashCode = hashStr.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        String ret = "";
        if (this.id != null) {
            ret = "doc No: " + this.id.getDocumentNo() + " module : " + this.id.getModule();
        }
        ret = ret + "module Id: " + this.moduleId + " status : " + this.status;
        return ret;
    }
}

