/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.wizard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XUserForSelection;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyTableCombo;
import ca.infodata.ofys.ui.controls.MyTableComboDataAdapter;
import ca.infodata.ofys.ui.controls.ProviderAAR;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.user.NullXUserForSelection;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TaskToCombo
implements IControl {
    private static final Logger logger = Logger.getLogger(TaskToCombo.class.getName());
    private static final List<TaskToCombo> instances = new CopyOnWriteArrayList<TaskToCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<TaskToCombo> toRemoveList = new ArrayList<TaskToCombo>();
                for (TaskToCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill(true);
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;
    private final NullXUserForSelection nullItem = new NullXUserForSelection();
    private MyTableComboDataAdapter<Object> adapter;
    private MyTableCombo myTableCombo;
    private final Color green;
    private final Color orange;
    private volatile boolean filling;
    private Object fillSelection;

    static {
        CompletionComboAccessorClient.addListener((String)"user", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public TaskToCombo(Composite parent, int style) {
        this.myTableCombo = new MyTableCombo(parent, style | 0x800){

            protected String getLabelControlTextPrefix(TableItem tableItem) {
                Object e = tableItem.getData();
                if (e == null || e instanceof XUserForSelection) {
                    return "";
                }
                return "Groupe : ";
            }
        };
        this.myTableCombo.setDisplayColumnIndex(0);
        this.myTableCombo.setVisibleItemCount(10);
        this.myTableCombo.setShowTableLines(true);
        this.myTableCombo.setShowTableHeader(true);
        this.myTableCombo.setShowColorWithinSelection(false);
        this.myTableCombo.setShowFontWithinSelection(false);
        this.myTableCombo.setShowImageWithinSelection(false);
        this.myTableCombo.setTextLimit(100);
        String helpText = "\u2193 et \u2191\t Naviguer dans la table (m\u00eame si la table est ferm\u00e9e) \nALT + \u2193\t Afficher ou fermer la table \nUne lettre\t S\u00e9lectionner le prochain \u00e9l\u00e9ment dont le nom commence par";
        ControlDecorator.decorateWithHelp((Control)this.myTableCombo, (String)helpText);
        this.green = ResourceGetter.getColor((int)204, (int)255, (int)204);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.green, (Widget)this.myTableCombo);
        this.orange = ResourceGetter.getColor((int)255, (int)204, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.orange, (Widget)this.myTableCombo);
        this.adapter = new MyTableComboDataAdapter(this.myTableCombo);
        this.adapter.addColumn(Messages.getString((String)"NOM", (String[])new String[0]));
        this.adapter.addColumn(Messages.getString((String)"TYPE", (String[])new String[0]));
        this.adapter.addColumn(Messages.getString((String)"SITE", (String[])new String[0]));
        this.adapter.addColumn(String.valueOf(Messages.getString((String)"ONLINE", (String[])new String[0])) + " ?", 0x1000000);
        this.adapter.setItemProvider((ProviderAAR)new ProviderAAR<Object, Table, TableItem>(){

            public TableItem get(Object e, Table table) {
                TableItem item = new TableItem(table, -1);
                if (e != null) {
                    if (e instanceof XUserForSelection) {
                        XUserForSelection user = (XUserForSelection)e;
                        item.setText(0, StringUtils.isBlank((CharSequence)user.personName) ? StringUtils.defaultString((String)user.userName).toUpperCase() : user.personName);
                        item.setText(1, StringUtils.defaultString((String)user.personType));
                        XSite site = SitePlugin.getDefault().getSite(user.sessionSiteId);
                        if (site != null) {
                            item.setText(2, StringUtils.isBlank((CharSequence)site.getNameCommon()) ? site.getNameOfficial() : site.getNameCommon());
                        }
                        if (user.sessionIsActive) {
                            item.setText(3, "\u221a");
                            item.setBackground(TaskToCombo.this.green);
                        }
                    } else if (e instanceof XPersonGroup) {
                        item.setText(0, ((XPersonGroup)e).getName());
                        item.setText(1, "Groupe");
                        item.setText(2, "-");
                        item.setText(3, "-");
                        item.setBackground(TaskToCombo.this.orange);
                    }
                }
                return item;
            }
        });
        this.adapter.add((Object)this.nullItem);
        instances.add(this);
        this.myTableCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(TaskToCombo.this);
            }
        });
    }

    public void fill(boolean async) {
        if (async) {
            this.fillAsync();
        } else {
            this.fillSync();
        }
    }

    private void fillSync() {
        block4: {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (!TaskToCombo.this.getControl().isDisposed()) {
                        TaskToCombo.this.fill((List)response.getObj());
                    }
                }

                public void exception(Exception e) {
                    TaskToCombo.this.filling = false;
                    super.exception(e);
                }
            };
            try {
                this.filling = true;
                UserAccessorClient.getInstance().listUsersForSelectionSync((ICallback)callback, Application.get().getGlobalInstances().getSession());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                this.filling = false;
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                this.filling = false;
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void fillAsync() {
        block4: {
            System.out.println("UserComboForSelection.fillAsync()");
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TaskToCombo.this.getControl().isDisposed()) {
                                TaskToCombo.this.fill((List)response.getObj());
                            }
                        }
                    });
                }

                public void exception(Exception e) {
                    TaskToCombo.this.filling = false;
                    super.exception(e);
                }
            };
            try {
                this.filling = true;
                UserAccessorClient.getInstance().listUsersForSelection((ICallback)callback, Application.get().getGlobalInstances().getSession());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                this.filling = false;
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                this.filling = false;
                logger.log(Level.SEVERE, "failed to fill usercombo", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void fill(List<XUserForSelection> users) {
        System.out.println("UserComboForSelection.fill()");
        if (users != null) {
            Iterator<XUserForSelection> iterator = users.iterator();
            while (iterator.hasNext()) {
                XUserForSelection e = iterator.next();
                if (e.personId != null) continue;
                iterator.remove();
            }
            Collections.sort(users, new Comparator<XUserForSelection>(){

                @Override
                public int compare(XUserForSelection o1, XUserForSelection o2) {
                    if ("infodata".equalsIgnoreCase(o1.userName)) {
                        return 1;
                    }
                    if ("infodata".equalsIgnoreCase(o2.userName)) {
                        return -1;
                    }
                    if (o1.personName == null) {
                        return 1;
                    }
                    if (o2.personName == null) {
                        return -1;
                    }
                    return StringUtils.compareAscii((String)o1.personName, (String)o2.personName);
                }
            });
            List groups = Application.get().getPersonPluginController().getActivePersonGroups().collect(Collectors.toList());
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(groups);
            list.add(this.nullItem);
            list.addAll(users);
            this.adapter.setItems(list);
            if (this.fillSelection != null && this.fillSelection != this.nullItem) {
                this.adapter.select(this.fillSelection);
            }
        }
    }

    public MyTableCombo getControl() {
        return this.myTableCombo;
    }

    public void addSelectionListener(Listener listener) {
        this.getControl().addListener(13, listener);
    }

    public void select(Integer toUser, Integer toGroup) {
        if (toUser != null) {
            XBaseUser user = PersonUiPlugin.getDefault().getUser(toUser);
            this.select(user);
        } else if (toGroup != null) {
            XPersonGroup group = Application.get().getPersonPluginController().getPersonGroupById(toGroup, true, true);
            this.select(group);
        }
    }

    private void select(XPersonGroup group) {
        XPersonGroup item = this.getGroupItem(group);
        if (group == null) {
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
        } else if (item != null) {
            this.adapter.select((Object)item);
        } else {
            item = group;
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
            if (this.filling) {
                this.fillSelection = group;
            }
        }
    }

    public Object getSelection() {
        Object selection = this.adapter.getSelection3();
        if (selection instanceof XUserForSelection) {
            XUserForSelection x = (XUserForSelection)selection;
            if (x.userId == null) {
                return null;
            }
            XBaseUser user = PersonUiPlugin.getDefault().getUser(x.userId);
            return user;
        }
        if (selection instanceof XPersonGroup) {
            XPersonGroup x = (XPersonGroup)selection;
            return x;
        }
        return null;
    }

    public XPersonGroup getGroupSelection() {
        Object selection = this.getSelection();
        if (selection instanceof XPersonGroup) {
            return (XPersonGroup)selection;
        }
        return null;
    }

    public XBaseUser getUserSelection() {
        Object selection = this.adapter.getSelection3();
        if (selection instanceof XUserForSelection) {
            XUserForSelection x = (XUserForSelection)selection;
            if (x.userId == null) {
                return null;
            }
            XBaseUser user = PersonUiPlugin.getDefault().getUser(x.userId);
            return user;
        }
        return null;
    }

    public void select(XBaseUser user) {
        XUserForSelection item = this.getUserItem(user);
        if (user == null) {
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
        } else if (item != null) {
            this.adapter.select((Object)item);
        } else {
            item = this.newItem(user);
            this.adapter.add((Object)item);
            this.adapter.select((Object)item);
            if (this.filling) {
                this.fillSelection = item;
            }
        }
    }

    private XUserForSelection getUserItem(XBaseUser user) {
        if (user != null) {
            for (Object u : this.adapter.getItems()) {
                if (!(u instanceof XUserForSelection)) continue;
                XUserForSelection item = (XUserForSelection)u;
                if (item.userId == null || !item.userId.equals(user.getId())) continue;
                return item;
            }
        }
        return null;
    }

    private XPersonGroup getGroupItem(XPersonGroup group) {
        if (group != null) {
            for (Object u : this.adapter.getItems()) {
                XPersonGroup item;
                if (!(u instanceof XPersonGroup) || !(item = (XPersonGroup)u).equals((Object)group)) continue;
                return item;
            }
        }
        return null;
    }

    private XUserForSelection newItem(XBaseUser user) {
        XUserForSelection item = new XUserForSelection();
        item.userId = user.getId();
        item.personId = user.getIdPerson();
        item.personName = user.getPersonNameOrTextOrEmpty();
        item.personType = "";
        item.sessionIsActive = false;
        item.sessionSiteId = null;
        return item;
    }

    public void setEnabled(boolean enabled) {
        this.myTableCombo.setEnabled(enabled);
    }
}

