/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.wizard;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.chat.LINK_TYPE;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskPriority;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyDateTime;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.task.wizard.TaskToCombo;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;

class TaskPageOne
extends WizardPage {
    private static final String S_O = Messages.getString((String)"SO", (String[])new String[0]);
    private static final String AU_SUJET_DE = Messages.getString((String)"AU_SUJET_DE", (String[])new String[0]);
    private static final String CREER_UNE_NOUVELLE_TACHE = Messages.getString((String)"CREER_UNE_NOUVELLE_TACHE", (String[])new String[0]);
    private static final String EDITER_UNE_TACHE = Messages.getString((String)"EDITER_UNE_TACHE", (String[])new String[0]);
    private static final String DE = Messages.getString((String)"DE", (String[])new String[0]).toLowerCase();
    protected TemplateAssistText txtNote;
    protected TaskToCombo cmbTo;
    protected MyCombo<XTaskPriority> cmbPriority;
    protected MyButton chkIsCompleted;
    protected MyButton chkAutoSendReminder;
    protected MyLabel lblTimeReminderSent;
    protected MyDateTime txtTime;
    protected MyLabel lblFrom;
    protected Label separator;
    private XTask task;
    private Composite parent;
    private boolean isRefreshing;

    public TaskPageOne(XTask task) {
        super(Messages.getString((String)"TACHES", (String[])new String[0]), task.getId() == null ? CREER_UNE_NOUVELLE_TACHE : EDITER_UNE_TACHE, ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/date-task-icon32.png")));
        this.task = task;
    }

    public void showDataObject() {
        try {
            this.isRefreshing = true;
            if (this.task.getFromUser() != null) {
                this.lblFrom.setText(this.lblFrom.getData() + " : " + PersonUiPlugin.getDefault().getUserPersonName(this.task.getFromUser()));
            } else {
                this.lblFrom.setText(this.lblFrom.getData() + " : ");
            }
            this.txtNote.setText(this.task.getNote());
            if (this.task.getDueDatetime() == null) {
                this.txtTime.setDateTime(null);
            } else {
                Calendar c = DateUtil.newCalendar();
                c.setTimeInMillis(this.task.getDueDatetime());
                this.txtTime.setDateTime(c);
            }
            this.chkAutoSendReminder.setSelection(Boolean.TRUE.equals(this.task.getAutoSendReminder()));
            this.lblTimeReminderSent.setText(this.task.getTimeReminderDone() == null ? "                                  " : Messages.getString((String)"RAPPEL_TRANSMIS", (String[])new String[]{DateUtil.ttoc((long)this.task.getTimeReminderDone())}));
            this.cmbTo.select(this.task.getToUser(), this.task.getToGroup());
            this.cmbPriority.select((Object)(this.task.getPriority() == null ? XTaskPriority.NORMAL : this.task.getPriority()));
            this.chkIsCompleted.setSelection(this.task.getCompletionDatetime() != null);
            Integer idLink = this.task.getIdLink();
            LINK_TYPE linkType = this.task.getLinkType();
            if (this.task.getCompletionDatetime() != null) {
                this.txtTime.setEnabled(false);
                this.txtNote.setEditable(false);
                this.cmbPriority.setEnabled(false);
                this.cmbTo.setEnabled(false);
            }
            if (this.task.getId() != null) {
                this.createLinks(linkType, idLink, this.task.getPatient());
            } else {
                this.createFormGroup(linkType, idLink, this.task.getPatient());
            }
        }
        finally {
            this.isRefreshing = false;
        }
    }

    private void createFormGroup(final LINK_TYPE linkType, final Integer idLink, final XPatient patient) {
        MyLabel lblAuSujetDe = new MyLabel(this.parent, AU_SUJET_DE, 0, null);
        FontAwareGroup grpAbout = new FontAwareGroup(this.parent, 0);
        grpAbout.setText("");
        grpAbout.setLayout((Layout)new FormLayout());
        MyButton btnPatient = new MyButton((Composite)grpAbout, "-", 16, null);
        MyButton btnLink = new MyButton((Composite)grpAbout, "-", 16, null);
        MyButton btnNone = new MyButton((Composite)grpAbout, S_O, 16, null);
        btnPatient.setEnabled(false);
        btnNone.setEnabled(true);
        btnLink.setEnabled(false);
        if (idLink != null && linkType != null) {
            String de = "";
            if (patient != null) {
                de = " " + DE + " " + patient.getNameBirthdateSex();
            }
            btnLink.setData("idType", (Object)linkType.getId());
            btnLink.setData("id", (Object)idLink);
            if (this.task.getId() == null) {
                btnLink.setEnabled(true);
            }
            btnLink.setSelection(true);
            if (linkType.equals((Object)LINK_TYPE.LABO)) {
                btnLink.setText(String.valueOf(LINK_TYPE.LABO.getTexte()) + de);
            } else if (linkType.equals((Object)LINK_TYPE.RENCONTRE)) {
                btnLink.setText(String.valueOf(LINK_TYPE.RENCONTRE.getTexte()) + de);
            } else if (linkType.equals((Object)LINK_TYPE.SCAN)) {
                btnLink.setText(String.valueOf(LINK_TYPE.SCAN.getTexte()) + de);
            } else if (linkType.equals((Object)LINK_TYPE.PATIENT) && patient != null) {
                btnLink.setEnabled(false);
                btnLink.setSelection(false);
            } else if (linkType.equals((Object)LINK_TYPE.S_O)) {
                btnLink.setEnabled(false);
                btnLink.setSelection(false);
            }
        }
        if (patient != null) {
            btnPatient.setText(patient.getNameBirthdateSex());
            btnPatient.setEnabled(true);
            btnPatient.setSelection(true);
            btnNone.setSelection(false);
        }
        btnPatient.setSelection(!btnLink.getSelection() && btnPatient.isEnabled());
        btnNone.setSelection(!btnPatient.getSelection() && !btnLink.getSelection());
        btnNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskPageOne.this.task.setIdLink(null);
                TaskPageOne.this.task.setLinkType(null);
                TaskPageOne.this.task.setIdPatient(null);
            }
        });
        btnPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskPageOne.this.task.setIdLink(patient.getId());
                TaskPageOne.this.task.setLinkType(LINK_TYPE.PATIENT);
                TaskPageOne.this.task.setIdPatient(patient.getId());
            }
        });
        btnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskPageOne.this.task.setIdLink(idLink);
                TaskPageOne.this.task.setLinkType(linkType);
                TaskPageOne.this.task.setIdPatient(patient.getId());
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblAuSujetDe.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblAuSujetDe.getControl(), -10);
        data.left = new FormAttachment(0, -3);
        data.right = new FormAttachment(100);
        grpAbout.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        btnPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(btnPatient.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        btnLink.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(btnLink.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        btnNone.setLayoutData((Object)data);
        data = (FormData)this.separator.getLayoutData();
        data.top = new FormAttachment((Control)grpAbout);
        this.parent.layout(true, true);
        this.parent.pack(true);
    }

    private void createLinks(LINK_TYPE linkType, final Integer idLink, final XPatient patient) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.task.getId() != null && linkType != LINK_TYPE.S_O && patient != null) {
            Link link;
            if (linkType == LINK_TYPE.LABO && idLink != null) {
                link = new Link(this.parent, 0);
                link.setText("<a href=\"_blank\">" + LINK_TYPE.LABO.getTexte() + "</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskPageOne.this.closeCancel();
                        XBaseLaboResultsProfessionnal labo = new XBaseLaboResultsProfessionnal();
                        labo.setId(idLink);
                        labo.setPatient((IPatient)patient);
                        BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)labo), (String)LINK_TYPE.LABO.getClassName());
                    }
                });
                links.add(link);
            }
            if (linkType == LINK_TYPE.SCAN && idLink != null) {
                link = new Link(this.parent, 0);
                link.setText("<a href=\"_blank\">" + LINK_TYPE.SCAN.getTexte() + "</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskPageOne.this.closeCancel();
                        XBasePatientImage scan = new XBasePatientImage();
                        scan.setId(idLink);
                        scan.setIdPatient(patient.getId());
                        BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)scan), (String)LINK_TYPE.SCAN.getClassName());
                    }
                });
                links.add(link);
            }
            link = new Link(this.parent, 0);
            link.setText("<a href=\"_blank\">Patient: " + patient.getNameBirthdateSex() + "</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskPageOne.this.closeCancel();
                    BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)patient), (String)LINK_TYPE.PATIENT.getClassName());
                }
            });
            links.add(link);
        }
        if (links.size() > 0) {
            MyLabel lblLiens = new MyLabel(this.parent, Messages.getString((String)"LIENS", (String[])new String[0]), 0);
            FormData data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            lblLiens.setLayoutData((Object)data);
            Control prev = lblLiens.getControl();
            for (Link link : links) {
                data = new FormData();
                data.top = new FormAttachment(prev, -5);
                data.left = new FormAttachment(0);
                data.right = new FormAttachment(100);
                link.setLayoutData((Object)data);
                prev = link;
            }
            data = (FormData)this.separator.getLayoutData();
            data.top = new FormAttachment((Control)links.get(links.size() - 1));
            this.parent.layout(true, true);
            this.parent.pack(true);
        }
    }

    public void createControl(Composite parent) {
        parent = this.parent = new Composite(parent, 0);
        this.separator = new Label(parent, 258);
        MyLabel lblNote = new MyLabel(parent, "Note", 0);
        this.txtNote = new TemplateAssistText(parent, 2626);
        this.txtNote.setType(XCompletionProposalType.TASK_NOTE);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtNote, (int)16512);
        this.txtNote.getStyledText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TaskPageOne.this.isRefreshing) {
                    TaskPageOne.this.task.setNote(TaskPageOne.this.txtNote.getText());
                }
            }
        });
        MyLabel lblPriority = new MyLabel(parent, Messages.getString((String)"PRIORITE", (String[])new String[0]), 0);
        this.cmbPriority = new MyCombo(parent, 8);
        this.cmbPriority.setItems((Object[])XTaskPriority.values());
        this.cmbPriority.select((Object)XTaskPriority.NORMAL);
        this.cmbPriority.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (!TaskPageOne.this.isRefreshing) {
                    TaskPageOne.this.task.setPriority((XTaskPriority)TaskPageOne.this.cmbPriority.getSelection());
                }
            }
        });
        MyLabel lblDueDate = new MyLabel(parent, Messages.getString((String)"ECHEANCE", (String[])new String[0]), 0);
        this.txtTime = new MyDateTime(parent, 0);
        DateText.DateAdapter dateStartListener = new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (!TaskPageOne.this.isRefreshing) {
                    MyDateTime d = TaskPageOne.this.txtTime;
                    if (d.getDateTime() == null) {
                        TaskPageOne.this.task.setDueDatetime(null);
                    } else {
                        TaskPageOne.this.task.setDueDatetime(Long.valueOf(d.getDateTime().getTimeInMillis()));
                    }
                    TaskPageOne.this.checkTimeReminderDone(TaskPageOne.this.task.getDueDatetime());
                }
            }
        };
        SelectionAdapter timeStartListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TaskPageOne.this.isRefreshing) {
                    MyDateTime d = TaskPageOne.this.txtTime;
                    if (d.getDateTime() == null) {
                        TaskPageOne.this.task.setDueDatetime(null);
                    } else {
                        TaskPageOne.this.task.setDueDatetime(Long.valueOf(d.getDateTime().getTimeInMillis()));
                    }
                    TaskPageOne.this.checkTimeReminderDone(TaskPageOne.this.task.getDueDatetime());
                }
            }
        };
        this.txtTime.addDateSelectionListener((DateText.IDateListener)dateStartListener);
        this.txtTime.addTimeSelectionListener((SelectionListener)timeStartListener);
        this.chkIsCompleted = new MyButton(parent, Messages.getString((String)"IS_COMPLETED_", (String[])new String[0]), 32, null);
        this.chkIsCompleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TaskPageOne.this.isRefreshing) {
                    if (TaskPageOne.this.chkIsCompleted.getSelection()) {
                        TaskPageOne.this.task.setCompletionDatetime(Long.valueOf(DateUtil.nowUTC()));
                    } else {
                        TaskPageOne.this.task.setCompletionDatetime(null);
                    }
                }
            }
        });
        this.chkAutoSendReminder = new MyButton(parent, Messages.getString((String)"AUTO_SEND_REMINDER", (String[])new String[0]), 32, null);
        this.chkAutoSendReminder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TaskPageOne.this.isRefreshing) {
                    TaskPageOne.this.task.setAutoSendReminder(Boolean.valueOf(TaskPageOne.this.chkAutoSendReminder.getSelection()));
                }
            }
        });
        this.lblTimeReminderSent = new MyLabel(parent, "                                    ", 0);
        MyLabel lblUsers = new MyLabel(parent, Messages.getString((String)"_A", (String[])new String[0]), 0);
        this.lblFrom = new MyLabel(parent, Messages.getString((String)"DE", (String[])new String[0]), 0, null);
        this.lblFrom.setData((Object)Messages.getString((String)"DE", (String[])new String[0]));
        this.cmbTo = new TaskToCombo(parent, 8);
        this.cmbTo.fill(true);
        this.cmbTo.addSelectionListener(new Listener(){

            public void handleEvent(Event e) {
                if (!TaskPageOne.this.isRefreshing) {
                    Object selection = TaskPageOne.this.cmbTo.getSelection();
                    if (selection instanceof XPersonGroup) {
                        TaskPageOne.this.task.setToGroup(((XPersonGroup)selection).getId());
                        TaskPageOne.this.task.setToUser(null);
                    } else if (selection instanceof XBaseUser) {
                        TaskPageOne.this.task.setToGroup(null);
                        TaskPageOne.this.task.setToUser(((XBaseUser)selection).getId());
                    } else {
                        TaskPageOne.this.task.setToGroup(null);
                        TaskPageOne.this.task.setToUser(null);
                    }
                }
            }
        });
        MyLabel lblBottomTempon = new MyLabel(parent, 0x800000);
        FormLayout layout = new FormLayout();
        layout.marginTop = 10;
        layout.marginWidth = 10;
        layout.spacing = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.separator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTo.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblUsers.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.separator);
        data.left = new FormAttachment(lblUsers.getControl());
        data.right = new FormAttachment(33);
        this.cmbTo.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTo.getControl(), 0, 0x1000000);
        data.left = new FormAttachment((Control)this.cmbTo.getControl(), 20);
        data.right = new FormAttachment(100);
        this.lblFrom.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbPriority.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblPriority.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTo.getControl());
        data.left = new FormAttachment(lblPriority.getControl());
        data.right = new FormAttachment((Control)this.cmbTo.getControl(), 0, 131072);
        this.cmbPriority.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbPriority.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblNote.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblNote.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 100;
        data.width = 800;
        this.txtNote.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtTime, 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblDueDate.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNote.getControl());
        data.left = new FormAttachment(lblDueDate.getControl());
        this.txtTime.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtTime, 0, 0x1000000);
        data.right = new FormAttachment(100);
        this.chkIsCompleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtTime, 0);
        data.left = new FormAttachment(0);
        this.chkAutoSendReminder.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.txtTime, 0);
        data.left = new FormAttachment(this.chkAutoSendReminder.getControl(), 5);
        this.lblTimeReminderSent.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblTimeReminderSent.getControl(), 5);
        data.left = new FormAttachment(lblDueDate.getControl());
        data.height = 50;
        lblBottomTempon.setLayoutData((Object)data);
        this.txtNote.getStyledText().setFocus();
        this.setControl((Control)parent);
        this.setPageComplete(true);
        this.showDataObject();
    }

    protected void checkTimeReminderDone(Long dueDatetime) {
        if (dueDatetime != null && Boolean.TRUE.equals(this.task.getAutoSendReminder()) && this.task.getTimeReminderDone() != null && dueDatetime > this.task.getTimeReminderDone() + TimeUnit.HOURS.toMillis(12L)) {
            this.task.setTimeReminderDone(null);
            this.lblTimeReminderSent.setText("                          ");
        }
    }

    protected Long getDueDateTime() {
        Long time = new Long(0L);
        Calendar cal = this.txtTime.getDateTime();
        time = cal == null ? null : Long.valueOf(cal.getTimeInMillis());
        return time;
    }

    protected void closeCancel() {
        PropertyListenerManager.firePropertyChanged((Object)this.getWizard(), (int)1);
    }
}

