/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskPriority;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElements2;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.task.data.client.dataaccess.TaskAccessorClient;
import ca.infodata.ofys.ui.task.wizard.TaskWizard;
import ca.infodata.ofys.ui.task.wizard.TaskWizardDialog;
import ca.infodata.util1.date.DateUtil;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.time.FastDateFormat;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public class TaskElement
extends AbstractTreeElement
implements ITreeElements2,
IFontProvider,
IColorProvider {
    private static final Logger logger = Logger.getLogger(TaskElement.class.getName());
    private static final FastDateFormat simpleDateFormat = FastDateFormat.getInstance((String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH'h'mm"));
    private static final String MASSIGNER_CETTE_TACHE = Messages.getString((String)"MASSIGNER_CETTE_TACHE", (String[])new String[0]);
    private static final String MARQUER_COMME_COMPLETEE = Messages.getString((String)"MARQUER_COMME_COMPLETEE", (String[])new String[0]);
    private static final String MARQUER_COMME_NON_COMPLETEE = Messages.getString((String)"MARQUER_COMME_NON_COMPLETEE", (String[])new String[0]);
    private final XTask task;
    private boolean showPatientName;

    public TaskElement(ITreeElements parent, XTask task) {
        super(parent);
        this.task = task;
        this.showPatientName = true;
        this.childrenNumber = 0;
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        String pt = "";
        if (this.showPatientName && this.task.getIdPatient() != null) {
            pt = String.valueOf(this.task.getPatient().getNameBirthdateSex()) + " -> ";
        }
        String s = String.valueOf(pt) + simpleDateFormat.format(new Date(this.task.getCreateDatetime()));
        if (this.task.getDueDatetime() != null && this.task.getCompletionDatetime() == null) {
            s = String.valueOf(s) + " - " + Messages.getString((String)"ECHEANCE", (String[])new String[0]) + ": " + simpleDateFormat.format(new Date(this.task.getDueDatetime()));
        }
        s = String.valueOf(s) + " " + this.task.getNote();
        return s;
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/date-task-icon16.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public int hashCode() {
        return new String(String.valueOf(this.getParent().hashCode()) + " " + this.task.hashCode() + " " + this.task.getVersion()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof TaskElement && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public XImageDecorator getDecorators() {
        if (this.task.getPriority() == XTaskPriority.HAUT) {
            XImageDecorator decorator = new XImageDecorator();
            decorator.bottomLeftImageName = "urgent.gif";
            return decorator;
        }
        return null;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void doDoubleClick() {
        TaskWizardDialog dialog = new TaskWizardDialog(UI.getWorkbenchShell(), (IWizard)new TaskWizard(this.task));
        dialog.open();
    }

    public void showContextMenu(Control control) {
        if (this.task.getToUser() == null) {
            Menu menu = new Menu(control);
            menu.setVisible(true);
            MenuItem item = new MenuItem(menu, 64);
            item.setText(MASSIGNER_CETTE_TACHE);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XTask task = TaskElement.this.task.clone();
                    task.setToUser(Application.get().getGlobalInstances().getSession().getUser().getId());
                    task.setToGroup(null);
                    task.setUpdated();
                    TaskElement.this.save(task);
                }
            });
        } else {
            Integer sessionIdUser = Application.get().getGlobalInstances().getSessionIdUser();
            if (sessionIdUser != null && sessionIdUser.equals(this.task.getToUser())) {
                if (this.task.getCompletionDatetime() != null) {
                    Menu menu = new Menu(control);
                    menu.setVisible(true);
                    MenuItem item = new MenuItem(menu, 64);
                    item.setText(MARQUER_COMME_NON_COMPLETEE);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            XTask task = TaskElement.this.task.clone();
                            task.setCompletionDatetime(null);
                            task.setUpdated();
                            TaskElement.this.save(task);
                        }
                    });
                } else {
                    Menu menu = new Menu(control);
                    menu.setVisible(true);
                    MenuItem item = new MenuItem(menu, 64);
                    item.setText(MARQUER_COMME_COMPLETEE);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            XTask task = TaskElement.this.task.clone();
                            task.setCompletionDatetime(Long.valueOf(DateUtil.nowUTC()));
                            task.setUpdated();
                            TaskElement.this.save(task);
                        }
                    });
                }
            }
        }
    }

    protected void save(XTask task) {
        SaveCallback callback = new SaveCallback(Application.get().getGlobalInstances().getSession(), (IStatusHandler)DefaultStatusHandler.getInstance());
        try {
            try {
                TaskAccessorClient.getInstance().save(this.hashCode(), Application.get().getGlobalInstances().getSession(), callback, (IDataObject)task, true);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                callback.kill();
            }
        }
        finally {
            callback.kill();
        }
    }

    public void doSelect() {
        if (this.task != null && this.task.getId() != null) {
            XPatient patient = this.task.getPatient();
            if (patient == null && this.task.getIdPatient() != null) {
                patient = PatientUtil.getXPatient((Object)this.task.getIdPatient());
            }
            PersonUiPlugin.getDefault().setCurrentPatient((IPatient)patient);
        }
    }

    public boolean isShowPatientName() {
        return this.showPatientName;
    }

    public void setShowPatientName(boolean showPatientName) {
        this.showPatientName = showPatientName;
    }

    public Font getFont(Object element) {
        XTask e;
        if (element instanceof TaskElement && (e = ((TaskElement)((Object)element)).task).getDueDatetime() != null && e.getDueDatetime() < DateUtil.now() && e.getCompletionDatetime() == null) {
            return ResourceGetter.getFontBold();
        }
        return ResourceGetter.getFontNormal();
    }

    public Color getForeground(Object element) {
        XTask e;
        if (element instanceof TaskElement && (e = ((TaskElement)((Object)element)).task).getDueDatetime() != null && e.getDueDatetime() < DateUtil.now() && e.getCompletionDatetime() == null) {
            int o = 0;
            return ResourceGetter.getColor((int[])new int[]{255, o, o});
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

