/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.task.XTask;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskCriteria;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.task.menu.AbstractListTaskElement;
import ca.infodata.ofys.ui.task.menu.ListCompletedTaskElement;
import ca.infodata.ofys.ui.task.menu.ListGroupTaskElement;
import ca.infodata.ofys.ui.task.menu.ListNonAssignedTaskElement;
import ca.infodata.ofys.ui.task.menu.ListUserSentTaskElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ListUserTaskElement
extends AbstractListTaskElement {
    private static final String TACHES = Messages.getString((String)"TACHES", (String[])new String[0]);
    private static final String POUR = Messages.getString((String)"POUR", (String[])new String[0]);
    private XBaseUser user;

    public ListUserTaskElement(ITreeElements parent, XBaseUser user) {
        super(parent, new XTaskCriteria().setToUser(user.getId()).setCompleted(Boolean.valueOf(false)));
        this.user = user;
        this.initAsLoading();
        this.loadListAsync();
    }

    @Override
    protected String getBaseText() {
        int id;
        String user = "";
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null && session.getUser() != null && (id = session.getUser().getId().intValue()) != this.user.getId()) {
            user = " " + POUR + " " + this.user.getPersonNameOrTextOrEmpty();
        }
        return String.valueOf(TACHES) + user;
    }

    @Override
    protected List<ITreeElements> getListLoading() {
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>();
        list.add((ITreeElements)new LoadingElement((ITreeElements)this));
        list.add(new ListCompletedTaskElement(this, this.getCriteria()));
        list.add(new ListUserSentTaskElement(this, this.user));
        List groups = Application.get().getPersonPluginController().getActivePersonGroups().collect(Collectors.toList());
        Collections.sort(groups);
        for (XPersonGroup group : groups) {
            if (group.getPersons() == null || !group.getPersons().contains(this.user.idPerson)) continue;
            list.add(new ListGroupTaskElement((ITreeElements)this, group));
        }
        list.add(new ListNonAssignedTaskElement(this));
        return list;
    }

    @Override
    protected List<ITreeElements> getListResponse(List<XTask> list2) {
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>();
        list.addAll(super.getListResponse(list2));
        ITreeElements listCompleted = this.getByClass(this.getChilds(), ListCompletedTaskElement.class);
        if (listCompleted == null) {
            listCompleted = new ListCompletedTaskElement(this, this.getCriteria());
        }
        list.add(listCompleted);
        ITreeElements listUserSent = this.getByClass(this.getChilds(), ListUserSentTaskElement.class);
        if (listUserSent == null) {
            listUserSent = new ListUserSentTaskElement(this, this.user);
        }
        list.add(listUserSent);
        List groupElements = this.findByClass(this.getChilds(), new Class[]{ListGroupTaskElement.class});
        if (groupElements.isEmpty()) {
            List groups = Application.get().getPersonPluginController().getActivePersonGroups().collect(Collectors.toList());
            Collections.sort(groups);
            for (XPersonGroup group : groups) {
                if (group.getPersons() == null || !group.getPersons().contains(this.user.idPerson)) continue;
                list.add(new ListGroupTaskElement((ITreeElements)this, group));
            }
        } else {
            list.addAll(groupElements);
        }
        ITreeElements listNonAssigned = this.getByClass(this.getChilds(), ListNonAssignedTaskElement.class);
        if (listNonAssigned == null) {
            list.add(new ListNonAssignedTaskElement(this));
        } else {
            list.add(listNonAssigned);
        }
        return list;
    }

    @Override
    public int getChildrenNumberForPastille() {
        int sum = Math.max(super.getChildrenNumberForPastille(), 0);
        for (ITreeElements c : this.getChilds()) {
            if (!(c instanceof ListGroupTaskElement)) continue;
            sum += Math.max(c.getChildrenNumberForPastille(), 0);
        }
        return sum > 0 ? sum : -1;
    }

    @Override
    protected boolean needRedPastilleColor() {
        boolean needRedPastilleColor = super.needRedPastilleColor();
        if (!needRedPastilleColor) {
            List list = this.getChilds();
            int i = 0;
            while (i < list.size() && !needRedPastilleColor) {
                ITreeElements c = (ITreeElements)list.get(i);
                if (c instanceof ListGroupTaskElement) {
                    needRedPastilleColor = ((ListGroupTaskElement)c).needRedPastilleColor();
                }
                ++i;
            }
        }
        return needRedPastilleColor;
    }
}

