/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.task.data.client.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ITaskAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.task.XTaskCriteria;
import ca.infodata.ofys.ui.task.TaskPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(TaskAccessorClient.class.getName());
    private static TaskAccessorClient instance;
    private ITaskAccessor accessor;

    public static TaskAccessorClient getInstance() throws CannotConnectToServerException {
        return TaskAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static TaskAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new TaskAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(((Object)((Object)instance)).getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private TaskAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getTaskAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(((Object)((Object)this)).getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected ITaskAccessor getAccessor() {
        return this.accessor;
    }

    public void findTask(final XTaskCriteria criteria, final ICallback callback, final XSession session) {
        logger.log(Level.INFO, "findTask " + criteria);
        final String function = "TaskAccessorClient.findTask " + criteria;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ICallback run() {
                    try {
                        try {
                            XSession xSession = session;
                            synchronized (xSession) {
                                String cacheHash = criteria.toStringForHash();
                                ReturnObject response = TaskPlugin.getDefault().getCached(cacheHash);
                                if (response == null) {
                                    response = instance.accessor.findTask(criteria);
                                    TaskPlugin.getDefault().add(cacheHash, response);
                                }
                                callback.response(response);
                            }
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            TaskAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        TaskAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }
}

