/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.site2.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.ui.site2.menu.ListSiteSearched;
import ca.infodata.ofys.ui.site2.menu.NewSiteElement;
import ca.infodata.ofys.ui.site2.menu.SubListSiteElement;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class ListSiteElement
implements ITreeElements,
CompletionComboAccessorClient.CompletionComboListener {
    private ITreeElements parent;
    private ITreeElements[] children;

    public ListSiteElement(ITreeElements parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
        CompletionComboAccessorClient.addListener((String)XSite.type, (CompletionComboAccessorClient.CompletionComboListener)this);
    }

    public Object[] getChildren() {
        if (this.children == null) {
            List<ITreeElements> listChild = this.fillChildren(SitePlugin.getDefault().getWorkSites());
            this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        }
        return this.children;
    }

    protected List<ITreeElements> fillChildren(List<XSite> sites) {
        Collections.sort(sites, new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return StringUtils.compareAscii((String)o1.getNameCommon(), (String)o2.getNameCommon());
            }
        });
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>(sites.size() + 1);
        if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_SITE)) {
            list.add(new NewSiteElement(this));
        }
        list.add(new SubListSiteElement(this, sites, Messages.getString((String)"SITES_DE_TRAVAIL", (String[])new String[0])));
        list.add((ITreeElements)new ListSiteSearched(this));
        return list;
    }

    protected List<ITreeElements> fillChildren(Stream<XSite> stream) {
        List sites = stream.sorted(new Comparator<XSite>(){

            @Override
            public int compare(XSite o1, XSite o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return StringUtils.compareAscii((String)o1.getNameCommon(), (String)o2.getNameCommon());
            }
        }).collect(Collectors.toList());
        ArrayList<ITreeElements> list = new ArrayList<ITreeElements>(sites.size());
        if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_SITE)) {
            list.add(new NewSiteElement(this));
        }
        ArrayList<XSite> workSites = new ArrayList<XSite>();
        for (XSite s : sites) {
            if (!Boolean.TRUE.equals(s.getIsWorkSite())) continue;
            workSites.add(s);
        }
        list.add(new SubListSiteElement(this, workSites, Messages.getString((String)"SITES_DE_TRAVAIL", (String[])new String[0])));
        ArrayList<XSite> nonDeletedSites = new ArrayList<XSite>();
        for (XSite s : sites) {
            if (Boolean.TRUE.equals(s.getIsDeleted())) continue;
            nonDeletedSites.add(s);
        }
        list.add(new SubListSiteElement(this, nonDeletedSites, Messages.getString((String)"SITES_ACTIFS", (String[])new String[0])));
        ArrayList<XSite> deletedSites = new ArrayList<XSite>();
        for (XSite s : sites) {
            if (!Boolean.TRUE.equals(s.getIsDeleted())) continue;
            deletedSites.add(s);
        }
        list.add(new SubListSiteElement(this, deletedSites, Messages.getString((String)"SITES_SUPPRIMES", (String[])new String[0])));
        return list;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"SITES", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/site16_2.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListSiteElement && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void shouldRefresh(ICompletionComboItem item) {
        this.children = null;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

