/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.scan;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PatientImageAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageContainer;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlImageViewerResource;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.IRunnableWithProgressWithLog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialogWithLog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.preferences.PreferencesPlugin;
import ca.infodata.ofys.ui.scan.scan.BaseScanEditor;
import ca.infodata.ofys.ui.scan.scan.CodeReader;
import ca.infodata.ofys.ui.scan.scan.ProfItem;
import ca.infodata.ofys.ui.scan.scan.Scan;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.BusinessException;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.image.ImageUtil;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import com.sun.pdfview.PDFFile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetNonStrokingDeviceRGBColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorN;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingColorSpace;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceCMYKColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceGrayColor;
import org.apache.pdfbox.contentstream.operator.color.SetStrokingDeviceRGBColor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.nightlabs.eclipse.ui.pdfviewer.OneDimensionalPdfDocument;
import org.nightlabs.eclipse.ui.pdfviewer.PdfDocument;

public class ScanEditor
extends BaseScanEditor
implements IPatientRelated {
    private static final Logger logger = Logger.getLogger(ScanEditor.class.getName());
    private static final String RECONAISSANCE = Messages.getString((String)"ScanEditor.RECONAISSANCE", (String[])new String[0]);
    private static final String PHASE_1_TRI_FICHIER_ = Messages.getString((String)"ScanEditor.PHASE_1_TRI_FICHIER_", (String[])new String[0]);
    private static final String PHASE_2_TRI_FICHIER_ = Messages.getString((String)"ScanEditor.PHASE_2_TRI_FICHIER_", (String[])new String[0]);
    private static final String TRI_FICHIER_ = Messages.getString((String)"ScanEditor.TRI_FICHIER_", (String[])new String[0]);
    private static final String _DE_ = Messages.getString((String)"ScanEditor._DE_", (String[])new String[0]);
    private static final String PROGRESSION_ = Messages.getString((String)"ScanEditor.PROGRESSION_", (String[])new String[0]);
    private static final String PAGE_ = Messages.getString((String)"ScanEditor.PAGE_", (String[])new String[0]);
    private static final String DOCUMENTS = Messages.getString((String)"ScanEditor.DOCUMENTS", (String[])new String[0]);
    private static final String ERREUR = Messages.getString((String)"ScanEditor.ERREUR", (String[])new String[0]);
    private static final String AVERTISSEMENT = Messages.getString((String)"ScanEditor.AVERTISSEMENT", (String[])new String[0]);
    private static final String LE_FICHIER_CHOISI_NEST_PAS_UNE_IMAGE_OU_CE_DERNIER_EST_CORROMPU = Messages.getString((String)"ScanEditor.LE_FICHIER_CHOISI_NEST_PAS_UNE_IMAGE_OU_CE_DERNIER_EST_CORROMPU", (String[])new String[0]);
    private static final String _DOCUMENTS_RESTANTS = Messages.getString((String)"ScanEditor._DOCUMENTS_RESTANTS", (String[])new String[0]);
    private static final String ERREUR_LORS_DE_LA_SAUVEGARDE_DE_LIMAGE_CETTE_IMAGE_NA_PAS_ETE_SAUVEGARDEE = Messages.getString((String)"ScanEditor.ERREUR_LORS_DE_LA_SAUVEGARDE_DE_LIMAGE_CETTE_IMAGE_NA_PAS_ETE_SAUVEGARDEE", (String[])new String[0]);
    private static final String VEUILLEZ_LA_NUMERISER_A_NOUVEAU_AVEC_DE_BONS_PARAMETRES = Messages.getString((String)"ScanEditor.VEUILLEZ_LA_NUMERISER_A_NOUVEAU_AVEC_DE_BONS_PARAMETRES", (String[])new String[0]);
    private static final String RESULTAT_DEXAMEN = Messages.getString((String)"ScanEditor.RESULTAT_DEXAMEN", (String[])new String[0]);
    private static final String ERROR_IMG_TRANSFO = Messages.getString((String)"ScanEditor.ERROR_IMG_TRANSFO", (String[])new String[0]);
    private static final String ERROR_DS_MODIF = Messages.getString((String)"ScanEditor.ERROR_DS_MODIF", (String[])new String[0]);
    private static final String TRAITANT = Messages.getString((String)"ScanEditor.TRAITANT", (String[])new String[0]);
    private static final String AUTRES = Messages.getString((String)"ScanEditor.AUTRES", (String[])new String[0]);
    private static final String NUMERISER_DES_DOCUMENTS = Messages.getString((String)"ListScan.NUMERISER_DES_DOCUMENTS", (String[])new String[0]);
    private static final String LIMAGE_SUIVANTE_NA_PU_ETRE_RECUPERER_ET_SERA_IGNOREE = Messages.getString((String)"ListScan.LIMAGE_SUIVANTE_NA_PU_ETRE_RECUPERER_ET_SERA_IGNOREE", (String[])new String[0]);
    private static final String ENCOUNTER = Messages.getString((String)"ENCOUNTER", (String[])new String[0]);
    private static final String SOMMAIRE = Messages.getString((String)"SOMMAIRE", (String[])new String[0]);
    private static final String ARCHIVE = Messages.getString((String)"ARCHIVE", (String[])new String[0]);
    private static final String SELECT_DOC = Messages.getString((String)"SELECT_DOC", (String[])new String[0]);
    private String outputFile;
    private String classMedicareNumber;
    private String nomDefaut;
    private Image imageTemp;
    private static String patLettre = "[\\]\\[\\(covwu|l148\u00c0A-Z]{4}";
    private static String patNumber = "[|IlrstzZSBoO0-9\\]\\[]";
    private static String patNumberX2 = String.valueOf(patNumber) + "{2}";
    private static String patNumber0156 = "[|IlrstSoO0156\\]\\[]";
    private static String patNumber0123 = "[|IlrtoO0-3\\]\\[]";
    private static Pattern patNamNoSpace = Pattern.compile("(" + patLettre + patNumberX2 + patNumber0156 + patNumber + patNumber0123 + patNumber + ")");
    private static Pattern patNamNb = Pattern.compile("([ ]" + patNumber + "{9}[ ])");
    private static Pattern patNAM = Pattern.compile("([ ]" + patLettre + patNumberX2 + patNumber0156 + patNumber + patNumber0123 + patNumber + ")|" + "([ ]" + patLettre + patNumberX2 + patNumber0156 + patNumber + patNumber0123 + ")|" + "([ ]" + patLettre + "[ ]" + patNumberX2 + patNumber0156 + patNumber + "[ ]" + patNumber0123 + patNumber + ")|" + "([ ]" + patLettre + "[ ]" + patNumberX2 + patNumber0156 + patNumber + "[ ]" + patNumber0123 + ")");
    private static String same3letters = "(.)\\1\\1";
    private static Pattern patSame3Letters = Pattern.compile(same3letters);
    private static final int fileTooHeavyLength = 0x500000;
    private static final int fileHeavy = 102400;
    public static Pattern patImage = Pattern.compile("([.]pdf)|([.]jpg)|([.]jpeg)|([.]png)|([.]gif)|([.]tif)|([.]tiff)|([.]bmp)");
    public static Pattern patTmpImage = Pattern.compile("([.]tmp[.]pdf)|([.]tmp[.]jpg)|([.]tmp[.]jpeg)|([.]tmp[.]png)|([.]tmp[.]gif)|([.]tmp[.]tif)|([.]tmp[.]tiff)|([.]tmp[.]bmp)");
    protected List<XBaseProfessionnal> lstAllProfessionnals;
    protected int idProcess = 0;

    @Override
    protected void deleteImage() {
        TableItem[] tableItemToDelete = this.tblListeItem.getSelection();
        ArrayList<String> lstToRemove = new ArrayList<String>();
        TableItem[] tableItemArray = tableItemToDelete;
        int n = tableItemToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem element = tableItemArray[n2];
            File curFile = ((Scan)element.getData()).file;
            String key = (String)element.getData("key");
            if (curFile.toURI().toString().toLowerCase().startsWith(this.getScannedFolder().toURI().toString().toLowerCase()) && curFile.exists()) {
                logger.fine("deleting file " + curFile);
                curFile.delete();
                lstToRemove.add(key);
                this.hshtblImage.remove(key);
                this.hshtblFile.remove(key);
            }
            ++n2;
        }
        int[] idxToRemove = new int[lstToRemove.size()];
        int i = 0;
        while (i < lstToRemove.size()) {
            int j = 0;
            while (j < this.tblListeItem.getItemCount()) {
                if (this.tblListeItem.getItem(j).getData("key").equals(lstToRemove.get(i))) {
                    idxToRemove[i] = j;
                }
                ++j;
            }
            ++i;
        }
        this.showFilebrowser.setHtml("<meta charset=\"UTF-8\"><h1>" + SELECT_DOC + "</h1>");
        if (idxToRemove.length > 0) {
            this.tblListeItem.remove(idxToRemove);
        }
        this.setInterfaceState(false);
    }

    @Override
    protected void refreshImage(String key) {
        block7: {
            System.out.println("ScanEditor.refreshImage() " + key);
            if (key == null) {
                return;
            }
            XPatientImage ximage = (XPatientImage)this.hshtblImage.get(key);
            Scan scan = (Scan)this.hshtblFile.get(key);
            try {
                MiscUtil.showTime((String)"1");
                scan.file.getPath();
                this.setInterfaceState(true);
                if (scan.isPdf()) {
                    MiscUtil.showTime((String)"is pdf");
                    long size = Math.round((double)scan.file.length() / 1024.0);
                    this.lblTaille.setText(String.valueOf(TAILLE) + size + " kb");
                    byte[] picture = this.getPictureForPatientImageRethrow(scan.file);
                    this.showImageOrPdf(key, picture);
                    this.refreshPPPAndLuminosityAndDepth(false);
                    MiscUtil.showTime((String)"show pdf");
                    break block7;
                }
                this.startJob();
                Image image = ScanEditor.readImage(scan.file);
                try {
                    Image image2 = this.computeImageTranformation(image, this.depth, this.ppp, this.luminosity, scan.rotation);
                    byte[] picture = this.getImageAsByteArray(image2);
                    this.lblTaille.setText(String.valueOf(TAILLE) + picture.length / 1000 + "kb");
                    this.showImageOrPdf(key, picture);
                    ximage.setPicture(picture);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Erreur image transformatoin", (String)e.getMessage());
                }
                this.endJob();
                this.refreshPPPAndLuminosityAndDepth(true);
            }
            catch (BusinessException e) {
                this.showFilebrowser.setHtml(HtmlBrowserTools.newErrorTemplateResource((Exception)((Object)e), null));
            }
            catch (Exception e) {
                HtmlResource htmlResource = HtmlBrowserTools.newErrorTemplateResource((String)(String.valueOf(LE_FICHIER_CHOISI_NEST_PAS_UNE_IMAGE_OU_CE_DERNIER_EST_CORROMPU) + "<br><br>" + e.getMessage()), null);
                this.showFilebrowser.setHtml(htmlResource);
            }
        }
    }

    public static boolean isPdf(byte[] picture) {
        byte[] p = new byte[4];
        int i = 0;
        while (i < 4 && i < picture.length) {
            p[i] = picture[i];
            ++i;
        }
        String pdf = new String(p);
        return pdf.startsWith("%PDF");
    }

    private void showImageOrPdf(String hId, byte[] picture) {
        block13: {
            hId = ca.infodata.util1.StringUtils.removeAccent((String)StringUtils.deleteWhitespace((String)hId)).replaceAll("[^a-zA-Z0-9]", "");
            HtmlImageViewerResource htmlResource = null;
            try {
                try {
                    String nam = null;
                    if (ScanEditor.isPdf(picture)) {
                        nam = this.parseNamFromPdf(picture, nam);
                        boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
                        if (LibPlugin.ON_WIN) {
                            recentViewer = false;
                        }
                        htmlResource = HtmlBrowserTools.newHtmlPdfViewerResource((String)hId, null, (byte[])picture, (boolean)true, (boolean)recentViewer);
                    } else {
                        try {
                            if (!ImageUtil.isGif((byte[])picture) && !ImageUtil.isPng((byte[])picture) && ImageUtil.isTiff((byte[])picture)) {
                                // empty if block
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Unable to check for the image " + hId, e);
                        }
                        htmlResource = HtmlBrowserTools.newHtmlImageViewerResource((String)hId, null, (byte[])picture);
                    }
                    this.txtPatient.getBtnRemove().notifyListeners(13, new Event());
                    if (nam != null) {
                        this.txtPatient.getMyText().setText(nam);
                        this.txtPatient.getMyText().setToolTipText(Messages.getString((String)"PT_FOUND_TTT", (String[])new String[0]));
                        this.txtPatient.getMyText().setBackground(this.txtPatientGreenBackgroundColor);
                        this.txtPatient.doSearch();
                    } else {
                        this.txtPatient.getMyText().setToolTipText(Messages.getString((String)"PT_NOT_FOUND_TTT", (String[])new String[0]));
                        this.txtPatient.getMyText().setBackground(this.txtPatientRedBackgroundColor);
                    }
                }
                catch (Exception e) {
                    htmlResource = HtmlBrowserTools.newErrorTemplateResource((String)(String.valueOf(LE_FICHIER_CHOISI_NEST_PAS_UNE_IMAGE_OU_CE_DERNIER_EST_CORROMPU) + "<br><br>" + e.getClass().getName() + "<br>" + e.getMessage()), null);
                    this.showFilebrowser.setHtml((HtmlResource)htmlResource);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.showFilebrowser.setHtml(htmlResource);
                throw throwable;
            }
            this.showFilebrowser.setHtml((HtmlResource)htmlResource);
        }
    }

    private String parseNamFromPdf(byte[] picture, String nam) {
        String text = null;
        try {
            Object extractor;
            Pattern pattern;
            block34: {
                pattern = patNAM;
                PdfReader pdfReader = null;
                try {
                    try {
                        pdfReader = new PdfReader(picture);
                        extractor = new PdfTextExtractor(pdfReader);
                        text = extractor.getTextFromPage(1);
                    }
                    catch (Exception exception) {
                        text = null;
                        try {
                            if (pdfReader != null) {
                                pdfReader.close();
                            }
                            break block34;
                        }
                        catch (Exception exception2) {}
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (pdfReader != null) {
                            pdfReader.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (pdfReader != null) {
                        pdfReader.close();
                    }
                }
                catch (Exception exception) {}
            }
            if (StringUtils.isEmpty(text)) {
                try {
                    extractor = null;
                    Object var7_10 = null;
                    try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(picture));){
                        MyPDFTextStripper pdfTextStripper = new MyPDFTextStripper();
                        pdfTextStripper.setStartPage(1);
                        pdfTextStripper.setEndPage(1);
                        StringWriter writer = new StringWriter();
                        pdfTextStripper.writeText(document, writer);
                        text = writer.toString();
                    }
                    catch (Throwable throwable) {
                        if (extractor == null) {
                            extractor = throwable;
                        } else if (extractor != throwable) {
                            ((Throwable)extractor).addSuppressed(throwable);
                        }
                        throw extractor;
                    }
                }
                catch (Exception exception) {
                    text = null;
                }
            }
            if (StringUtils.isNotEmpty(text)) {
                Matcher m = pattern.matcher(text = text.replaceAll("[:]", " ").replaceAll("[,/.':]", "").replaceAll("[\n]", " ").replaceAll("[ ]{2,}", " "));
                boolean findIt = m.find();
                if (!findIt) {
                    m = patNamNoSpace.matcher(text.replaceAll("[ ]", ""));
                    findIt = m.find();
                }
                String newNam = null;
                while (findIt && nam == null) {
                    newNam = m.group(0);
                    if (newNam != null) {
                        newNam = newNam.replaceAll(" ", "");
                        String letters = newNam.substring(0, 4);
                        Matcher match = patSame3Letters.matcher(letters = letters.replaceAll("[|1l\\[\\[]", "I").replace('(', 'U').replace('c', 'C').replace('o', 'O').replace('v', 'V').replace('w', 'W').replace('u', 'U').replace('4', 'A').replace('8', 'B').replace('\u00c0', 'A'));
                        if (!match.find()) {
                            String numbers = newNam.substring(4, newNam.length());
                            if (!((numbers = numbers.replace('o', '0').replace('O', '0').replace('r', '1').replaceAll("[sS]", "5").replace('B', '8').replaceAll("[zZ]", "7").replaceAll("[tI||l\\[\\[]", "1")).substring(2, 4).equals("00") || numbers.length() > 5 && numbers.substring(4, 6).equals("00"))) {
                                nam = String.valueOf(letters) + numbers;
                            }
                        }
                    }
                    findIt = m.find();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to parse nam from pdf file. raw_text\n\n" + text, e);
        }
        return nam;
    }

    private byte[] getImageAsByteArray(Image image) {
        if (image == null) {
            return null;
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)outputStream, 4);
        return outputStream.toByteArray();
    }

    private void refreshPPPAndLuminosityAndDepth(boolean enabled) {
        this.grpBits.setEnabled(enabled);
        this.luminositySlider.setEnabled(enabled && this.depth != 0);
        this.cboPpp.setEnabled(enabled);
    }

    private boolean assignBuildedImages(final IProgressMonitorWithLog monitor, List<XPatientImage> images) {
        DefaultStatusHandler statusHandler = new DefaultStatusHandler(){

            protected void handleBaseStatuses(IStatus status, EnumSet<IStatusHandler.State> state) {
                if (!state.contains(IStatusHandler.State.HANDLED)) {
                    state.add(IStatusHandler.State.HANDLED);
                    if (!status.isOkToProceed()) {
                        monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde... " + status.getMessage());
                    }
                }
            }
        };
        monitor.log(Level.INFO, "Sauvegarde...");
        boolean saved = false;
        if (images.isEmpty()) {
            return true;
        }
        XPatientImageContainer container = new XPatientImageContainer(images);
        try {
            boolean valid = true;
            for (XPatientImage image : images) {
                if (!(valid = ScanEditor.validPatientImageBeforeSave(monitor, valid, image))) break;
            }
            if (valid) {
                XSession session = Application.get().getGlobalInstances().getSession();
                PatientImageAccessorClient accessor = PatientImageAccessorClient.getInstance();
                ReturnObject response = accessor.saveSync(((Object)((Object)this)).hashCode(), session, (Serializable)container, true);
                if (response == null) {
                    saved = false;
                    monitor.log(Level.SEVERE, MessageUtil.UNEXPECTED_ERROR_MESSAGE);
                } else {
                    IStatus status = response.getStatus().getStatus("PATIENT_IMAGE_25K");
                    if (status != null) {
                        if (MessageUtil.show((IStatus)status) == IStatusHandler.State.HANDLED_POSITIVE) {
                            response = accessor.saveSync(((Object)((Object)this)).hashCode(), session, (Serializable)container, false);
                            saved = response.getStatus().isOkToProceed();
                            statusHandler.handle((IStatus)response.getStatus());
                        } else {
                            monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde... L'utilisateur a annul\u00e9");
                            saved = false;
                        }
                    } else {
                        saved = response.getStatus().isOkToProceed();
                        statusHandler.handle((IStatus)response.getStatus());
                    }
                }
            }
        }
        catch (CannotConnectToServerException e) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde...", (Throwable)e);
        }
        catch (Exception e) {
            saved = false;
            logger.log(Level.SEVERE, "Error saving XPatientImage " + ca.infodata.util1.StringUtils.safeToString((Logger)logger, images), e);
            monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde...", (Throwable)e);
        }
        if (saved) {
            monitor.log(Level.INFO, "Sauvegarde r\u00e9ussie !");
        }
        return saved;
    }

    public static boolean validPatientImageBeforeSave(IProgressMonitorWithLog monitor, boolean valid, XPatientImage image) {
        if (!ScanEditor.isPdfOrImage(image.getPicture())) {
            valid = false;
            if (monitor != null) {
                monitor.log(Level.SEVERE, "Le fichier est vide ou le format n'est pas support\u00e9");
                monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde...");
            }
        } else if (ScanEditor.isFileTooHeavy(image.getPicture())) {
            valid = false;
            if (monitor != null) {
                monitor.log(Level.SEVERE, "Le fichier est trop lourd ( > 5mb) ");
                monitor.log(Level.SEVERE, "\u00c9chec de Sauvegarde...");
            }
        } else if (!ScanEditor.validQuestion(image).isOK()) {
            valid = false;
            if (monitor != null) {
                monitor.log(Level.WARNING, "Le fichier <<" + image.getName() + ">> est lourd ( > 100kb) ");
                monitor.log(Level.WARNING, "Annulation de la sauvegarde...");
            }
        }
        return valid;
    }

    public static IStatus validQuestion(XPatientImage image) {
        if (image.getId() == null && image.getPicture() != null && image.getPicture().length > 102400) {
            String message = MessageFormat.format(Messages.getString((String)"ATTENTION_LIMAGE_{0}_PESE_PLUS_DE_{1}_K", (String[])new String[0]), image.getName(), image.getPicture().length / 1024);
            Status status = new Status("PATIENT_IMAGE_25K", IStatus.Severity.NEED_MORE_INFO, message, null, null);
            if (MessageUtil.show((IStatus)status) == IStatusHandler.State.HANDLED_POSITIVE) {
                return Status.OK_STATUS;
            }
            return Status.UNSUPPORTED_OPERATION_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static boolean isFileTooHeavy(byte[] picture) {
        return picture.length > 0x500000;
    }

    private static void checkFileTooHeavy(File file) throws BusinessException {
        if (file.length() > 0x500000L) {
            long size = Math.round((double)file.length() / 1024.0);
            throw new BusinessException("Le fichier est trop volumineux. La taille du fichier est de " + size + " kb. La taille maximale accept\u00e9e est de 5120 kb (soit 5 mb). ");
        }
    }

    public void buildImages(BuildData buildData, List<XPatientImage> ximages) throws Exception {
        for (XPatientImage ximage : ximages) {
            File file = this.getFileForImage(ximage);
            this.buildImage(buildData, ximage, file);
        }
    }

    public void buildImage(BuildData buildData, XPatientImage ximage, File file) throws Exception {
        boolean isSeenByMd;
        String selectedImageName;
        if (ximage.getPatient() == null) {
            ximage.setPatient(buildData.selectedPatient);
        }
        if (!this.isAssigningImageByReadinCodeBar) {
            LinkedHashMap<Integer, XPatientImageProfessionnal> profMapPip = new LinkedHashMap<Integer, XPatientImageProfessionnal>();
            List<ProfItem> profItems = buildData.selectedProfs;
            for (ProfItem profItem : profItems) {
                profMapPip.put(profItem.imageProfessionnal.professionnal, profItem.imageProfessionnal);
            }
            if (ximage.getProfessionnals() != null) {
                for (XPatientImageProfessionnal pip : ximage.getProfessionnals()) {
                    if (profMapPip.containsKey(pip.professionnal)) continue;
                    profMapPip.put(pip.professionnal, pip);
                }
            }
            EditableDataObjectList professionnals = new EditableDataObjectList();
            professionnals.addAll(profMapPip.values());
            ximage.setProfessionnals((IEditableDataObjectList)professionnals);
        }
        if (ximage.getProfessionnals().isEmpty()) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Le fichier \u00ab" + file.getName() + "\u00bb doit \u00eatre destin\u00e9 \u00e0 au moins 1 professionnel."));
        }
        HashSet<XLabelDef> labels = new HashSet<XLabelDef>();
        labels.addAll(buildData.selectedLabels);
        if (ximage.getLabels() != null) {
            labels.addAll(ximage.getLabels());
        }
        ximage.setLabels(new ArrayList(labels));
        XLabelDef encounterLabelDef = PreferencesPlugin.getDefault().getLabel(new Integer(XLabelDef.ENCOUNTER));
        XLabelDef summaryLabelDef = PreferencesPlugin.getDefault().getLabel(new Integer(XLabelDef.SOMMAIRE));
        boolean isEncounter = labels.contains(encounterLabelDef);
        boolean isSummary = labels.contains(summaryLabelDef);
        if (!this.isAssigningImageByReadinCodeBar && isEncounter) {
            XBaseProfessionnal selectedEncounterProf = this.itemOfIsEncounterProf;
            if (selectedEncounterProf != null) {
                ximage.setEncounterProfessionnal(selectedEncounterProf);
            } else if (ximage.getEncounterProfessionnal() == null && ximage.getPatient() != null) {
                XBaseProfessionnal treatingProf = PersonUiPlugin.getDefault().getBaseProfessionnal(ximage.getPatient().getTreatingProfessionnal());
                if (treatingProf != null) {
                    ximage.setEncounterProfessionnal(treatingProf);
                } else if (buildData.onCallProfessionnal != null) {
                    ximage.setEncounterProfessionnal(buildData.onCallProfessionnal);
                } else if (ximage.getProfessionnals().size() > 0) {
                    XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(((XPatientImageProfessionnal)ximage.getProfessionnals().get(0)).getProfessionnal());
                    ximage.setEncounterProfessionnal(prof);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(selectedImageName = buildData.selectedImageName))) {
            ximage.setName(selectedImageName.trim());
        } else if (!StringUtils.isNotBlank((CharSequence)ximage.getName())) {
            if (isEncounter) {
                ximage.setName(String.valueOf(ENCOUNTER) + (ximage.getDocumentDate() == null ? "" : " (" + ximage.getDocumentDate().formatHyphen() + ")"));
            } else if (isSummary) {
                ximage.setName(SOMMAIRE);
            } else {
                boolean isArchive = labels.contains(PreferencesPlugin.getDefault().getLabel(new Integer(XLabelDef.ARCHIVE)));
                if (isArchive && StringUtils.isBlank((CharSequence)ximage.getName())) {
                    ximage.setName(ARCHIVE);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)ximage.getName())) {
            ximage.setName("-");
        }
        if (isSeenByMd = buildData.isSeenByMd) {
            for (XPatientImageProfessionnal xpip : ximage.getProfessionnals()) {
                xpip.removeXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.UNSEEN);
                xpip.addXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.SEEN);
            }
        } else {
            for (XPatientImageProfessionnal xpip : ximage.getProfessionnals()) {
                if (ximage.getEncounterProfessionnal() != null && xpip.getProfessionnal().equals(ximage.getEncounterProfessionnal().getId())) {
                    xpip.removeXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.UNSEEN);
                    xpip.addXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.SEEN);
                    continue;
                }
                xpip.removeXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.SEEN);
                xpip.addXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.UNSEEN);
            }
        }
        if (ximage.getDocumentDate() == null) {
            if (buildData.selectedDocumentDate != null) {
                ximage.setDocumentDate(buildData.selectedDocumentDate);
            } else {
                ximage.setDocumentDate(LocalDate.today());
            }
        }
        ximage.setResult(buildData.selectedResultType);
        ximage.doCreateTaskOnSave = buildData.isAutoCreateTask;
        ximage.scannedAsReceivedOrder = this.scannedAS == BaseScanEditor.SCANNED_AS.RECEIVED_ORDER;
        ximage.scannedAsSendOrder = this.scannedAS == BaseScanEditor.SCANNED_AS.SENT_ORDER;
        ximage.scannedAsResultToOrderId = this.scannedAS == BaseScanEditor.SCANNED_AS.ORDER_RESULT;
        ximage.orderId = this.itemOfIsOrderResponseObject == null ? null : this.itemOfIsOrderResponseObject.request.getId();
        Boolean bl = ximage.orderWasRejected = this.itemOfIsOrderResponseObject == null ? null : Boolean.valueOf(this.itemOfIsOrderResponseObject.wasRejected);
        if (ximage.getPicture() == null) {
            try {
                byte[] picture = this.getPictureForPatientImageRethrow(file);
                ximage.setPicture(picture);
            }
            catch (BusinessException e) {
                String key = this.getKeyForFile(file);
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, String.valueOf(e.getMessage()) + " " + key));
            }
            catch (Exception exception) {
                String key = this.getKeyForFile(file);
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, String.valueOf(LIMAGE_SUIVANTE_NA_PU_ETRE_RECUPERER_ET_SERA_IGNOREE) + " " + key));
            }
        }
    }

    @Override
    public void assignSelectedImages() {
        MyProgressMonitorDialogWithLog dialog2 = new MyProgressMonitorDialogWithLog(this.getSite().getShell());
        dialog2.setAutoCloseIfNoErrorOrWarning(true);
        try {
            List<XPatientImage> selectedPatientImages = this.getSelectedPatientImages();
            final LinkedHashMap<File, XPatientImage> map = new LinkedHashMap<File, XPatientImage>();
            for (XPatientImage x : selectedPatientImages) {
                File file = this.getFileForImage(x);
                map.put(file, x);
            }
            if (map.size() > 0) {
                this.isAssigningImage = true;
                dialog2.runWithLog(true, true, new IRunnableWithProgressWithLog(){

                    public void run(IProgressMonitorWithLog monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask("Assignation des fichiers", -1);
                                ScanEditor.this.intern_assignSelectedImages(monitor, map);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error", e);
                                monitor.log(Level.SEVERE, "Erreur", (Throwable)e);
                                if (monitor.isCanceled()) {
                                    monitor.log(Level.WARNING, "L'utilisateur a annul\u00e9");
                                }
                                monitor.log(Level.INFO, "Termin\u00e9");
                                monitor.done();
                                ScanEditor.this.isAssigningImage = false;
                            }
                        }
                        finally {
                            if (monitor.isCanceled()) {
                                monitor.log(Level.WARNING, "L'utilisateur a annul\u00e9");
                            }
                            monitor.log(Level.INFO, "Termin\u00e9");
                            monitor.done();
                            ScanEditor.this.isAssigningImage = false;
                        }
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            this.isAssigningImage = false;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error", ex);
            this.isAssigningImage = false;
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)ex);
        }
    }

    protected void intern_assignSelectedImages(IProgressMonitorWithLog monitor, Map<File, XPatientImage> selectedImages) {
        BuildData buildData = this.newBuildData();
        ArrayList<XPatientImage> list = new ArrayList<XPatientImage>();
        final ArrayList<File> savedFiles = new ArrayList<File>();
        for (Map.Entry<File, XPatientImage> entry : selectedImages.entrySet()) {
            XPatientImage ximage = entry.getValue();
            try {
                this.buildImage(buildData, ximage, entry.getKey());
                list.add(ximage);
                savedFiles.add(entry.getKey());
            }
            catch (StatusException e) {
                monitor.log(Level.SEVERE, e.getStatus().getMessage());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error building ximage " + ca.infodata.util1.StringUtils.safeToString((Logger)logger, (Object)ximage), e);
                monitor.log(Level.SEVERE, "Erreur", (Throwable)e);
            }
        }
        boolean saved = this.assignBuildedImages(monitor, list);
        if (saved) {
            monitor.log(Level.INFO, "Les fichiers sauvegard\u00e9s sont supprim\u00e9s");
            for (File file : savedFiles) {
                try {
                    boolean deleted;
                    if (!file.exists() || (deleted = file.delete())) continue;
                    monitor.log(Level.WARNING, "Le fichier " + file.getName() + "n'a pu \u00eatre supprim\u00e9");
                }
                catch (Exception exception) {
                    monitor.log(Level.WARNING, "Erreur lors de la suppression du fichier " + file.getName());
                }
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScanEditor.this.txtName.setText(null);
                    ScanEditor.this.clearPartiallyImageList(savedFiles);
                    ScanEditor.this.selectFirstImage();
                }
            });
        }
    }

    private static boolean isPdfOrImage(byte[] b) {
        return b != null && (ScanEditor.isSupportedPdf(b) || ScanEditor.isSupportedImage(b));
    }

    private static boolean isSupportedPdf(byte[] data) {
        boolean isTrue;
        block6: {
            isTrue = true;
            if (data != null && data.length >= 8) break block6;
            return false;
        }
        try {
            if (data[0] == 37 && data[1] == 80 && data[2] == 68 && data[3] == 70 && data[4] == 45 && data[5] == 49 && data[6] == 46) {
                int var = 0;
                while (var < 3) {
                    if (data[data.length - 7 + var] == 37 && data[data.length - 6 + var] == 37 && data[data.length - 5 + var] == 69 && data[data.length - 4 + var] == 79 && data[data.length - 3 + var] == 70) {
                        return isTrue;
                    }
                    ++var;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            PDFFile pdfFile = new PDFFile(byteBuffer);
            new OneDimensionalPdfDocument(pdfFile, (IProgressMonitor)new NullProgressMonitor());
            return isTrue;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isSupportedImage(byte[] b) {
        try {
            Display display = Display.getDefault();
            new Image((Device)display, (InputStream)new ByteArrayInputStream(b));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Image readImage(File file) throws IOException, BusinessException {
        ScanEditor.checkFileTooHeavy(file);
        return new Image((Device)Display.getDefault(), file.getPath());
    }

    private static PdfDocument readPdf(File file) throws IOException {
        try {
            byte[] b = ScanEditor.readFile(file);
            ByteBuffer byteBuffer = ByteBuffer.wrap(b);
            PDFFile pdfFile = new PDFFile(byteBuffer);
            OneDimensionalPdfDocument pdfDocument = new OneDimensionalPdfDocument(pdfFile, (IProgressMonitor)new NullProgressMonitor());
            return pdfDocument;
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to read pdf : " + file.getPath(), e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFile(File file) throws IOException {
        byte[] byArray;
        byte[] picture = null;
        InputStream is = null;
        try {
            long length = file.length();
            is = new FileInputStream(file);
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (true) {
                if (offset >= bytes.length || (numRead = is.read(bytes, offset, bytes.length - offset)) <= 0) {
                    if (offset >= bytes.length) break;
                    throw new IOException("Could not completely read file " + file.getName());
                }
                offset += numRead;
            }
            byArray = picture = bytes;
            if (is == null) return byArray;
        }
        catch (IOException e) {
            try {
                logger.log(Level.INFO, "Failed to read file : " + file.getPath(), e);
                throw e;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    private byte[] getPictureForPatientImage(File imgFile) {
        try {
            return this.getPictureForPatientImageRethrow(imgFile);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] getPictureForPatientImageRethrow(File imgFile) throws Exception {
        byte[] picture = null;
        InputStream is = null;
        try {
            try {
                ScanEditor.checkFileTooHeavy(imgFile);
                long length = imgFile.length();
                is = new FileInputStream(imgFile);
                byte[] bytes = new byte[(int)length];
                int offset = 0;
                int numRead = 0;
                while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) > 0) {
                    offset += numRead;
                }
                if (offset < bytes.length) {
                    throw new IOException(Messages.getString((String)"ScanEditor.IMPOSSIBLE_DE_LIRE_COMPLETEMENT_LE_FICHIER_{0}", (String[])new String[]{imgFile.getName()}));
                }
                picture = bytes;
            }
            catch (BusinessException e) {
                throw e;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "setPictureFromPdfFile: " + imgFile.getPath(), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return picture;
    }

    @Override
    protected void resetSectionInfo() {
        Map<ProfItem.AS, List<XPatientImageProfessionnal>> map;
        super.resetSectionInfo();
        XPatientImageProfessionnal e = this.getOnCallXPatientImageProfessionnal();
        if (e != null) {
            this.profControl.add(new ProfItem(e, ProfItem.AS.ON_CALL));
        }
        if ((map = this.getNewTreatingXPatientImageProfessionnal()).size() > 0) {
            for (Map.Entry<ProfItem.AS, List<XPatientImageProfessionnal>> entry : map.entrySet()) {
                for (XPatientImageProfessionnal xpp : entry.getValue()) {
                    this.profControl.add(new ProfItem(xpp, entry.getKey()));
                }
            }
        }
    }

    protected void deleteImages(List<File> lstFiles) {
        block0: for (File file : lstFiles) {
            TableItem[] items = this.tblListeItem.getItems();
            int i = 0;
            while (i < items.length) {
                File curFile = ((Scan)items[i].getData()).file;
                if (curFile.equals(file)) {
                    boolean b;
                    this.tblListeItem.remove(i);
                    if (!file.toURI().toString().startsWith(this.getScannedFolder().toURI().toString()) || (b = file.delete())) continue block0;
                    logger.log(Level.SEVERE, "DeleteImage - n'a pas supprim\u00e9 le fichier " + file.getPath(), new Exception());
                    continue block0;
                }
                ++i;
            }
        }
        this.showFilebrowser.setHtml("<h1>" + SELECT_DOC + "</h1>");
        this.setInterfaceState(false);
    }

    @Override
    protected void setInterfaceState(boolean isEnabled) {
        this.grpBits.setEnabled(isEnabled);
    }

    @Override
    protected void onImageRotated() {
    }

    @Override
    protected void fillImageList() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    File file = ScanEditor.this.getScannedFolder();
                    File pdfFile = new File(ScanEditor.this.getScannedFolder(), "pdf/");
                    File pdfErrFile = new File(ScanEditor.this.getScannedFolder(), "pdf/err/");
                    while (!ScanEditor.this.boolStopThread) {
                        if (ScanEditor.this.isAssigningImage) {
                            System.out.println("scanning paused --> reading codebar in progress");
                            Thread.sleep(5000L);
                            continue;
                        }
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        if (!pdfFile.exists()) {
                            pdfFile.mkdirs();
                        }
                        if (!pdfErrFile.exists()) {
                            pdfErrFile.mkdirs();
                        }
                        File[] scannedPdfFileList = pdfFile.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.toLowerCase().endsWith(".pdf");
                            }
                        });
                        ArrayList<File> lstPdfFiles = new ArrayList<File>();
                        File[] fileArray = scannedPdfFileList;
                        int n = scannedPdfFileList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File ff = fileArray[n2];
                            lstPdfFiles.add(ff);
                            ++n2;
                        }
                        if (lstPdfFiles.size() > 0) {
                            ScanEditor.this.addPdfFilesToList(lstPdfFiles);
                        }
                        File[] scanFile = file.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                String ext = name.toLowerCase();
                                boolean ok = patImage.matcher(ext).find() && !patTmpImage.matcher(ext).find();
                                return ok;
                            }
                        });
                        ArrayList<File> lstFiles = new ArrayList<File>();
                        File[] fileArray2 = scanFile;
                        int n3 = scanFile.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File ff = fileArray2[n4];
                            if (ff.isFile()) {
                                lstFiles.add(ff);
                            }
                            ++n4;
                        }
                        if (lstFiles.size() > 0) {
                            ScanEditor.this.addFilesToList(lstFiles);
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ScanEditor.this.chkAutoReadCodeBar.getSelection()) {
                                    ScanEditor.this.readCodeBar();
                                }
                            }
                        });
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, ERREUR, e);
                }
            }
        };
        threadExecutor.execute(run);
    }

    protected boolean waitEndingProcess(String[] processToExecute) {
        boolean commandOk = true;
        ++this.idProcess;
        try {
            Process process = Runtime.getRuntime().exec(processToExecute);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        int localIdProcess = ScanEditor.this.idProcess;
                        Thread.sleep(12000L);
                        if (localIdProcess == ScanEditor.this.idProcess) {
                            if (LibPlugin.ON_WIN) {
                                Process process2 = Runtime.getRuntime().exec(new String[]{String.valueOf(LibPlugin.OFYS_HOME) + "Process.exe", "-k", "tesseract.exe"});
                                System.out.println(process2);
                            } else if (LibPlugin.ON_LINUX) {
                                Runtime.getRuntime().exec(new String[]{"killall", "tesseract"});
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Erreur", e);
                    }
                }
            };
            threadExecutor.execute(run);
            process.waitFor();
            if (commandOk) {
                commandOk = process.exitValue() == 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            commandOk = false;
        }
        return commandOk;
    }

    @Override
    protected void addPdfFilesToList(List<File> lstPdfFiles) {
        for (File file : lstPdfFiles) {
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.info("to add pdf " + file);
        }
        Collections.sort(lstPdfFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.lastModified() < o2.lastModified() ? -1 : 1;
            }
        });
        if (lstPdfFiles.size() > 0) {
            for (File element : lstPdfFiles) {
                block18: {
                    PDDocument document = null;
                    try {
                        try {
                            document = PDDocument.load((File)element);
                            PDFRenderer pdfRenderer = new PDFRenderer(document);
                            int pageCounter = 0;
                            Iterator iterator = document.getPages().iterator();
                            while (iterator.hasNext()) {
                                PDPage cfr_ignored_0 = (PDPage)iterator.next();
                                BufferedImage bim = pdfRenderer.renderImageWithDPI(pageCounter, (float)this.ppp, ImageType.RGB);
                                ImageIOUtil.writeImage((BufferedImage)bim, (String)(String.valueOf(LibPlugin.OFYS_HOME) + "scanned/" + element.getName().toLowerCase().replace(".pdf", "") + "-" + "P" + pageCounter++ + ".png"), (int)300);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, ERREUR, e);
                            FileUtil.renameFile((File)element, (File)new File(String.valueOf(LibPlugin.OFYS_HOME) + "scanned/pdf/err/" + element.getName().toLowerCase()));
                            if (document != null) {
                                try {
                                    document.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (document != null) {
                            try {
                                document.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                System.out.println("element:" + element);
                element.delete();
            }
        }
    }

    @Override
    protected void addFilesToList(List<File> lstFiles) {
        Collections.sort(lstFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.lastModified() < o2.lastModified() ? -1 : (o1.lastModified() > o2.lastModified() ? 1 : 0);
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ScanEditor.this.cboPpp.getControl().isDisposed()) {
                    ScanEditor.this.ppp = (Integer)ScanEditor.this.cboPpp.getSelection();
                }
            }
        });
        final HashSet<String> setFileToRemove = new HashSet<String>();
        Set files = this.hshtblFile.entrySet();
        for (Map.Entry e : files) {
            boolean foundIt = false;
            for (File fileForRun : lstFiles) {
                if (!((String)e.getKey()).equals(this.getKeyForFile(fileForRun))) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            setFileToRemove.add((String)e.getKey());
        }
        if (setFileToRemove.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Integer> lstItemsToRemove = new ArrayList<Integer>();
                    for (String fileToRemove : setFileToRemove) {
                        ScanEditor.this.hshtblImage.remove(fileToRemove);
                        ScanEditor.this.hshtblFile.remove(fileToRemove);
                        int i = 0;
                        while (i < ScanEditor.this.tblListeItem.getItemCount()) {
                            TableItem item = ScanEditor.this.tblListeItem.getItem(i);
                            if (fileToRemove.equals(item.getData("key"))) {
                                lstItemsToRemove.add(new Integer(i));
                            }
                            ++i;
                        }
                    }
                    if (lstItemsToRemove.size() > 0) {
                        int[] itemToRemove = new int[lstItemsToRemove.size()];
                        int i = 0;
                        while (i < lstItemsToRemove.size()) {
                            itemToRemove[i] = (Integer)lstItemsToRemove.get(i);
                            ++i;
                        }
                        ScanEditor.this.tblListeItem.remove(itemToRemove);
                    }
                }
            });
        }
        for (File fileForRun : lstFiles) {
            String fileName = fileForRun.getName().toLowerCase();
            if (fileName.indexOf(".png") > -1 || fileName.indexOf(".tif") > -1 || fileName.indexOf(".tiff") > -1 || fileName.indexOf(".jpg") > -1 || fileName.indexOf(".jpeg") > -1 || fileName.indexOf(".gif") > -1 || fileName.indexOf(".bmp") > -1 || fileName.toLowerCase().endsWith(".pdf")) {
                logger.fine("file " + fileName + " is supported. Supported file types are (.png, .jpg, .jpeg, .gif, .bmp, .pdf)");
                final String key = this.getKeyForFile(fileForRun);
                final String txt = this.getTextForFile(fileForRun);
                if (this.hshtblImage.containsKey(key)) {
                    logger.fine("file with key " + key + " already in list");
                    continue;
                }
                XPatientImage patientImage = new XPatientImage();
                this.hshtblImage.put(key, patientImage);
                final Scan scan = new Scan(fileForRun);
                this.hshtblFile.put(key, scan);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ScanEditor.this.tblListeItem.isDisposed()) {
                            TableItem item = new TableItem(ScanEditor.this.tblListeItem, 0);
                            item.setText(txt);
                            item.setData((Object)scan);
                            item.setData("key", (Object)key);
                        }
                    }
                });
                continue;
            }
            logger.info("file " + fileName + "not supported. Supported file types are (.png, .jpg, .jpeg, .gif, .bmp, .pdf)");
        }
    }

    @Override
    protected XPatientImage getPatientImage(TableItem item) {
        if (item == null) {
            return null;
        }
        Object key = item.getData("key");
        return (XPatientImage)this.hshtblImage.get(key);
    }

    private String getKeyForFile(File file) {
        String key = file.getName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("file key is " + key);
        }
        return key;
    }

    private String getTextForFile(File file) {
        String key = String.valueOf(file.getName()) + " (" + (double)Math.round((double)file.length() / 1024.0 * 10.0) / 10.0 + "Kb)";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("file key is " + key);
        }
        return key;
    }

    @Override
    protected void readCodeBar() {
        MyProgressMonitorDialogWithLog dialog2 = new MyProgressMonitorDialogWithLog(this.getSite().getShell());
        dialog2.setAutoCloseIfNoErrorOrWarning(false);
        try {
            this.isAssigningImage = true;
            this.isAssigningImageByReadinCodeBar = true;
            if (new CodeReader(this.getScannedFolder()).peekNbProcessableFileCount() > 0) {
                dialog2.runWithLog(true, true, new IRunnableWithProgressWithLog(){

                    public void run(IProgressMonitorWithLog monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask("Assignation automatique des documents par reconnaissance du code \u00e0 barres", -1);
                                ScanEditor.this.intern_readBarCodes(monitor);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error", e);
                                monitor.log(Level.SEVERE, "Erreur", (Throwable)e);
                                if (monitor.isCanceled()) {
                                    monitor.log(Level.WARNING, "L'utilisateur a annul\u00e9");
                                }
                                monitor.log(Level.INFO, "Termin\u00e9");
                                monitor.done();
                                ScanEditor.this.isAssigningImage = false;
                                ScanEditor.this.isAssigningImageByReadinCodeBar = false;
                            }
                        }
                        finally {
                            if (monitor.isCanceled()) {
                                monitor.log(Level.WARNING, "L'utilisateur a annul\u00e9");
                            }
                            monitor.log(Level.INFO, "Termin\u00e9");
                            monitor.done();
                            ScanEditor.this.isAssigningImage = false;
                            ScanEditor.this.isAssigningImageByReadinCodeBar = false;
                        }
                    }
                });
            } else {
                this.isAssigningImage = false;
                this.isAssigningImageByReadinCodeBar = false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.isAssigningImage = false;
            this.isAssigningImageByReadinCodeBar = false;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error", ex);
            this.isAssigningImage = false;
            this.isAssigningImageByReadinCodeBar = false;
        }
    }

    protected void intern_readBarCodes(IProgressMonitorWithLog monitor) {
        monitor.log(Level.INFO, "Lecture...");
        CodeReader scanController = new CodeReader(this.getScannedFolder());
        scanController.readCode(monitor);
        if (monitor.isCanceled()) {
            return;
        }
        List<File> failedFiles = scanController.getFailedFiles();
        String s = failedFiles.size() > 1 ? "s" : "";
        monitor.log(Level.WARNING, String.valueOf(failedFiles.size()) + String.format(" fichier%s non-class\u00e9%s", s, s));
        Map<File, XPatientImage> toSaveFiles = scanController.getXPatientImages();
        s = toSaveFiles.size() > 1 ? "s" : "";
        monitor.log(Level.INFO, String.valueOf(toSaveFiles.size()) + String.format(" fichier%s class\u00e9%s", s, s));
        ArrayList<XPatientImage> savedPatientImages = new ArrayList<XPatientImage>();
        ArrayList<File> savedFiles = new ArrayList<File>();
        if (toSaveFiles.size() > 0) {
            monitor.log(Level.INFO, "Pr\u00e9traitement...");
            for (Map.Entry<File, XPatientImage> e : toSaveFiles.entrySet()) {
                XPatientImage ximage = e.getValue();
                try {
                    BuildData buildData = this.newBuildData();
                    this.buildImage(buildData, ximage, e.getKey());
                    savedFiles.add(e.getKey());
                    savedPatientImages.add(ximage);
                }
                catch (StatusException e2) {
                    monitor.log(Level.WARNING, e2.getStatus().getMessage());
                }
                catch (Exception e2) {
                    String message = "Error building ximage " + ca.infodata.util1.StringUtils.safeToString((Logger)logger, (Object)ximage);
                    logger.log(Level.SEVERE, message, e2);
                    String key = this.getKeyForFile(e.getKey());
                    monitor.log(Level.SEVERE, "Erreur " + key, (Throwable)e2);
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            boolean saved = this.assignBuildedImages(monitor, savedPatientImages);
            if (saved) {
                monitor.log(Level.INFO, "Les fichiers non-class\u00e9s sont renomm\u00e9s avec le pr\u00e9fix NC_");
                for (File file : failedFiles) {
                    File newFile = new File(file.getParent(), "NC_" + file.getName());
                    FileUtil.renameFile((File)file, (File)newFile);
                }
                monitor.log(Level.INFO, "Les fichiers sauvegard\u00e9s sont supprim\u00e9s");
                for (File file : savedFiles) {
                    FileUtil.deleteFile((File)file);
                }
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScanEditor.this.clearImageList();
                        ScanEditor.this.txtName.setText(null);
                    }
                });
            }
        }
    }

    private BuildData newBuildData() {
        final BuildData[] data = new BuildData[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                data[0] = new BuildData();
                data[0].isAutoCreateTask = ScanEditor.this.chkAutoCreateTask.getSelection();
                data[0].isSeenByMd = ScanEditor.this.btnSeenStatus.getSelection();
                data[0].onCallProfessionnal = ScanEditor.this.getOnCallProfessionnal();
                data[0].selectedDocumentDate = ScanEditor.this.getSelectedDocumentDate();
                data[0].selectedImageName = ScanEditor.this.getSelectedImageName();
                data[0].selectedLabels = ScanEditor.this.getSelectedLabels();
                data[0].selectedPatient = ScanEditor.this.getSelectedPatient();
                data[0].selectedProfs = ScanEditor.this.profControl.getItems();
                data[0].selectedResultType = ScanEditor.this.getSelectedResultType();
            }
        });
        return data[0];
    }

    @Override
    protected void runOCR(boolean humanOCR) {
    }

    public void showDataObject() {
    }

    public XPatientImageContainer getPatientImageContainer() {
        IEditorInput input = this.getEditorInput();
        return (XPatientImageContainer)(input == null ? null : ((EditorInput)input).getDataObject());
    }

    public void initDataOverride() {
        this.initializeCompleteDataObject((EditableDataObject)new XPatientImageContainer());
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PatientImageAccessorClient.getInstance();
    }

    public boolean isDataDirty() {
        return false;
    }

    public void setToolBarStatus() {
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/print-icon32.png");
    }

    public String getEditorTitle() {
        return NUMERISER_DES_DOCUMENTS;
    }

    public IPatient getPatient() {
        return this.getSelectedPatient();
    }

    public MessageLink getMessageLink() {
        return null;
    }

    protected static class BuildData {
        IPatient selectedPatient;
        List<ProfItem> selectedProfs;
        List<XLabelDef> selectedLabels;
        String selectedImageName;
        XBaseProfessionnal onCallProfessionnal;
        LocalDate selectedDocumentDate;
        XPatientImageResultType selectedResultType;
        boolean isSeenByMd;
        boolean isAutoCreateTask;

        protected BuildData() {
        }
    }

    protected static class MyPDFTextStripper
    extends PDFTextStripper {
        public MyPDFTextStripper() throws IOException {
            this.addOperator((OperatorProcessor)new SetStrokingColorSpace());
            this.addOperator((OperatorProcessor)new SetNonStrokingColorSpace());
            this.addOperator((OperatorProcessor)new SetStrokingDeviceCMYKColor());
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceCMYKColor());
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceRGBColor());
            this.addOperator((OperatorProcessor)new SetStrokingDeviceRGBColor());
            this.addOperator((OperatorProcessor)new SetNonStrokingDeviceGrayColor());
            this.addOperator((OperatorProcessor)new SetStrokingDeviceGrayColor());
            this.addOperator((OperatorProcessor)new SetStrokingColor());
            this.addOperator((OperatorProcessor)new SetStrokingColorN());
            this.addOperator((OperatorProcessor)new SetNonStrokingColor());
            this.addOperator((OperatorProcessor)new SetNonStrokingColorN());
        }
    }
}

