/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.PatientImageAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageContainer;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageNumberContainer;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsPastille;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.treeelements.CallbackElement;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.scan.menu.PatientImageElements;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class ListScanned
extends CallbackElement
implements ITreeElements,
ITreeElementsPastille,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListScanned.class.getName());
    protected static final String A_VOIR = Messages.getString((String)"ListScannedToSeen.A_VOIR", (String[])new String[0]);
    protected static final String A_REGLER = Messages.getString((String)"ListResultatsToResolve.A_REGLER", (String[])new String[0]);
    protected static final String _a_REGLER = Messages.getString((String)"ListResultatsToSeen._a_REGLER", (String[])new String[0]);
    protected static final String TO_SEE = Messages.getString((String)"ListScaned.TO_SEE", (String[])new String[0]);
    protected static final String DOCUMENT_SCAN = Messages.getString((String)"ListScaned.DOCUMENT_SCAN", (String[])new String[0]);
    protected static final String DOCUMENTS_NUMERISES_A_VOIR = Messages.getString((String)"ListScannedToSeen.DOCUMENTS_NUMERISES_A_VOIR", (String[])new String[0]);
    protected static final String _RESULTATS_SO = Messages.getString((String)"ListScannedToSeen._RESULTATS_SO", (String[])new String[0]);
    protected static final String _RESULTATS_NORMAUX = Messages.getString((String)"ListScannedToSeen._RESULTATS_NORMAUX", (String[])new String[0]);
    protected static final String _RESULTATS_ANORMAUX = Messages.getString((String)"ListScannedToSeen._RESULTATS_ANORMAUX", (String[])new String[0]);
    protected static final String _RESULTATS_TRES_ANORMAUX = Messages.getString((String)"ListScannedToSeen._RESULTATS_TRES_ANORMAUX", (String[])new String[0]);
    protected static final String IMPRIMER_LA_LISTE = Messages.getString((String)"ListScannedToSeen.IMPRIMER_LA_LISTE", (String[])new String[0]);
    protected static final String VOIR_PLUS = Messages.getString((String)"ListScannedToSeen.VOIR_PLUS", (String[])new String[0]);
    protected XScanImageNumberContainer countContainer;
    protected XScanImageContainer listContainer;

    public ListScanned(ITreeElements parent) {
        super(parent);
    }

    public void loadCountAsync() {
        try {
            PatientImageAccessorClient.getInstance().getNumber(this.hashCode(), Application.get().getGlobalInstances().getSession(), this.countContainer, this.getCallback(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get scan count for " + this.countContainer, e);
            this.loadResponse(0, null);
        }
    }

    public void loadListAsync() {
        ArrayList<LoadingElement> list = new ArrayList<LoadingElement>(this.getChilds());
        this.removeLoadingElements(list);
        list.add(new LoadingElement((ITreeElements)this));
        this.setChilds(list);
        PersonUiPlugin.getDefault().setTimeItemInPatientClicked(System.currentTimeMillis());
        try {
            XScanImageContainer container = this.listContainer.cloneWithoutObject();
            PatientImageAccessorClient.getInstance().findBasePatientImage(this.hashCode(), Application.get().getGlobalInstances().getSession(), this.getCallback(1), container);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get scan list for " + this.listContainer, e);
            this.loadResponse(1, null);
        }
    }

    public void loadListResponse(Object response) {
        XScanImageContainer container = (XScanImageContainer)response;
        this.setChilds(this.getElementsFromListResponse(container));
    }

    protected List<ITreeElements> getElementsFromListResponse(XScanImageContainer container) {
        ArrayList<ITreeElements> listChild = new ArrayList<ITreeElements>(this.getChilds());
        this.removeLoadingElements(listChild);
        if (container != null) {
            boolean showPatientName = container.getPatient() == null;
            XBasePatientImage[] xBasePatientImageArray = container.getBaseImages();
            int n = xBasePatientImageArray.length;
            int n2 = 0;
            while (n2 < n) {
                XBasePatientImage image = xBasePatientImageArray[n2];
                PatientImageElements e = new PatientImageElements(this, image);
                e.setShowPatientName(showPatientName);
                listChild.add((ITreeElements)e);
                ++n2;
            }
        }
        return listChild;
    }

    public boolean hasChildren() {
        return true;
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/print-icon16.png");
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().getName().hashCode();
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        return result;
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListScanned && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public Color getPastilleColor() {
        return ResourceGetter.getColor((RGB)ResourceGetter.GREEN_WARNING_COLOR);
    }
}

