/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBilledRessourcePaid;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XModePaiement;
import ca.infodata.ofys.data.middle.dataobjects.service.XResponsablePmt;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.appointment.editor.recall.XPatientRecallFormatter;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.search.PatientSearchComposite;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchComposite;
import ca.infodata.ofys.ui.ressource.BilledRessourcePaidControl;
import ca.infodata.ofys.ui.ressource.FakeEditor;
import ca.infodata.ofys.ui.ressource.editor.BillingEditionControl;
import ca.infodata.ofys.ui.ressource.editor.BillingRessourceController;
import ca.infodata.ofys.ui.ressource.search.RessourceDefDataSearchComposite;
import ca.infodata.ofys.ui.site.ContextSiteProvider;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.ProviderR;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BillingRessourceWindow
implements IRefreshFont,
BillingRessourceController.IBillingRessourceControllerListener {
    private static final Logger logger = Logger.getLogger(BillingRessourceWindow.class.getName());
    private boolean useOneStepBilling = true;
    private FakeEditor fakeEditor;
    private final BillingEditionControl billingEditionControl;
    private final FontAwareShell window;
    private PatientSearchComposite patientSearchComposite;
    private ProfessionnalSearchComposite professionnalSearchComposite;
    private RessourceDefDataSearchComposite ressourceDefDataSearchComposite;
    private boolean isDisposed;
    private TabFolder searchFolder;
    private MyButton btnSave;
    private MyButton btnBill;
    private MyButton btnBillAndPay;
    private MyButton btnCancel;
    private MyButton btnPaySelected;
    private MyButton btnPayAll;
    private MyCombo<XModePaiement> cmbModePmt;
    private BillingRessourceController controller;
    private SwtRefreshRunnable swtRefreshRunnable;
    private Control[] controls = new Control[1];
    private Listener keyDownListener;
    private TabItem tabSearchPatient;
    private TabItem tabSearchProfessionnal;
    private TabItem tabSearchRessourceDefData;
    private Composite billedRessourceSection;
    private Composite rightSection;
    private FontAwareTable tblPatientRecalls;
    private FontAwareTable tblPastAppointments;
    private FontAwareTable tblFutureAppointments;
    private List<XPatientRecall> recalls = new ArrayList<XPatientRecall>();
    private ProviderAR<XPatientRecall, String> recallLabelProvider;
    private boolean patientRecallsNeverFilled;
    private boolean futureAppointmentsNeverFilled;
    private boolean pastAppointmentsNeverFilled;
    private boolean billedRessourcesNeverFilled;
    private Control oldFocusedControl;
    private MyList<XBilledRessource> listBilledRessource;
    private BilledRessourcePaidControl billedRessourcePaidControl;
    private FontAwareComposite buttonComp;

    public BillingRessourceWindow(Shell parent, FormToolkit toolkit, BillingRessourceController controller) {
        if (toolkit == null) {
            toolkit = UI.createToolKit((Widget)parent);
        }
        this.controller = controller;
        this.isDisposed = false;
        this.swtRefreshRunnable = new SwtRefreshRunnable();
        this.window = new FontAwareShell(parent, 65537);
        this.window.setVisible(false);
        this.billingEditionControl = new BillingEditionControl();
        this.billingEditionControl.createPartControl((Composite)this.window);
        this.buttonComp = new FontAwareComposite((Composite)this.window, 0);
        toolkit.adapt((Composite)this.buttonComp);
        String btnBillText = String.valueOf(Messages.getString((String)"FERMER", (String[])new String[0])) + " " + Messages.getString((String)"FACTURE", (String[])new String[0]);
        if (this.useOneStepBilling) {
            btnBillText = String.valueOf(Messages.getString((String)"SAUVEGARDER", (String[])new String[0])) + "/" + Messages.getString((String)"FACTURER", (String[])new String[0]);
        } else {
            this.btnSave = new MyButton((Composite)this.buttonComp, Messages.getString((String)"SAUVEGARDER", (String[])new String[0]), 8, toolkit);
        }
        this.btnBill = new MyButton((Composite)this.buttonComp, btnBillText, 8, toolkit);
        this.btnBillAndPay = new MyButton((Composite)this.buttonComp, Messages.getString((String)"FACTURER_PAYER", (String[])new String[0]), 8, toolkit);
        this.btnBillAndPay.setToolTipText(Messages.getString((String)"FACTURER_PAYER_TTT", (String[])new String[0]));
        this.btnCancel = new MyButton((Composite)this.buttonComp, String.valueOf(Messages.getString((String)"FERMER", (String[])new String[0])) + "/" + Messages.getString((String)"ANNULER", (String[])new String[0]), 8, toolkit);
        this.recallLabelProvider = new ProviderAR<XPatientRecall, String>(){

            public String get(XPatientRecall recall) {
                JoinList b = new JoinList(", ", 7);
                b.setTrim(true);
                if (recall.getDateRecall() != null) {
                    b.add((CharSequence)LocalDateFormat.format((LocalDate)recall.getDateRecall(), (String)FormatDateProvider.getFormatDate().toString()));
                }
                b.add((CharSequence)XPatientRecallFormatter.formatWithoutPatientName((XPatientRecall)recall));
                return b.toString();
            }
        };
        FillLayout layout = new FillLayout();
        layout.spacing = 5;
        this.buttonComp.setLayout((Layout)layout);
        this.createSearchFolder(toolkit);
        this.createRightSection(toolkit);
        this.createBilledFolder(toolkit);
        this.createEvents();
        toolkit.adapt((Composite)this.window);
        toolkit.adapt((Composite)this.searchFolder);
        this.mainLayout();
        ResourceGetter.addListener((IRefreshFont)this.window);
    }

    public void mainLayout() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        layout.marginRight = 10;
        layout.spacing = 5;
        this.window.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        Point defPt = this.billingEditionControl.getControl().computeSize(-1, -1, true);
        data.height = defPt.y;
        data.width = (int)((double)defPt.x * 0.9);
        this.billingEditionControl.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.billingEditionControl.getControl());
        data.left = new FormAttachment(this.billingEditionControl.getControl(), 0, 16384);
        data.right = new FormAttachment(this.billingEditionControl.getControl(), 0, 131072);
        data.bottom = new FormAttachment(100);
        this.buttonComp.setLayoutData((Object)data);
        this.hideSearchFolder(false);
        this.window.pack();
        this.setSaveButtonStatus();
    }

    private void createEvents() {
        SelectionAdapter selShowRight = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    BillingRessourceWindow.this.showHideRightSection(((Button)event.widget).getData("do"));
                }
            }
        };
        this.billingEditionControl.btnShowRightAppt.addSelectionListener((SelectionListener)selShowRight);
        this.billingEditionControl.btnShowRightSearch.addSelectionListener((SelectionListener)selShowRight);
        this.billingEditionControl.btnShowRightBilled.addSelectionListener((SelectionListener)selShowRight);
        this.billingEditionControl.btnShowRightNil.addSelectionListener((SelectionListener)selShowRight);
        if (this.btnSave != null) {
            this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BillingRessourceWindow.this.close(CloseType.OK);
                }
            });
        }
        this.btnBill.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BillingRessourceWindow.this.close(CloseType.BILL);
            }
        });
        this.btnBillAndPay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BillingRessourceWindow.this.close(CloseType.BILL_PAY);
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BillingRessourceWindow.this.close(CloseType.CANCEL);
            }
        });
        this.window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.keyDownListener = new Listener(){

            public void handleEvent(Event e) {
                if (!BillingRessourceWindow.this.window.isDisposed() && BillingRessourceWindow.this.window.getDisplay().getActiveShell() == BillingRessourceWindow.this.window) {
                    if (UI.CTRL((Event)e) && UI.CR((Event)e)) {
                        BillingRessourceWindow.this.close(CloseType.OK);
                    } else if (UI.CTRL((Event)e) && (e.character == 'P' || e.character == 'p')) {
                        BillingRessourceWindow.this.billingEditionControl.getTxtPatient().setFocus();
                    } else if (UI.CTRL((Event)e) && (e.character == 'B' || e.character == 'b')) {
                        BillingRessourceWindow.this.billingEditionControl.getTxtRessourceDefData().setFocus();
                    } else if (UI.CTRL((Event)e) && (e.character == 'S' || e.character == 's')) {
                        BillingRessourceWindow.this.save();
                    } else if (UI.CTRL((Event)e) && (e.character == 'N' || e.character == 'n')) {
                        BillingRessourceWindow.this.billingEditionControl.getTxtRessourceDefData().setFocus();
                    } else if (UI.ESC((Event)e)) {
                        if (BillingRessourceWindow.this.searchFolder.isVisible()) {
                            BillingRessourceWindow.this.hideSearchFolder(true);
                            e.doit = false;
                        } else if (BillingRessourceWindow.this.rightSection.isVisible()) {
                            BillingRessourceWindow.this.hideRightSection(true);
                            e.doit = false;
                        } else {
                            BillingRessourceWindow.this.close(CloseType.CANCEL);
                        }
                    }
                }
            }
        };
        this.window.getDisplay().addFilter(1, this.keyDownListener);
    }

    private void showHideRightSection(Object fct) {
        if (fct.equals("search")) {
            this.showSearchFolder();
        } else if (fct.equals("billed")) {
            this.showBilledFolder(false);
        } else if (fct.equals("appt")) {
            this.showRightSection();
        } else if (fct.equals("nil")) {
            System.out.println("rightSectionVisible");
            this.hideBilledSection(false);
            this.hideSearchFolder(false);
            this.hideRightSection(true);
        }
    }

    private void showRightSection() {
        this.billingEditionControl.btnShowRightAppt.setSelection(true);
        this.billingEditionControl.btnShowRightBilled.setSelection(false);
        this.billingEditionControl.btnShowRightNil.setSelection(false);
        this.billingEditionControl.btnShowRightSearch.setSelection(false);
        this.hideSearchFolder(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.billingEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.billingEditionControl.getControl(), -15, 1024);
        data.width = 300;
        this.rightSection.setLayoutData((Object)data);
        this.rightSection.setVisible(true);
        this.window.layout(new Control[]{this.rightSection});
        this.window.pack();
        this.reCenterWindowAuBesoin();
        if (this.patientRecallsNeverFilled) {
            this.fillPatientRecalls();
        }
        if (this.futureAppointmentsNeverFilled) {
            this.fillFuturAppointments();
        }
        if (this.pastAppointmentsNeverFilled) {
            this.fillPastAppointments();
        }
    }

    private void hideBilledSection(boolean doPack) {
        this.hideSearchFolder(false);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.billedRessourceSection.setLayoutData((Object)data);
        this.billedRessourceSection.setVisible(false);
        this.window.layout(new Control[]{this.billedRessourceSection});
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    private void hideRightSection(boolean doPack) {
        this.hideSearchFolder(false);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.rightSection.setLayoutData((Object)data);
        this.rightSection.setVisible(false);
        this.window.layout(new Control[]{this.rightSection});
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    private void createRightSection(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.rightSection = new FontAwareComposite((Composite)this.window, 2048);
        this.rightSection.setBackground(white);
        this.rightSection.setVisible(false);
        FontAwareSection sectionPatientRecalls = new FontAwareSection(this.rightSection, 64, toolkit);
        sectionPatientRecalls.setText(Messages.getString((String)"RAPPELS", (String[])new String[0]));
        FontAwareComposite compPatientRecalls = new FontAwareComposite((Composite)sectionPatientRecalls, 0);
        compPatientRecalls.setLayout((Layout)new FillLayout());
        sectionPatientRecalls.setClient((Control)compPatientRecalls);
        this.tblPatientRecalls = new FontAwareTable((Composite)compPatientRecalls, 2048, toolkit);
        toolkit.createCompositeSeparator((Composite)sectionPatientRecalls);
        FontAwareSection sectionPastAppointments = new FontAwareSection(this.rightSection, 64, toolkit);
        sectionPastAppointments.setText(Messages.getString((String)"RENDEZVOUS_PASSES", (String[])new String[0]));
        FontAwareComposite compPastAppointments = new FontAwareComposite((Composite)sectionPastAppointments, 0);
        compPastAppointments.setLayout((Layout)new FillLayout());
        sectionPastAppointments.setClient((Control)compPastAppointments);
        this.tblPastAppointments = new FontAwareTable((Composite)compPastAppointments, 2048, toolkit);
        toolkit.createCompositeSeparator((Composite)sectionPastAppointments);
        FontAwareSection sectionFutureAppointments = new FontAwareSection(this.rightSection, 64, toolkit);
        sectionFutureAppointments.setText(Messages.getString((String)"RENDEZVOUS_FUTURS", (String[])new String[0]));
        FontAwareComposite compFutureAppointments = new FontAwareComposite((Composite)sectionFutureAppointments, 0);
        compFutureAppointments.setLayout((Layout)new FillLayout());
        sectionFutureAppointments.setClient((Control)compFutureAppointments);
        this.tblFutureAppointments = new FontAwareTable((Composite)compFutureAppointments, 2048, toolkit);
        toolkit.createCompositeSeparator((Composite)sectionFutureAppointments);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.rightSection.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(30);
        sectionPatientRecalls.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionPatientRecalls);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(70);
        sectionPastAppointments.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionPastAppointments);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        sectionFutureAppointments.setLayoutData((Object)data);
        this.tblPatientRecalls.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BillingRessourceWindow.this.tblPatientRecalls.getSelectionCount() == 1 && UI.rightClick((MouseEvent)e)) {
                    Menu menu = new Menu((Control)BillingRessourceWindow.this.tblPatientRecalls);
                    menu.setVisible(true);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(XStatus.APPOINTMENT_GIVEN.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (MessageDialog.openConfirm((Shell)BillingRessourceWindow.this.getWindow(), (String)Messages.getString((String)"APPOINTEMNT_WINDOW.PATIENT_RECALL_CHANGE_STATUS_WARNING_TITLE", (String[])new String[0]), (String)Messages.getString((String)"APPOINTEMNT_WINDOW.PATIENT_RECALL_CHANGE_STATUS_WARNING", (String[])new String[0]))) {
                                XPatientRecall recall = (XPatientRecall)BillingRessourceWindow.this.tblPatientRecalls.getSelection()[0].getData();
                                BillingRessourceWindow.this.changePatientRecallStatus(recall, XStatus.APPOINTMENT_GIVEN);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void changePatientRecallStatus(XPatientRecall recall, XStatus newStatus) {
        block4: {
            JobCallback callback = new JobCallback("changePatientRecallStatus", (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!BillingRessourceWindow.this.isDisposed()) {
                                BillingRessourceWindow.this.fillPatientRecalls();
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().changePatientRecallStatus(recall.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, recall.getId().intValue(), newStatus);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error recall=%s, newStatus=%s", recall, newStatus), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void createBilledFolder(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.billedRessourceSection = new FontAwareComposite((Composite)this.window, 2048);
        this.billedRessourceSection.setBackground(white);
        this.billedRessourceSection.setVisible(false);
        FontAwareSection section = new FontAwareSection(this.billedRessourceSection, 64, toolkit);
        section.setText(Messages.getString((String)"FACTURES", (String[])new String[0]));
        FontAwareComposite comp = new FontAwareComposite((Composite)section, 0);
        comp.setBackground(white);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        section.setClient((Control)comp);
        this.listBilledRessource = new MyList((Composite)comp, 0x800100);
        this.listBilledRessource.setLabelProvider((ProviderAR)new ProviderAR<XBilledRessource, String>(){

            public String get(XBilledRessource e) {
                boolean modified = false;
                String s = "";
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    s = String.valueOf(s) + "id= " + e.getId() + ", ";
                }
                s = String.valueOf(s) + DateUtil.nonThreadSafeFormat((Long)e.getDateBilled(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")) + ": " + e.getGrandTotal().toString() + " (" + e.getSolde().toString() + ")";
                XBaseProfessionnal prof = null;
                if (e.idProfessionnalAnchor != null) {
                    prof = PersonUiPlugin.getDefault().getBaseProfessionnal(e.idProfessionnalAnchor);
                }
                String md = prof == null ? "" : " - " + prof.getName();
                String itemsBilled = "";
                JoinList lstItems = new JoinList(", ");
                for (XBillingRessource br : e.lstBillingRessource) {
                    lstItems.add((CharSequence)br.ressourceDefData.getNameLocal());
                }
                for (XBillingRessource br : e.lstBilledRessourcePaid) {
                    if (!br.isDirty()) continue;
                    modified = true;
                }
                if (lstItems.size() > 0) {
                    itemsBilled = " [" + lstItems.toString() + "]";
                }
                return String.valueOf(modified ? "* " : "") + s + md + itemsBilled;
            }
        });
        this.listBilledRessource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XBilledRessource selection = (XBilledRessource)BillingRessourceWindow.this.listBilledRessource.getSelection3();
                BillingRessourceWindow.this.controller.setCurrentBilledRessource(selection);
                BillingRessourceWindow.this.billedRessourcePaidControl.showCurrent();
                BillingRessourceWindow.this.btnPaySelected.setEnabled(selection != null);
            }
        });
        MyLabel lblPmtMode = new MyLabel((Composite)comp, Messages.getString((String)"MODE_PMT", (String[])new String[0]), 0, toolkit);
        MyLabel lblPay = new MyLabel((Composite)comp, Messages.getString((String)"PAY", (String[])new String[0]), 0, toolkit);
        this.cmbModePmt = new MyCombo((Composite)comp, 8);
        this.cmbModePmt.setItems((Object[])XModePaiement.values());
        this.cmbModePmt.select((Object)XModePaiement.COMPTANT);
        this.btnPayAll = new MyButton((Composite)comp, Messages.getString((String)"ALL", (String[])new String[0]), 8, toolkit);
        this.btnPayAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BillingRessourceWindow.this.payBilledRessources((XModePaiement)BillingRessourceWindow.this.cmbModePmt.getSelection(), null);
            }
        });
        this.btnPaySelected = new MyButton((Composite)comp, Messages.getString((String)"SELECTED", (String[])new String[0]), 8, toolkit);
        this.btnPaySelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BillingRessourceWindow.this.payBilledRessources((XModePaiement)BillingRessourceWindow.this.cmbModePmt.getSelection(), BillingRessourceWindow.this.controller.getCurrentBilledRessource());
            }
        });
        this.btnPaySelected.setEnabled(false);
        MyLabel lblPmtList = new MyLabel((Composite)comp, Messages.getString((String)"PMTS_LIST", (String[])new String[0]), 0, toolkit);
        this.fakeEditor = new FakeEditor(this.listBilledRessource);
        this.billedRessourcePaidControl = new BilledRessourcePaidControl((Composite)comp, this.fakeEditor, toolkit);
        this.billedRessourcePaidControl.setController(this.controller);
        this.billedRessourcePaidControl.setBackground(white);
        GridData gdata = new GridData();
        gdata.horizontalSpan = 4;
        gdata.heightHint = 200;
        gdata.minimumHeight = 150;
        gdata.verticalAlignment = 4;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        this.listBilledRessource.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        gdata.minimumHeight = 20;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        lblPmtMode.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        gdata.minimumHeight = 20;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        lblPay.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 2;
        gdata.heightHint = 22;
        gdata.minimumHeight = 22;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        this.cmbModePmt.getControl().setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 1;
        gdata.heightHint = 22;
        gdata.minimumHeight = 22;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        this.btnPayAll.getControl().setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 1;
        gdata.heightHint = 22;
        gdata.minimumHeight = 22;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        this.btnPaySelected.getControl().setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 4;
        gdata.heightHint = 20;
        gdata.minimumHeight = 20;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = false;
        lblPmtList.setLayoutData((Object)gdata);
        gdata = new GridData();
        gdata.horizontalSpan = 4;
        gdata.heightHint = 300;
        gdata.minimumHeight = 1000;
        gdata.verticalAlignment = 4;
        gdata.horizontalAlignment = 4;
        gdata.grabExcessHorizontalSpace = true;
        gdata.grabExcessVerticalSpace = true;
        this.billedRessourcePaidControl.setLayoutData(gdata);
        MyButton btnConfirmPayment = new MyButton(this.billedRessourceSection, Messages.getString((String)"CONFIRMER", (String[])new String[0]), 8, toolkit);
        MyButton btnPrintBilled = new MyButton(this.billedRessourceSection, Messages.getString((String)"IMPRIMER", (String[])new String[0]), 8, toolkit);
        MyButton btnConfirmAndPrint = new MyButton(this.billedRessourceSection, String.valueOf(Messages.getString((String)"CONFIRMER", (String[])new String[0])) + " && " + Messages.getString((String)"IMPRIMER", (String[])new String[0]), 8, toolkit);
        btnPrintBilled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BillingRessourceWindow.this.onPrint();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnConfirmPayment.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<XBillingRessource> lst = BillingRessourceWindow.this.controller.getLstBillingRessources();
                HashSet<XBilledRessource> lstBilled = new HashSet<XBilledRessource>();
                for (XBillingRessource xx : lst) {
                    if (xx.getBilledRessource() == null) continue;
                    lstBilled.add(xx.getBilledRessource());
                }
                if (lstBilled.isEmpty()) {
                    MessageDialog.openInformation((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"SELECT_FACTURE", (String[])new String[0]));
                } else {
                    boolean hasNewPaymentDone = false;
                    block1: for (XBilledRessource xBilledRessource : lstBilled) {
                        for (XBilledRessourcePaid x : xBilledRessource.getLstBilledRessourcePaid()) {
                            if (!x.isDirty()) continue;
                            hasNewPaymentDone = true;
                            continue block1;
                        }
                    }
                    if (hasNewPaymentDone) {
                        BillingRessourceWindow.this.close(CloseType.CONFIRM_PAY);
                    } else {
                        MessageDialog.openInformation((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"NO_NEW_PAYMENT_DONE", (String[])new String[0]));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnConfirmAndPrint.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<XBillingRessource> lst = BillingRessourceWindow.this.controller.getLstBillingRessources();
                HashSet<XBilledRessource> lstBilled = new HashSet<XBilledRessource>();
                for (XBillingRessource xx : lst) {
                    if (xx.getBilledRessource() == null) continue;
                    lstBilled.add(xx.getBilledRessource());
                }
                if (lstBilled.isEmpty()) {
                    MessageDialog.openInformation((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"SELECT_FACTURE", (String[])new String[0]));
                } else {
                    boolean hasNewPaymentDone = false;
                    block1: for (XBilledRessource xBilledRessource : lstBilled) {
                        for (XBilledRessourcePaid x : xBilledRessource.getLstBilledRessourcePaid()) {
                            if (!x.isDirty()) continue;
                            hasNewPaymentDone = true;
                            continue block1;
                        }
                    }
                    if (hasNewPaymentDone) {
                        BillingRessourceWindow.this.close(CloseType.CONFIRM_PAY_PRINT);
                    } else {
                        MessageDialog.openInformation((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"NO_NEW_PAYMENT_DONE", (String[])new String[0]));
                        BillingRessourceWindow.this.onPrint();
                        BillingRessourceWindow.this.close(CloseType.CANCEL);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolkit.createCompositeSeparator((Composite)section);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.billedRessourceSection.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        btnConfirmAndPrint.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)btnConfirmAndPrint, -5);
        btnPrintBilled.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)btnPrintBilled, -5);
        btnConfirmPayment.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)btnConfirmPayment, -5);
        section.setLayoutData((Object)data);
    }

    private void fillBilledRessources(final boolean addPaidData) {
        block5: {
            if (this.controller != null && this.controller.getCurrentPatient() != null) {
                JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!BillingRessourceWindow.this.isDisposed()) {
                                    if (response == null || response.getObj() == null) {
                                        BillingRessourceWindow.this.fillBilledRessources(Collections.EMPTY_LIST, false);
                                    } else {
                                        BillingRessourceWindow.this.fillBilledRessources((List)response.getObj(), addPaidData);
                                    }
                                }
                            }
                        });
                    }
                };
                try {
                    XBillCriteria container = new XBillCriteria();
                    container.idPatientAnchor = this.controller.getCurrentPatient().getId();
                    container.isTermnated = Boolean.TRUE;
                    container.idBilledNotNull = Boolean.TRUE;
                    container.withSolde = Boolean.TRUE;
                    RessourceAccessorClient.getInstance().getBilledRessourceByCriteria(container, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to fillBilledRessources", e);
                    if (callback == null || callback.killed()) break block5;
                    callback.kill();
                }
            }
        }
    }

    private void payBilledRessources(XModePaiement modePmt, XBilledRessource br) {
        BigDecimal zero = new BigDecimal(0);
        if (br == null) {
            XBilledRessource lastXBilledRessource = null;
            for (XBilledRessource xBilledRessource : this.listBilledRessource.getModel()) {
                lastXBilledRessource = xBilledRessource;
                if (lastXBilledRessource.getSolde().compareTo(zero) <= 0) continue;
                BigDecimal soldePublic = new BigDecimal(0);
                for (XBillingRessource xbgr : lastXBilledRessource.lstBillingRessource) {
                    if (!XResponsablePmt.ASSURANCE_PUBLIQUE.equals((Object)xbgr.getRessourceDefData().getRessourceDef().getRessource().getResponsablePmt())) continue;
                    soldePublic = soldePublic.add(xbgr.getRessourceDefData().getPrixBaseInitial()).add(xbgr.getRessourceDefData().getPrixParUnit());
                }
                if (lastXBilledRessource.getSolde().compareTo(soldePublic) <= 0) continue;
                this.controller.setCurrentBilledRessource(xBilledRessource);
                this.billedRessourcePaidControl.addItem(modePmt);
            }
        } else {
            XBilledRessource lastXBilledRessource = br;
            if (lastXBilledRessource.getSolde().compareTo(zero) > 0) {
                BigDecimal soldePublic = new BigDecimal(0);
                for (XBillingRessource xbgr : lastXBilledRessource.lstBillingRessource) {
                    if (!XResponsablePmt.ASSURANCE_PUBLIQUE.equals((Object)xbgr.getRessourceDefData().getRessourceDef().getRessource().getResponsablePmt())) continue;
                    soldePublic = soldePublic.add(xbgr.getRessourceDefData().getPrixBaseInitial()).add(xbgr.getRessourceDefData().getPrixParUnit());
                }
                if (lastXBilledRessource.getSolde().compareTo(soldePublic) > 0) {
                    this.billedRessourcePaidControl.addItem(modePmt);
                }
            }
        }
    }

    private void fillBilledRessources(List<XBilledRessource> list, boolean addPaidData) {
        Collections.sort(list, new Comparator<XBilledRessource>(){

            @Override
            public int compare(XBilledRessource a0, XBilledRessource a1) {
                return a0.getDateBilled().compareTo(a1.getDateBilled());
            }
        });
        this.listBilledRessource.setItems(list);
        this.billedRessourcesNeverFilled = false;
        XBilledRessource lastXBilledRessource = null;
        if (addPaidData) {
            BigDecimal zero = new BigDecimal(0);
            for (XBilledRessource xBilledRessource : this.listBilledRessource.getModel()) {
                if (xBilledRessource.getSolde().compareTo(zero) <= 0) continue;
                double soldePublic = 0.0;
                for (XBillingRessource xbgr : xBilledRessource.lstBillingRessource) {
                    if (!XResponsablePmt.ASSURANCE_PUBLIQUE.equals((Object)xbgr.getRessourceDefData().getRessourceDef().getRessource().getResponsablePmt())) continue;
                    soldePublic += xbgr.getRessourceDefData().getPrixBaseInitial().doubleValue() + xbgr.getRessourceDefData().getPrixParUnit().doubleValue();
                }
                BigDecimal totalSoldePublic = new BigDecimal(soldePublic);
                if (xBilledRessource.getSolde().compareTo(totalSoldePublic) <= 0) continue;
                this.controller.setCurrentBilledRessource(xBilledRessource);
                this.billedRessourcePaidControl.addItem(null);
            }
            this.billedRessourcePaidControl.showCurrent();
        }
        HashSet xbr = new HashSet();
        ArrayList<XBillingRessource> lstBr = new ArrayList<XBillingRessource>();
        for (XBilledRessource x : list) {
            if (!x.getLstBillingRessource().isEmpty()) {
                xbr.addAll(x.lstBillingRessource);
            }
            lastXBilledRessource = x;
        }
        lstBr.addAll(xbr);
        this.controller.setLstBillingRessources(lstBr);
        this.controller.setCurrentBilledRessource(lastXBilledRessource);
        this.listBilledRessource.setSelection((Object)lastXBilledRessource);
    }

    private void fillPatientRecalls() {
        block7: {
            if (this.controller != null) {
                XPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BillingRessourceWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            BillingRessourceWindow.this.fillPatientRecalls(Collections.EMPTY_LIST);
                                        } else {
                                            BillingRessourceWindow.this.fillPatientRecalls((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
                        criteria.patientId = patient.getId();
                        AppointmentAccessorClient.getInstance().findPatientRecall(Application.get().getGlobalInstances().getSession(), (ICallback)callback, criteria);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillPatientRecalls, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillPatientRecalls(Collections.EMPTY_LIST);
            }
        }
    }

    private void fillPatientRecalls(List<XPatientRecall> list) {
        this.recalls = new ArrayList<XPatientRecall>(list.size());
        for (XPatientRecall recall : list) {
            if (recall.getStatus() != XStatus.NORMAL && recall.getStatus() != XStatus.CLIENT_NOT_REACHED) continue;
            this.recalls.add(recall);
        }
        Collections.sort(this.recalls);
        this.tblPatientRecalls.clearAll();
        this.tblPatientRecalls.setItemCount(0);
        for (XPatientRecall recall : this.recalls) {
            TableItem item = new TableItem((Table)this.tblPatientRecalls, 0);
            item.setData((Object)recall);
            item.setText((String)this.recallLabelProvider.get((Object)recall));
        }
        String text = (String)this.billingEditionControl.btnShowRightAppt.getData("text");
        text = String.valueOf(text) + "(" + this.tblPatientRecalls.getItemCount() + ")";
        this.billingEditionControl.btnShowRightAppt.setText(text);
        this.patientRecallsNeverFilled = false;
    }

    private void fillPastAppointments() {
        block7: {
            if (this.controller != null) {
                XPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BillingRessourceWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            BillingRessourceWindow.this.fillPastAppointments(new ArrayList(0));
                                        } else {
                                            BillingRessourceWindow.this.fillPastAppointments((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        AppointmentAccessorClient.getInstance().findPastAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillFuturAppointments, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillPastAppointments(new ArrayList<XAppointment>(0));
            }
        }
    }

    private void fillFuturAppointments() {
        block7: {
            if (this.controller != null) {
                XPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!BillingRessourceWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            BillingRessourceWindow.this.fillFuturAppointments(new ArrayList(0));
                                        } else {
                                            BillingRessourceWindow.this.fillFuturAppointments((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillFuturAppointments, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillFuturAppointments(new ArrayList<XAppointment>(0));
            }
        }
    }

    private void fillPastAppointments(List<XAppointment> appointments) {
        this.tblPastAppointments.clearAll();
        this.tblPastAppointments.setItemCount(0);
        for (XAppointment appointment : appointments) {
            if (Boolean.TRUE.equals(appointment.getIsDeleted())) continue;
            TableItem item = new TableItem((Table)this.tblPastAppointments, 0);
            item.setData((Object)appointment);
            item.setText(XAppointmentFormatter.format((IAppointment)appointment, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true));
        }
        this.pastAppointmentsNeverFilled = false;
    }

    private void fillFuturAppointments(List<XAppointment> appointments) {
        this.tblFutureAppointments.clearAll();
        this.tblFutureAppointments.setItemCount(0);
        for (XAppointment appointment : appointments) {
            if (Boolean.TRUE.equals(appointment.getIsDeleted())) continue;
            TableItem item = new TableItem((Table)this.tblFutureAppointments, 0);
            item.setData((Object)appointment);
            item.setText(XAppointmentFormatter.format((IAppointment)appointment, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true));
        }
        this.futureAppointmentsNeverFilled = false;
    }

    private void createSearchFolder(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.searchFolder = new TabFolder((Composite)this.window, 2048);
        this.searchFolder.setBackground(white);
        this.searchFolder.setLayout((Layout)new FormLayout());
        this.searchFolder.setVisible(false);
        this.tabSearchPatient = new TabItem(this.searchFolder, 0);
        this.tabSearchPatient.setText("Client");
        Composite parent1 = new Composite((Composite)this.searchFolder, 0);
        parent1.setBackground(white);
        parent1.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        parent1.setLayoutData((Object)data);
        this.patientSearchComposite = new PatientSearchComposite(parent1, toolkit, 0);
        this.patientSearchComposite.setIsWithButtonNew(false);
        this.patientSearchComposite.setContextSiteProvider((ContextSiteProvider)this.billingEditionControl);
        this.tabSearchPatient.setControl((Control)parent1);
        this.tabSearchProfessionnal = new TabItem(this.searchFolder, 0);
        this.tabSearchProfessionnal.setText(Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]));
        Composite parent2 = new Composite((Composite)this.searchFolder, 0);
        parent2.setBackground(white);
        parent2.setLayout((Layout)new FillLayout());
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        parent2.setLayoutData((Object)data);
        this.professionnalSearchComposite = new ProfessionnalSearchComposite(parent2, toolkit, 0);
        this.tabSearchProfessionnal.setControl((Control)parent2);
        this.tabSearchRessourceDefData = new TabItem(this.searchFolder, 0);
        this.tabSearchRessourceDefData.setText(Messages.getString((String)"RESSOURCES", (String[])new String[0]));
        Composite parent3 = new Composite((Composite)this.searchFolder, 0);
        parent3.setBackground(white);
        parent3.setLayout((Layout)new FillLayout());
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        parent3.setLayoutData((Object)data);
        this.ressourceDefDataSearchComposite = new RessourceDefDataSearchComposite(parent3, toolkit, 0);
        this.tabSearchRessourceDefData.setControl((Control)parent3);
        this.billingEditionControl.setPatientSearchProvider(new ProviderR<PatientSearchComposite>(){

            public PatientSearchComposite get() {
                BillingRessourceWindow.this.showSearchFolder();
                BillingRessourceWindow.this.searchFolder.setSelection(BillingRessourceWindow.this.tabSearchPatient);
                if (BillingRessourceWindow.this.patientSearchComposite != null) {
                    BillingRessourceWindow.this.patientSearchComposite.setFocus();
                }
                return BillingRessourceWindow.this.patientSearchComposite;
            }
        });
        this.billingEditionControl.setProfessionalSearchProvider(new ProviderR<ProfessionnalSearchComposite>(){

            public ProfessionnalSearchComposite get() {
                BillingRessourceWindow.this.showSearchFolder();
                BillingRessourceWindow.this.searchFolder.setSelection(BillingRessourceWindow.this.tabSearchProfessionnal);
                if (BillingRessourceWindow.this.professionnalSearchComposite != null) {
                    BillingRessourceWindow.this.professionnalSearchComposite.getControl().setFocus();
                }
                return BillingRessourceWindow.this.professionnalSearchComposite;
            }
        });
        this.billingEditionControl.setRessourceDefDataSearchProvider(new ProviderR<RessourceDefDataSearchComposite>(){

            public RessourceDefDataSearchComposite get() {
                BillingRessourceWindow.this.showSearchFolder();
                BillingRessourceWindow.this.searchFolder.setSelection(BillingRessourceWindow.this.tabSearchRessourceDefData);
                if (BillingRessourceWindow.this.ressourceDefDataSearchComposite != null) {
                    BillingRessourceWindow.this.ressourceDefDataSearchComposite.getControl().setFocus();
                }
                return BillingRessourceWindow.this.ressourceDefDataSearchComposite;
            }
        });
        this.controls[0] = this.searchFolder;
    }

    private void setWindowTitle() {
        if (!this.window.isDisposed()) {
            if (this.controller == null) {
                this.window.setText("");
            } else if (Platform.inDebugMode() && this.controller.getBillingRessource() != null) {
                XBillingRessource br = this.controller.getBillingRessource();
                this.window.setText("appid=" + this.controller.getId() + ", ptid=" + br.getIdPatientAnchor() + "  " + this.controller.format(true, true));
            } else {
                this.window.setText(this.controller.format(true, true));
            }
        }
    }

    private void setSaveButtonStatus() {
        if (this.btnSave != null) {
            this.btnSave.setEnabled(this.controller != null && this.controller.hasBillingRessourceReadyToSave());
        }
        this.btnBill.setEnabled(this.controller.getLstBillingRessources().size() > 0);
    }

    public void setFocus() {
        this.billingEditionControl.setFocus();
    }

    public Point getLocation() {
        Composite parent = this.window.getParent();
        Point location = parent.getLocation();
        Point size = parent.getSize();
        Point mySize = this.window.getSize();
        int x = location.x + size.x / 2 - mySize.x / 2;
        int y = location.y + size.y / 2 - mySize.y / 2;
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.window.setLocation(location);
    }

    private void showBilledFolder(boolean addPaidData) {
        this.billingEditionControl.btnShowRightAppt.setSelection(false);
        this.billingEditionControl.btnShowRightBilled.setSelection(true);
        this.billingEditionControl.btnShowRightNil.setSelection(false);
        this.billingEditionControl.btnShowRightSearch.setSelection(false);
        this.hideRightSection(false);
        this.hideSearchFolder(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.billingEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.billingEditionControl.getControl(), -15, 1024);
        data.width = 300;
        this.billedRessourceSection.setLayoutData((Object)data);
        this.billedRessourceSection.setVisible(true);
        this.window.layout(new Control[]{this.billedRessourceSection});
        this.window.pack();
        this.reCenterWindowAuBesoin();
        if (this.billedRessourcesNeverFilled) {
            this.fillBilledRessources(addPaidData);
        }
    }

    private void showSearchFolder() {
        this.billingEditionControl.btnShowRightAppt.setSelection(false);
        this.billingEditionControl.btnShowRightBilled.setSelection(false);
        this.billingEditionControl.btnShowRightNil.setSelection(false);
        this.billingEditionControl.btnShowRightSearch.setSelection(true);
        this.hideRightSection(false);
        this.hideBilledSection(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.billingEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.billingEditionControl.getControl(), 10, 1024);
        data.width = 300;
        this.searchFolder.setLayoutData((Object)data);
        this.searchFolder.setVisible(true);
        this.window.layout(new Control[]{this.searchFolder});
        if (this.searchFolder.getSelectionIndex() == 0) {
            this.patientSearchComposite.setFocus();
        } else if (this.searchFolder.getSelectionIndex() == 1) {
            this.professionnalSearchComposite.setFocus();
        } else {
            this.ressourceDefDataSearchComposite.setFocus();
        }
        this.window.pack();
        this.reCenterWindowAuBesoin();
    }

    protected void reCenterWindowAuBesoin() {
        Point location = this.window.getLocation();
        Point size = this.window.getSize();
        Rectangle bounds = this.window.getDisplay().getClientArea();
        Rectangle rect = this.window.getBounds();
        int x = 0;
        int y = 0;
        if (location.x + size.x > bounds.width) {
            x = bounds.x + (bounds.width - rect.width) / 2;
        }
        y = bounds.y + (bounds.height - rect.height) / 2;
        if (x != 0 || y != 0) {
            x = x == 0 ? rect.x : x;
            y = y == 0 ? rect.y : y;
            this.window.setLocation(x, y);
        }
    }

    private void hideSearchFolder(boolean doPack) {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.searchFolder.setLayoutData((Object)data);
        this.searchFolder.setVisible(false);
        this.window.layout(this.controls);
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    public void open() {
        this.ressourceDefDataSearchComposite.reset();
        this.professionnalSearchComposite.reset();
        this.professionnalSearchComposite.setType(Integer.valueOf(1));
        this.patientSearchComposite.reset();
        this.billingEditionControl.btnShowRightSearch.setSelection(false);
        this.billingEditionControl.btnShowRightBilled.setSelection(false);
        this.billingEditionControl.btnShowRightAppt.setSelection(false);
        this.billingEditionControl.btnShowRightNil.setSelection(true);
        this.billingEditionControl.btnShowRightNil.notifyListeners(13, new Event());
        this.reCenterWindowAuBesoin();
        this.window.setVisible(true);
        this.setFocus();
    }

    private void close(CloseType closeType) {
        this.close(closeType, false);
    }

    private void close(CloseType closeType, boolean openPatientEditorOnSucess) {
        this.close(closeType, openPatientEditorOnSucess, XModePaiement.COMPTANT, null);
    }

    private void close(CloseType closeType, boolean openPatientEditorOnSucess, XModePaiement modePmt, XBilledRessource selected) {
        this.billingEditionControl.getTxtPatient().setFocus();
        IStatus status = null;
        switch (closeType) {
            case OK: {
                XPatient patient;
                status = this.save();
                if (!status.isOkToProceed()) break;
                this.window.setVisible(false);
                if (!openPatientEditorOnSucess || (patient = this.controller.getCurrentPatient()) == null) break;
                patient = patient.clone();
                if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                    PersonMultiEditorFactory.openPatient((IPatient)patient);
                    break;
                }
                PatientMultiEditor editor = (PatientMultiEditor)BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)patient), (String)PatientMultiEditor.class.getName());
                if (editor == null) break;
                editor.setActivePage(editor.getiGeneralPage());
                break;
            }
            case BILL: {
                status = this.billAll();
                if (!status.isOkToProceed()) {
                    MessageDialog.openError((Shell)UI.getWorkbenchShell(), (String)"Facturation", (String)status.getMessage());
                    break;
                }
                HashSet<XBilledRessource> setBR = new HashSet<XBilledRessource>();
                for (XBillingRessource xBillingRessource : this.controller.getLstBillingRessources()) {
                    if (xBillingRessource.billedRessource == null) continue;
                    setBR.add(xBillingRessource.billedRessource);
                }
                this.controller.setCurrentBillingRessource(null);
                this.billingEditionControl.billingRessourceChanged();
                this.listBilledRessource.setItems(setBR);
                this.listBilledRessource.select(null);
                this.showBilledFolder(false);
                break;
            }
            case BILL_PAY: {
                status = this.billAll();
                if (status.isOkToProceed()) {
                    HashSet<XBilledRessource> setBR = new HashSet<XBilledRessource>();
                    for (XBillingRessource xBillingRessource : this.controller.getLstBillingRessources()) {
                        if (xBillingRessource.billedRessource == null) continue;
                        setBR.add(xBillingRessource.billedRessource);
                    }
                    this.controller.setCurrentBillingRessource(null);
                    this.billingEditionControl.billingRessourceChanged();
                    this.listBilledRessource.setItems(setBR);
                    this.listBilledRessource.select(null);
                    this.showBilledFolder(true);
                    break;
                }
                MessageDialog.openError((Shell)UI.getWorkbenchShell(), (String)"Facturation", (String)status.getMessage());
                break;
            }
            case CONFIRM_PAY: {
                status = this.confirmPay();
                if (!status.isOkToProceed()) {
                    MessageDialog.openError((Shell)UI.getWorkbenchShell(), (String)"Facturation", (String)status.getMessage());
                    break;
                }
                HashSet<XBilledRessource> setBR = new HashSet<XBilledRessource>();
                for (XBillingRessource xxx : this.controller.getLstBillingRessources()) {
                    if (xxx.billedRessource == null) continue;
                    setBR.add(xxx.billedRessource);
                }
                this.listBilledRessource.setItems(setBR);
                this.listBilledRessource.select(null);
                this.controller.setCurrentBilledRessource(null);
                this.billedRessourcePaidControl.showCurrent();
                break;
            }
            case CONFIRM_PAY_PRINT: {
                status = this.confirmPay();
                if (!status.isOkToProceed()) {
                    MessageDialog.openError((Shell)UI.getWorkbenchShell(), (String)"Facturation", (String)status.getMessage());
                    break;
                }
                HashSet<XBilledRessource> setBR = new HashSet<XBilledRessource>();
                for (XBillingRessource xxx : this.controller.getLstBillingRessources()) {
                    if (xxx.billedRessource == null) continue;
                    setBR.add(xxx.billedRessource);
                }
                this.listBilledRessource.setItems(setBR);
                this.listBilledRessource.select(null);
                this.controller.setCurrentBilledRessource(null);
                this.billedRessourcePaidControl.showCurrent();
                this.onPrint();
                this.close(CloseType.CANCEL);
                break;
            }
            case CANCEL: {
                if (!this.cancel()) break;
                this.window.setVisible(false);
            }
        }
    }

    private boolean cancel() {
        IStatus status = this.billingEditionControl.doCancel(null);
        return status.isOK();
    }

    private IStatus save() {
        return this.billingEditionControl.doSave(null);
    }

    private IStatus billAll() {
        return this.billingEditionControl.doBillAll(null);
    }

    private IStatus confirmPay() {
        return this.billingEditionControl.doConfirmPayment(null);
    }

    public Shell getWindow() {
        return this.window;
    }

    public void setBillingRessourceEditorInput(BillingRessourceController newController) {
        if (this.controller != null) {
            this.controller.removeListener(this);
        }
        this.billedRessourcesNeverFilled = true;
        this.futureAppointmentsNeverFilled = true;
        this.pastAppointmentsNeverFilled = true;
        this.patientRecallsNeverFilled = true;
        this.controller = newController;
        this.billingEditionControl.setController(this.controller);
        if (this.controller == null) {
            this.billedRessourcesNeverFilled = false;
            this.pastAppointmentsNeverFilled = false;
            this.futureAppointmentsNeverFilled = false;
            this.patientRecallsNeverFilled = false;
        } else {
            this.controller.addListener(this);
        }
        this.billingEditionControl.patientChanged();
        this.setWindowTitle();
        this.setSaveButtonStatus();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.billingEditionControl.setPatientSearchProvider(null);
            this.billingEditionControl.setProfessionalSearchProvider(null);
            this.billingEditionControl.dispose();
            if (this.controller != null) {
                this.controller.removeListener(this);
            }
            this.swtRefreshRunnable = null;
            this.patientSearchComposite.getControl().dispose();
            this.professionnalSearchComposite.getControl().dispose();
            this.searchFolder.dispose();
            if (this.btnSave != null) {
                this.btnSave.dispose();
            }
            this.btnCancel.dispose();
            this.window.getDisplay().removeFilter(1, this.keyDownListener);
            this.window.dispose();
            this.isDisposed = true;
            ResourceGetter.removeListener((IRefreshFont)this.window);
        }
    }

    public void refreshFont() {
        if (!this.isDisposed) {
            this.window.refreshFont();
            this.mainLayout();
            this.window.layout(true, true);
        }
    }

    @Override
    public void billedRessourceChanged() {
        System.out.println("in IBillingRessourceControllerListenerImplementation.billedRessourceChanged()");
        Display.getDefault().asyncExec((Runnable)this.swtRefreshRunnable);
    }

    @Override
    public void billingRessourceChanged() {
        System.out.println("in IBillingRessourceControllerListenerImplementation.billingRessourceChanged()");
        Display.getDefault().asyncExec((Runnable)this.swtRefreshRunnable);
    }

    @Override
    public void billingRessourceModified() {
        System.out.println("in IBillingRessourceControllerListenerImplementation.billingRessourceModified()");
        Display.getDefault().asyncExec((Runnable)this.swtRefreshRunnable);
    }

    @Override
    public void patientChanged() {
        this.billingEditionControl.btnShowRightSearch.setSelection(false);
        this.billingEditionControl.btnShowRightBilled.setSelection(false);
        this.billingEditionControl.btnShowRightAppt.setSelection(false);
        this.billingEditionControl.btnShowRightNil.setSelection(true);
        this.billingEditionControl.btnShowRightNil.notifyListeners(13, new Event());
        this.billedRessourcesNeverFilled = true;
        this.futureAppointmentsNeverFilled = true;
        this.pastAppointmentsNeverFilled = true;
        this.patientRecallsNeverFilled = true;
        this.listBilledRessource.removeAll();
        this.recalls.clear();
        this.tblPatientRecalls.clearAll();
        this.tblPastAppointments.clearAll();
        this.tblFutureAppointments.clearAll();
        Display.getDefault().asyncExec((Runnable)this.swtRefreshRunnable);
        System.out.println("in IBillingRessourceControllerListenerImplementation.patientChanged()");
    }

    @Override
    public void patientModified() {
        System.out.println("in BillingRessourceWindow.IBillingRessourceControllerListenerImplementation.patientModified()");
    }

    protected void onPrint() {
        List<XBillingRessource> lst = this.controller.getLstBillingRessources();
        HashSet<XBilledRessource> lstBilled = new HashSet<XBilledRessource>();
        for (XBillingRessource xx : lst) {
            if (xx.getBilledRessource() == null) continue;
            lstBilled.add(xx.getBilledRessource());
        }
        if (lstBilled.isEmpty()) {
            MessageDialog.openInformation((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"FACTURATION", (String[])new String[0]), (String)Messages.getString((String)"AUCUNE_FACTURE_ACTIVE", (String[])new String[0]));
        } else {
            PrintDialog2 dialog = new PrintDialog2(UI.getWorkbenchShell(), lstBilled);
            dialog.open();
        }
    }

    private static enum CloseType {
        OK,
        CANCEL,
        BILL,
        BILL_PAY,
        CONFIRM_PAY,
        CONFIRM_PAY_PRINT;

    }

    private final class SwtRefreshRunnable
    implements Runnable {
        private SwtRefreshRunnable() {
        }

        @Override
        public void run() {
            BillingRessourceWindow.this.setWindowTitle();
            BillingRessourceWindow.this.setSaveButtonStatus();
        }
    }
}

