/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource.cellediting;

import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractPopupWindow
extends Composite {
    protected Button button;
    private final FormToolkit toolkit;
    protected int eventX;
    protected int eventY;
    private Shell popup;
    private Listener popupCloseOnMouseDownListener;
    private Listener popusFocusOutListener;
    protected SelectionAdapter buttonSelection;

    public AbstractPopupWindow(Composite parent, int style, Button btn, FormToolkit toolkit) {
        super(parent, style);
        if (btn == null) {
            throw new NullPointerException("button");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.toolkit = toolkit;
        toolkit.adapt((Composite)this);
        this.button = btn;
        this.buttonSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPopupWindow.this.openPopupWindow(AbstractPopupWindow.this.button);
            }
        };
        this.setLayout((Layout)new FillLayout());
        this.button.addSelectionListener((SelectionListener)this.buttonSelection);
        this.popupCloseOnMouseDownListener = new Listener(){

            public void handleEvent(Event e) {
                AbstractPopupWindow.this.hideIfEventLocationIsOutsidePopupAndSourceControlBounds(e);
            }
        };
        final ControlListener popupMoveOnControlEventListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                this.follow();
            }

            public void controlMoved(ControlEvent e) {
                this.follow();
            }

            private void follow() {
                if (!AbstractPopupWindow.this.isDisposed() && AbstractPopupWindow.this.popup != null && !AbstractPopupWindow.this.popup.isDisposed() && AbstractPopupWindow.this.popup.getVisible()) {
                    Point location = AbstractPopupWindow.this.computePopupLocation();
                    AbstractPopupWindow.this.popup.setLocation(location);
                }
            }
        };
        this.button.addControlListener(popupMoveOnControlEventListener);
        this.getShell().addControlListener(popupMoveOnControlEventListener);
        this.popusFocusOutListener = new Listener(){

            public void handleEvent(Event e) {
                if (AbstractPopupWindow.this.popup.getVisible()) {
                    AbstractPopupWindow.this.getDisplay().timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractPopupWindow.this.popup != null && !AbstractPopupWindow.this.popup.isDisposed() && !UI.hasFocus((Control)AbstractPopupWindow.this.popup)) {
                                AbstractPopupWindow.this.close();
                            }
                        }
                    });
                }
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell s;
                if (!AbstractPopupWindow.this.button.isDisposed()) {
                    AbstractPopupWindow.this.button.removeSelectionListener((SelectionListener)AbstractPopupWindow.this.buttonSelection);
                }
                if (!(s = AbstractPopupWindow.this.getShell()).isDisposed()) {
                    AbstractPopupWindow.this.getShell().removeControlListener(popupMoveOnControlEventListener);
                    AbstractPopupWindow.this.getDisplay().removeFilter(3, AbstractPopupWindow.this.popupCloseOnMouseDownListener);
                }
                if (AbstractPopupWindow.this.popup != null) {
                    AbstractPopupWindow.this.popup.dispose();
                    AbstractPopupWindow.this.popup = null;
                }
            }
        });
    }

    protected void hideIfEventLocationIsOutsidePopupAndSourceControlBounds(Event e) {
        if (!this.isDisposed() && this.popup != null && !this.popup.isDisposed() && this.popup.getVisible()) {
            Rectangle popupBounds;
            int x = e.x;
            int y = e.y;
            if (e.widget instanceof Control) {
                Point point = e.display.map((Control)e.widget, null, x, y);
                x = point.x;
                y = point.y;
            }
            if (!(popupBounds = this.popup.getBounds()).contains(x, y)) {
                Rectangle bounds = this.getBounds();
                Rectangle controlBounds = e.display.map((Control)this.getParent(), null, bounds);
                if (!controlBounds.contains(x, y)) {
                    this.popup.close();
                }
            }
        }
    }

    private void openPopupWindow(Button button) {
        if (this.popup == null || this.popup.isDisposed()) {
            this.popup = this.createPopupControl(this.getShell(), this.toolkit);
            this.popup.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    AbstractPopupWindow.this.dispose();
                }
            });
            this.refreshPopup();
            this.popup.addListener(16, this.popusFocusOutListener);
            this.getDisplay().addFilter(3, this.popupCloseOnMouseDownListener);
            this.popup.setLocation(this.computePopupLocation());
            this.popup.open();
        } else if (this.popup.getVisible()) {
            this.popup.setVisible(false);
        } else {
            this.refreshPopup();
            this.popup.setLocation(this.computePopupLocation());
            this.popup.setVisible(true);
        }
    }

    private Shell createPopupControl(Shell parent, FormToolkit toolkit) {
        Shell shell = this.createPopupControlOverride(parent, toolkit);
        Control[] controlArray = shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addListener(16, this.popusFocusOutListener);
            ++n2;
        }
        return shell;
    }

    protected abstract Shell createPopupControlOverride(Shell var1, FormToolkit var2);

    private Point computePopupLocation() {
        Display display = this.button.getDisplay();
        Rectangle displayBounds = display.getBounds();
        int displayX2 = displayBounds.x + displayBounds.width;
        int popupHeight = this.popup.getBounds().height;
        int y = this.button.getBounds().y - popupHeight;
        int x = this.button.getBounds().x;
        Point point = display.map((Control)this.button.getParent(), null, x, y);
        int popupWidth = this.popup.getBounds().width;
        if (point.x + popupWidth > displayX2) {
            point.x = displayX2 - popupWidth;
        }
        return point;
    }

    protected abstract void reset();

    protected abstract String computeLabel();

    public Shell getPopup() {
        return this.popup;
    }

    public void close() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            this.getPopup().setVisible(false);
            this.getPopup().close();
        }
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    protected abstract void refreshPopup();
}

