/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.RessourceAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceCriteria;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.ressource.RessourceEditor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class RessourceEditorFactory {
    private static final Logger logger = Logger.getLogger(RessourceEditorFactory.class.getName());

    public static void openRessource(XRessource x) throws ErrorWhileSearchingException {
        block7: {
            if (x == null) {
                throw new NullPointerException("id ressource null");
            }
            if (x.id == null) {
                RessourceEditorFactory.open(x);
            } else {
                XRessourceCriteria container = new XRessourceCriteria();
                container.id = x.id;
                JobCallback callback = null;
                try {
                    callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                        public void responseReceived(ReturnObject response) {
                            List lst = (List)response.getObj();
                            if (lst != null && lst.size() == 1) {
                                RessourceEditorFactory.open((XRessource)lst.get(0));
                            }
                        }

                        public void exception(Exception e) {
                            super.exception(e);
                        }
                    };
                    RessourceAccessorClient.getInstance().getRessourceByCriteria(container, Application.get().getGlobalInstances().getSession(), (ICallback)callback);
                }
                catch (CannotConnectToServerException e) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                    throw new ErrorWhileSearchingException((Exception)((Object)e));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                    if (callback == null || callback.killed()) break block7;
                    callback.kill();
                }
            }
        }
    }

    protected static void open(XRessource ress) {
        if (ress == null) {
            throw new NullPointerException("ressource");
        }
        RessourceEditorFactory.open((IEditorInput)new EditorInput((IDataObject)ress));
    }

    protected static void open(final IEditorInput input) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IEditorPart editor = null;
                    editor = BaseEditor.openEditor((IEditorInput)input, (String)RessourceEditor.class.getName());
                    BaseEditor.setActiveEditor((IEditorPart)editor);
                }
                catch (PartInitException e) {
                    logger.log(Level.SEVERE, "Erreur", e);
                    e.printStackTrace();
                }
            }
        });
    }
}

