/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceUnit;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.ressource.RessourceDefDataFormatter;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocaleProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;

public final class BillingRessourceFormatter {
    private BillingRessourceFormatter() {
        throw new UnsupportedOperationException();
    }

    public static String formatDatetime(XBillingRessource billingRessource) {
        Long start = billingRessource.getDateTimeStart();
        Long end = billingRessource.getDateTimeEnd();
        Long expEnd = billingRessource.getDateTimeExpectedEnd();
        String formattedStart = DateUtil.format((Long)start, (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
        String formattedEnd = "";
        if (end != null) {
            formattedEnd = " - " + DateUtil.format((Long)end, (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
        }
        String formattedExpEnd = "";
        if (expEnd != null) {
            formattedExpEnd = " (" + DateUtil.format((Long)expEnd, (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")) + ")";
        }
        return String.valueOf(formattedStart) + formattedEnd + formattedExpEnd;
    }

    public static String format(XBillingRessource x, boolean includeStart, boolean includeEnd, boolean includeExpEnd, boolean includeNbOrdered, boolean includeAutoRepeat, boolean includeDateBilled, boolean includePatient, boolean includeProfessional, boolean includeSecteur, boolean includeBillingRessData) {
        XBaseProfessionnal prof;
        if (x == null) {
            return "";
        }
        XRessourceDefData r = x.getRessourceDefData();
        ArrayList<String> list = new ArrayList<String>(5);
        if (Platform.inDebugMode()) {
            list.add("id=" + x.getId());
        }
        list.add(DateUtil.format((Long)x.getDateTimeStart(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")));
        String code = "";
        if (StringUtils.isNotEmpty((String)r.getRessourceDef().getRessource().getCode())) {
            code = " (" + r.getRessourceDef().getRessource().getCode() + ")";
        }
        String langue = LocaleProvider.getLocale().getLanguage();
        String name = String.valueOf(r.getName(langue)) + " " + r.getRessourceDef().getName(langue) + code;
        list.add(name);
        if (!XRessourceUnit.ITEM.equals((Object)r.getUnit()) && x.getIdProfessionnalAnchor() != null && (prof = PersonUiPlugin.getDefault().getBaseProfessionnal(x.getIdProfessionnalAnchor())) != null) {
            list.add(prof.getName());
        }
        return StringUtils.join(list, (String)", ");
    }

    public static String format(XBillingRessource x) {
        XBaseProfessionnal prof;
        XRessourceDefData r = x.getRessourceDefData();
        ArrayList<String> list = new ArrayList<String>(5);
        if (Platform.inDebugMode()) {
            list.add("id=" + x.getId());
        }
        list.add(DateUtil.format((Long)x.getDateTimeStart(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm")));
        String langue = LocaleProvider.getLocale().getLanguage();
        String name = String.valueOf(r.getName(langue)) + " " + r.getRessourceDef().getName(langue);
        list.add(name);
        if (!XRessourceUnit.ITEM.equals((Object)r.getUnit()) && x.getIdProfessionnalAnchor() != null && (prof = PersonUiPlugin.getDefault().getBaseProfessionnal(x.getIdProfessionnalAnchor())) != null) {
            list.add(prof.getName());
        }
        list.add("[" + RessourceDefDataFormatter.format(x.ressourceDefData) + "]");
        return StringUtils.join(list, (String)", ");
    }
}

