/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDef;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceStatus;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceUnit;
import ca.infodata.ofys.data.middle.dataobjects.service.XSecteur;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.ressource.BaseViewerComposite;
import ca.infodata.ofys.ui.ressource.MyViewerComparator;
import ca.infodata.ofys.ui.ressource.RessourceEditor;
import ca.infodata.ofys.ui.ressource.RessourcePlugin;
import ca.infodata.ofys.ui.ressource.cellediting.ComboBoxEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.NumberEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.StringEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.TaskEditingSupport;
import ca.infodata.util1.date.LocaleProvider;
import java.math.BigDecimal;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseRessourceDefDataControl
extends BaseViewerComposite {
    private static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    public IEditableDataObjectList<XRessourceDefData> lstRessourceDefData;
    public XRessource ressource;
    public XRessourceDef ressourceDef;
    protected Button btnAddItem;
    protected Button btnFilter;
    protected String szErrors;
    private RessourceEditor parentEditor;
    final String langue = LocaleProvider.getLocale().getDisplayLanguage().toLowerCase().substring(0, 2);

    public BaseRessourceDefDataControl(Composite parent, RessourceEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.createMyControl(this, toolkit);
        this.comparator = new MyViewerComparator(){

            @Override
            public int compare(Viewer viewer, Object p1, Object p2) {
                XRessourceDefData x1 = (XRessourceDefData)p1;
                XRessourceDefData x2 = (XRessourceDefData)p2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        rc = 0;
                        break;
                    }
                    case 1: {
                        if (x1.getSecteur() == null && x2.getSecteur() == null) {
                            rc = 0;
                            break;
                        }
                        if (x1.getSecteur() == null) {
                            rc = -1;
                            break;
                        }
                        if (x2.getSecteur() == null) {
                            rc = 1;
                            break;
                        }
                        rc = x1.getSecteur().getName(BaseRessourceDefDataControl.this.langue).compareTo(x2.getSecteur().getName(BaseRessourceDefDataControl.this.langue));
                        break;
                    }
                    case 2: {
                        if (x1.getProfessionnal() == null && x2.getProfessionnal() == null) {
                            rc = 0;
                            break;
                        }
                        if (x1.getProfessionnal() == null) {
                            rc = -1;
                            break;
                        }
                        if (x2.getProfessionnal() == null) {
                            rc = 1;
                            break;
                        }
                        rc = x1.getProfessionnal().getName().compareTo(x2.getProfessionnal().getName());
                        break;
                    }
                    case 3: {
                        rc = x1.getNameFr().compareTo(x2.getNameFr());
                        break;
                    }
                    case 4: {
                        rc = x1.getNameEn().compareTo(x2.getNameEn());
                        break;
                    }
                    case 5: {
                        if (x1.getStatus() == null && x2.getStatus() == null) {
                            rc = 0;
                            break;
                        }
                        if (x1.getStatus() == null) {
                            rc = -1;
                            break;
                        }
                        if (x2.getStatus() == null) {
                            rc = 1;
                            break;
                        }
                        rc = x1.getStatus().toString().compareTo(x2.getStatus().toString());
                        break;
                    }
                    case 6: {
                        if (x1.getRecycleTime() == null && x2.getRecycleTime() == null) {
                            rc = 0;
                            break;
                        }
                        if (x1.getRecycleTime() == null) {
                            rc = -1;
                            break;
                        }
                        if (x2.getRecycleTime() == null) {
                            rc = 1;
                            break;
                        }
                        rc = x1.getRecycleTime().compareTo(x2.getRecycleTime());
                        break;
                    }
                    case 7: {
                        rc = x1.getPrixBaseInitial().compareTo(x2.getPrixBaseInitial());
                        break;
                    }
                    case 8: {
                        if (x1.getUnit() == null && x2.getUnit() == null) {
                            rc = 0;
                            break;
                        }
                        if (x1.getUnit() == null) {
                            rc = -1;
                            break;
                        }
                        if (x2.getUnit() == null) {
                            rc = 1;
                            break;
                        }
                        rc = x1.getUnit().toString().compareTo(x2.getUnit().toString());
                        break;
                    }
                    case 9: {
                        rc = x1.getPrixParUnit().compareTo(x2.getPrixParUnit());
                        break;
                    }
                    case 10: {
                        rc = x1.getEscompteMax().compareTo(x2.getEscompteMax());
                        break;
                    }
                    default: {
                        rc = 0;
                    }
                }
                if (this.direction == 1) {
                    rc = -rc;
                }
                return rc;
            }
        };
        this.viewer.setComparator((ViewerComparator)this.comparator);
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.btnAddItem = new Button(parent, 0x1000008);
        int btnW = 45;
        if (UI.OS_WINDOWS) {
            btnW = 35;
            this.btnAddItem.setText("+");
        } else {
            this.btnAddItem.setText("\u2795");
        }
        this.btnFilter = new Button(parent, 2);
        this.btnFilter.setText("F");
        this.btnFilter.setSelection(true);
        this.btnFilter.setToolTipText(Messages.getString((String)"FILTER_TTT", (String[])new String[0]));
        this.viewer = new TableViewer(parent, 68354){

            public void add(Object element) {
                XRessourceDefData xd = (XRessourceDefData)element;
                xd.setRessourceDef(BaseRessourceDefDataControl.this.getRessourceDef());
                this.add(new Object[]{xd});
                BaseRessourceDefDataControl.this.getRessourceDef().lstRessourceDefData.add((IMinimalEditableDataObject)xd);
                BaseRessourceDefDataControl.this.getParentEditor().checkDirty();
                BaseRessourceDefDataControl.this.viewer.getTable().setFocus();
                BaseRessourceDefDataControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)xd));
                BaseRessourceDefDataControl.this.viewer.editElement((Object)xd, 1);
            }
        };
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.addFilter((ViewerFilter)this.getParentEditor().getHideDeletedItems());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn tcB = new TableViewerColumn(this.viewer, 0);
        tcB.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tcB.getColumn(), 0));
        tcB.getColumn().setWidth(50);
        tcB.getColumn().setText(STATUS);
        tcB.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                if (p.getModificationStatus() == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(p.getIsDeleted())) {
                    return ResourceGetter.getImage((String)"images/inactive.png");
                }
                return ResourceGetter.getImage((String)"images/icon-active.gif");
            }
        });
        tcB.setEditingSupport((EditingSupport)new TaskEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), toolkit, 0));
        TableViewerColumn tcS = new TableViewerColumn(this.viewer, 0);
        tcS.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tcS.getColumn(), 1));
        tcS.getColumn().setWidth(80);
        tcS.getColumn().setText(Messages.getString((String)"SECTEUR", (String[])new String[0]));
        tcS.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                if (p.getSecteur() != null) {
                    return p.getSecteur().getName(BaseRessourceDefDataControl.this.langue);
                }
                return "";
            }
        });
        tcS.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getSecteur", "setSecteur", XSecteur.class, RessourcePlugin.getDefault().getSecteurs().toArray(), null, 0));
        TableViewerColumn tcP = new TableViewerColumn(this.viewer, 0);
        tcP.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tcP.getColumn(), 2));
        tcP.getColumn().setWidth(120);
        tcP.getColumn().setText(Messages.getString((String)"DISPENSATEUR", (String[])new String[0]));
        tcP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                if (p.getIdProfessionnalAnchor() != null) {
                    XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(p.getIdProfessionnalAnchor());
                    return prof == null ? "" : prof.getName();
                }
                return "";
            }
        });
        LabelProvider labelProviderProf = new LabelProvider(){

            public String getText(Object element) {
                if (element != null) {
                    XBaseProfessionnal prof = (XBaseProfessionnal)element;
                    return prof == null ? "" : prof.getName();
                }
                return "";
            }
        };
        tcP.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getProfessionnal", "setProfessionnal", XBaseProfessionnal.class, PersonUiPlugin.getDefault().getTreatingProfessionnals().toArray(), labelProviderProf, 0));
        TableViewerColumn tc0 = new TableViewerColumn(this.viewer, 0);
        tc0.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc0.getColumn(), 3));
        tc0.getColumn().setWidth(120);
        tc0.getColumn().setText(String.valueOf(Messages.getString((String)"NOM", (String[])new String[0])) + " " + Messages.getString((String)"FRANCAIS", (String[])new String[0]).toLowerCase());
        tc0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getNameFr();
            }
        });
        tc0.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNameFr", "setNameFr", 0));
        TableViewerColumn tc1 = new TableViewerColumn(this.viewer, 0);
        tc1.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc1.getColumn(), 4));
        tc1.getColumn().setWidth(120);
        tc1.getColumn().setText(String.valueOf(Messages.getString((String)"NOM", (String[])new String[0])) + " " + Messages.getString((String)"ANGLAIS", (String[])new String[0]).toLowerCase());
        tc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getNameEn();
            }
        });
        tc1.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNameEn", "setNameEn", 0));
        TableViewerColumn tc2 = new TableViewerColumn(this.viewer, 0);
        tc2.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc2.getColumn(), 5));
        tc2.getColumn().setWidth(90);
        tc2.getColumn().setText("Statut");
        tc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData q = (XRessourceDefData)element;
                if (q.getStatus() != null) {
                    return q.getStatus().toString();
                }
                return "";
            }
        });
        tc2.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getStatus", "setStatus", XRessourceStatus.class, XRessourceStatus.values(), null, 0));
        TableViewerColumn tc8 = new TableViewerColumn(this.viewer, 0);
        tc8.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc8.getColumn(), 6));
        tc8.getColumn().setWidth(60);
        tc8.getColumn().setText("RECYCL.");
        tc8.getColumn().setToolTipText("Temps (minutes) requis pour rendre cette ressource disponible apr\u00e8s usage");
        tc8.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getRecycleTime().toString();
            }
        });
        tc8.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getRecycleTime", "setRecycleTime", Integer.class, 0));
        TableViewerColumn tc6 = new TableViewerColumn(this.viewer, 0);
        tc6.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc6.getColumn(), 7));
        tc6.getColumn().setWidth(70);
        tc6.getColumn().setAlignment(131072);
        tc6.getColumn().setText("PRIX BASE");
        tc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getPrixBaseInitial().toString();
            }
        });
        tc6.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getPrixBaseInitial", "setPrixBaseInitial", BigDecimal.class, 0));
        TableViewerColumn tc4 = new TableViewerColumn(this.viewer, 0);
        tc4.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc4.getColumn(), 8));
        tc4.getColumn().setWidth(60);
        tc4.getColumn().setText("UNIT");
        tc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                if (p.getUnit() != null) {
                    return p.getUnit().toString();
                }
                return "";
            }
        });
        tc4.setEditingSupport((EditingSupport)new ComboBoxEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getUnit", "setUnit", XRessourceUnit.class, XRessourceUnit.values(), null, 0));
        TableViewerColumn tc5 = new TableViewerColumn(this.viewer, 0);
        tc5.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc5.getColumn(), 9));
        tc5.getColumn().setWidth(70);
        tc5.getColumn().setAlignment(131072);
        tc5.getColumn().setText("PRIX/UNIT");
        tc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getPrixParUnit().toString();
            }
        });
        tc5.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getPrixParUnit", "setPrixParUnit", BigDecimal.class, 0));
        TableViewerColumn tc7 = new TableViewerColumn(this.viewer, 0);
        tc7.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tc7.getColumn(), 10));
        tc7.getColumn().setWidth(70);
        tc7.getColumn().setAlignment(131072);
        tc7.getColumn().setText("ESC. MAX");
        tc7.getColumn().setToolTipText("Rabais maximal autoris\u00e9 (par exemple, mettre 0.1 pour 10%)");
        tc7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XRessourceDefData p = (XRessourceDefData)element;
                return p.getEscompteMax().toString();
            }
        });
        tc7.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getEscompteMax", "setEscompteMax", BigDecimal.class, 0));
        parent.setFocus();
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)30);
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseRessourceDefDataControl.this.getRessourceDef() != null) {
                    XRessourceDefData newDef = new XRessourceDefData();
                    newDef.initialize();
                    BaseRessourceDefDataControl.this.viewer.add((Object)newDef);
                }
            }
        });
        this.btnFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    BaseRessourceDefDataControl.this.viewer.addFilter((ViewerFilter)BaseRessourceDefDataControl.this.getParentEditor().getHideDeletedItems());
                } else {
                    BaseRessourceDefDataControl.this.viewer.removeFilter((ViewerFilter)BaseRessourceDefDataControl.this.getParentEditor().getHideDeletedItems());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BaseRessourceDefDataControl.this.viewer.getSelection();
                XRessourceDefData firstElement = (XRessourceDefData)selection.getFirstElement();
                System.out.println("selectionChanged: " + firstElement);
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnAddItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAddItem);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnFilter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.btnAddItem);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.viewer.getTable().setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
    }

    public void updateViewerInput(IEditableDataObjectList<XRessourceDefData> def) {
        System.out.println("updateViewerInput 1");
        if (def != null) {
            for (XRessourceDefData xRessourceDefData : def) {
                xRessourceDefData.professionnal = xRessourceDefData.idProfessionnalAnchor != null ? PersonUiPlugin.getDefault().getBaseProfessionnal(xRessourceDefData.idProfessionnalAnchor) : null;
            }
            Object[] aa = def.toArray();
            this.viewer.setInput((Object)aa);
        } else {
            this.viewer.setInput(null);
        }
        this.setLstRessourceDefData(def);
        if (def != null && def.size() > 0) {
            Timer t = new Timer();
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).BaseRessourceDefDataControl.this.viewer.setSelection((ISelection)new StructuredSelection((this).BaseRessourceDefDataControl.this.viewer.getElementAt(0)), true);
                        }
                    });
                }
            };
            t.schedule(tt, 100L);
        }
    }

    public RessourceEditor getParentEditor() {
        return this.parentEditor;
    }

    public final IEditableDataObjectList<XRessourceDefData> getLstRessourceDefData() {
        return this.lstRessourceDefData;
    }

    public final void setLstRessourceDefData(IEditableDataObjectList<XRessourceDefData> lstRessourceDef) {
        this.lstRessourceDefData = lstRessourceDef;
    }

    public final XRessource getRessource() {
        return this.ressource;
    }

    public final void setRessource(XRessource ressource) {
        this.ressource = ressource;
    }

    public final XRessourceDef getRessourceDef() {
        return this.ressourceDef;
    }

    public final void setRessourceDef(XRessourceDef ressource) {
        this.ressourceDef = ressource;
        this.showCurrent();
    }

    public abstract void showCurrent();
}

