/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.ressource;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessourceData;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessourceDataTaxe;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.ressource.FakeEditor;
import ca.infodata.ofys.ui.ressource.cellediting.NumberEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.StringEditingSupport;
import ca.infodata.ofys.ui.ressource.cellediting.TaskEditingSupport;
import ca.infodata.ofys.ui.ressource.editor.BillingRessourceController;
import ca.infodata.util1.date.DateUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseBillingRessourceDataControl
extends Composite {
    private static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    public IEditableDataObjectList<XBillingRessourceData> lstBillingRessourceData;
    public XBillingRessource billingRessource;
    protected Button btnAddItem;
    protected Button btnFilter;
    private TableViewer viewer;
    protected String szErrors;
    private FakeEditor parentEditor;
    private BillingRessourceController controller;

    public BaseBillingRessourceDataControl(Composite parent, FakeEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.createMyControl(this, toolkit);
    }

    public void createMyControl(Composite parent, FormToolkit toolkit) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.btnAddItem = new Button(parent, 0x1000008);
        int btnW = 45;
        if (UI.OS_WINDOWS) {
            btnW = 35;
            this.btnAddItem.setText("+");
        } else {
            this.btnAddItem.setText("\u2795");
        }
        this.btnFilter = new Button(parent, 2);
        this.btnFilter.setText("F");
        this.btnFilter.setSelection(true);
        this.btnFilter.setToolTipText(Messages.getString((String)"FILTER_TTT", (String[])new String[0]));
        this.viewer = new TableViewer(parent, 68354){

            public void add(Object element) {
                XBillingRessourceData xd = (XBillingRessourceData)element;
                Long now = DateUtil.now();
                xd.setCreatedDatetime(now);
                xd.setBillingRessource(BaseBillingRessourceDataControl.this.getBillingRessource());
                xd.setNote("");
                for (XBillingRessourceDataTaxe xtdd : xd.billingRessourceDataTaxes) {
                    xtdd.setCreatedDatetime(now);
                }
                this.add(new Object[]{xd});
                BaseBillingRessourceDataControl.this.getBillingRessource().billingRessourceDatas.add((IMinimalEditableDataObject)xd);
                BaseBillingRessourceDataControl.this.getParentEditor().checkDirty();
                BaseBillingRessourceDataControl.this.viewer.getTable().setFocus();
                BaseBillingRessourceDataControl.this.viewer.setSelection((ISelection)new StructuredSelection((Object)xd));
                BaseBillingRessourceDataControl.this.viewer.editElement((Object)xd, 1);
            }

            public void update(Object element, String[] properties) {
                super.update(element, properties);
            }
        };
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.addFilter((ViewerFilter)this.getParentEditor().getHideDeletedItems());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                XBillingRessourceData e1 = (XBillingRessourceData)o1;
                XBillingRessourceData e2 = (XBillingRessourceData)o2;
                int s = e2.getCreatedDatetime().compareTo(e1.getCreatedDatetime());
                return s;
            }
        });
        TableViewerColumn tcStatus = new TableViewerColumn(this.viewer, 0);
        tcStatus.getColumn().setWidth(60);
        tcStatus.getColumn().setText(STATUS);
        tcStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                XBillingRessourceData p = (XBillingRessourceData)element;
                if (p.getModificationStatus() == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(p.getIsDeleted())) {
                    return ResourceGetter.getImage((String)"images/inactive.png");
                }
                return ResourceGetter.getImage((String)"images/icon-active.gif");
            }
        });
        tcStatus.setEditingSupport((EditingSupport)new TaskEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), toolkit, 0){

            @Override
            protected boolean canEdit(Object element) {
                if (BaseBillingRessourceDataControl.this.getBillingRessource().getBilledRessource() == null) {
                    return super.canEdit(element);
                }
                return false;
            }
        });
        TableViewerColumn tc2 = new TableViewerColumn(this.viewer, 0);
        tc2.getColumn().setWidth(130);
        tc2.getColumn().setText(Messages.getString((String)"DATE", (String[])new String[0]));
        tc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBillingRessourceData p = (XBillingRessourceData)element;
                String formattedCreatedDate = DateUtil.format((Long)p.getCreatedDatetime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"));
                return formattedCreatedDate;
            }
        });
        tc2.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getCreatedDatetime", null, Long.class, 0));
        TableViewerColumn tc6 = new TableViewerColumn(this.viewer, 0);
        tc6.getColumn().setWidth(70);
        tc6.getColumn().setAlignment(131072);
        tc6.getColumn().setText(Messages.getString((String)"PRIX", (String[])new String[0]));
        tc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBillingRessourceData p = (XBillingRessourceData)element;
                return p.getPrix().toString();
            }
        });
        tc6.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getPrix", "setPrix", BigDecimal.class, 0){

            @Override
            protected boolean canEdit(Object element) {
                if (BaseBillingRessourceDataControl.this.getBillingRessource().getBilledRessource() == null && BigDecimal.ZERO.compareTo(BaseBillingRessourceDataControl.this.getBillingRessource().getRessourceDefData().getPrixParUnit()) == 0) {
                    return super.canEdit(element);
                }
                return false;
            }
        });
        TableViewerColumn tcEscompte = new TableViewerColumn(this.viewer, 0);
        tcEscompte.getColumn().setWidth(70);
        tcEscompte.getColumn().setAlignment(131072);
        tcEscompte.getColumn().setText(Messages.getString((String)"ESCOMPTE", (String[])new String[0]));
        tcEscompte.getColumn().setToolTipText(Messages.getString((String)"RABAIS_AUTORISE", (String[])new String[0]));
        tcEscompte.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBillingRessourceData p = (XBillingRessourceData)element;
                return p.getEscompte().toString();
            }
        });
        tcEscompte.setEditingSupport((EditingSupport)new NumberEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getEscompte", "setEscompte", BigDecimal.class, 0){

            @Override
            protected boolean canEdit(Object element) {
                if (BaseBillingRessourceDataControl.this.getBillingRessource().getBilledRessource() == null) {
                    return super.canEdit(element);
                }
                return false;
            }

            @Override
            protected void setValue(Object element, Object v) {
                BigDecimal c = null;
                if (v != null && v instanceof String) {
                    String s = (String)v;
                    try {
                        BigDecimal b = BigDecimal.valueOf(Double.valueOf(s));
                        c = b.min(BaseBillingRessourceDataControl.this.getBillingRessource().getRessourceDefData().getEscompteMax());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                super.setValue(element, c == null ? null : c.toString());
            }
        });
        TableViewerColumn tcNote = new TableViewerColumn(this.viewer, 0);
        tcNote.getColumn().setWidth(200);
        tcNote.getColumn().setText(Messages.getString((String)"NOTE", (String[])new String[0]));
        tcNote.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBillingRessourceData p = (XBillingRessourceData)element;
                return p.getNote();
            }
        });
        tcNote.setEditingSupport((EditingSupport)new StringEditingSupport(this.viewer, (IBaseEditor)this.getParentEditor(), "getNote", "setNote", 1));
        parent.setFocus();
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)30);
        this.btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseBillingRessourceDataControl.this.getBillingRessource() != null && BaseBillingRessourceDataControl.this.getBillingRessource().getBilledRessource() == null) {
                    XBillingRessource x = BaseBillingRessourceDataControl.this.getBillingRessource();
                    XRessourceDefData rdd = x.getRessourceDefData();
                    Long startTime = DateUtil.now();
                    long duree = rdd.getUnit().getDureeInMs();
                    if (duree > 0L && !x.billingRessourceDatas.isEmpty()) {
                        IEditableDataObjectList lstBRD = x.billingRessourceDatas;
                        Collections.sort(lstBRD, new Comparator<XBillingRessourceData>(){

                            @Override
                            public int compare(XBillingRessourceData a0, XBillingRessourceData a1) {
                                return a1.createdDatetime.compareTo(a0.createdDatetime);
                            }
                        });
                        startTime = ((XBillingRessourceData)lstBRD.get((int)0)).createdDatetime + duree;
                    }
                    XBillingRessourceData xd = new XBillingRessourceData();
                    xd.setCreatedDatetime(startTime);
                    xd.setBillingRessource(x);
                    xd.setEscompte(new BigDecimal(0));
                    xd.setPrix(rdd.getPrixBaseInitial().add(rdd.getPrixParUnit()));
                    xd.setNew();
                    BaseBillingRessourceDataControl.this.viewer.add((Object)xd);
                }
            }
        });
        this.btnFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    BaseBillingRessourceDataControl.this.viewer.addFilter((ViewerFilter)BaseBillingRessourceDataControl.this.getParentEditor().getHideDeletedItems());
                } else {
                    BaseBillingRessourceDataControl.this.viewer.removeFilter((ViewerFilter)BaseBillingRessourceDataControl.this.getParentEditor().getHideDeletedItems());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BaseBillingRessourceDataControl.this.viewer.getSelection();
                XBillingRessourceData firstElement = (XBillingRessourceData)selection.getFirstElement();
                System.out.println("selectionChanged: " + firstElement);
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnAddItem.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAddItem);
        data.left = new FormAttachment(0);
        data.width = btnW;
        this.btnFilter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.btnAddItem);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.viewer.getTable().setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
    }

    public final BillingRessourceController getController() {
        return this.controller;
    }

    public void setController(BillingRessourceController controller) {
        this.controller = controller;
    }

    public void updateViewerInput(IEditableDataObjectList<XBillingRessourceData> def) {
        if (def != null) {
            Object[] aa = def.toArray();
            this.viewer.setInput((Object)aa);
        } else {
            this.viewer.setInput(null);
        }
        this.setLstBillingRessourceData(def);
        boolean canEdit = this.getBillingRessource() != null && this.getBillingRessource().getBilledRessource() == null;
        this.btnAddItem.setEnabled(canEdit);
    }

    public FakeEditor getParentEditor() {
        return this.parentEditor;
    }

    public final IEditableDataObjectList<XBillingRessourceData> getLstBillingRessourceData() {
        return this.lstBillingRessourceData;
    }

    public final void setLstBillingRessourceData(IEditableDataObjectList<XBillingRessourceData> lstBillingRessourceData) {
        this.lstBillingRessourceData = lstBillingRessourceData;
    }

    public final XBillingRessource getBillingRessource() {
        return this.billingRessource;
    }

    public final void setBillingRessource(XBillingRessource ressource) {
        this.billingRessource = ressource;
        this.showCurrent();
    }

    public abstract void showCurrent();
}

