/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.weblink;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XWebLink;
import ca.infodata.ofys.data.middle.dataobjects.XWebLinkContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WebLinkEditor
extends BaseEditor
implements ISaveablePart,
ICancelablePart {
    private static final String AVERTISEMENT = Messages.getString((String)"WebLinkEditor.AVERTISEMENT", (String[])new String[0]);
    private static final String LES_SITES_INTERNET_DE_CETTE_PAGE_NONT_PAS_ETE_CREES_PAR_LOGITIELS_INFODATA = Messages.getString((String)"WebLinkEditor.LES_SITES_INTERNET_DE_CETTE_PAGE_NONT_PAS_ETE_CREES_PAR_LOGITIELS_INFODATA", (String[])new String[0]);
    private static final String _NOUS_NE_GARANTISSONS_DONC_PAS_LA_QUALITE_ET_LA_FONCTIONNALITE_DE_CEUXCI = Messages.getString((String)"WebLinkEditor._NOUS_NE_GARANTISSONS_DONC_PAS_LA_QUALITE_ET_LA_FONCTIONNALITE_DE_CEUXCI", (String[])new String[0]);
    private static final String AUCUN_SITE_PRESENTEMENT = Messages.getString((String)"WebLinkEditor.AUCUN_SITE_PRESENTEMENT", (String[])new String[0]);
    private static final int rightBtn = LibPlugin.ON_MAC ? 42 : 32;
    private static final int heightBtn = LibPlugin.ON_MAC ? 30 : 24;
    private FontAwareGroup group;
    private Composite parent;
    private MyText txtWebLinkDescr;
    private MyText txtWebLinkUrl;
    private Control baseControl;
    private List<Item> items = new ArrayList<Item>();
    private Image earth;
    private Image addImage;
    private Image delImage;
    private MyLabel lblWarning;

    public void createMyControl(Composite parent) {
        this.parent = parent;
        this.earth = ResourceGetter.getImage((String)"images/Internet-Real-icon32.png");
        ResourceGetter.linkResourceWithWidgetLife((Object)this.earth, (Widget)this.getCompMain());
        this.addImage = ResourceGetter.getImage((String)"images/ajouter_decorator.gif");
        ResourceGetter.linkResourceWithWidgetLife((Object)this.addImage, (Widget)this.getCompMain());
        this.delImage = ResourceGetter.getImage((String)"images/delete_edit.gif");
        ResourceGetter.linkResourceWithWidgetLife((Object)this.delImage, (Widget)this.getCompMain());
        this.setTitleImage(this.earth);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.group = new FontAwareGroup(parent, 0, this.toolkit);
        this.group.setText(AVERTISEMENT);
        this.group.setLayout((Layout)layout);
        this.lblWarning = new MyLabel((Composite)this.group, String.valueOf(LES_SITES_INTERNET_DE_CETTE_PAGE_NONT_PAS_ETE_CREES_PAR_LOGITIELS_INFODATA) + _NOUS_NE_GARANTISSONS_DONC_PAS_LA_QUALITE_ET_LA_FONCTIONNALITE_DE_CEUXCI, 64, this.toolkit);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.group.setLayoutData((Object)data);
        this.lblWarning.setLayoutData((Object)data);
        this.createLink();
    }

    private void createLink() {
        Button btnAddWebLink = new Button(this.parent, 8);
        btnAddWebLink.setImage(this.addImage);
        this.txtWebLinkUrl = new MyText(this.parent, this.toolkit);
        this.txtWebLinkUrl.setTextLimit(1024);
        this.txtWebLinkUrl.setText("http://www.");
        this.txtWebLinkDescr = new MyText(this.parent, this.toolkit);
        this.txtWebLinkDescr.setTextLimit(100);
        btnAddWebLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XWebLinkContainer container = WebLinkEditor.this.getWebLinkContainer();
                if (container != null && !StringUtils.isBlank((CharSequence)WebLinkEditor.this.txtWebLinkUrl.getText())) {
                    XWebLink link = new XWebLink();
                    link.setDescription(WebLinkEditor.this.txtWebLinkDescr.getText());
                    link.setUrl(WebLinkEditor.this.txtWebLinkUrl.getText());
                    container.getWebLinks().add((IMinimalEditableDataObject)link);
                    WebLinkEditor.this.checkDirty();
                    WebLinkEditor.this.addWebLinksItem(link);
                    WebLinkEditor.this.reflow();
                    WebLinkEditor.this.txtWebLinkDescr.setText("");
                    WebLinkEditor.this.txtWebLinkUrl.setText("http://www.");
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.group, UI.getAjustedPosition());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(0, rightBtn);
        data.height = heightBtn;
        btnAddWebLink.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.group, 2);
        data.left = new FormAttachment((Control)btnAddWebLink, 3);
        data.right = new FormAttachment(60);
        this.txtWebLinkUrl.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.group, 2);
        data.left = new FormAttachment(this.txtWebLinkUrl.getControl(), 2);
        data.right = new FormAttachment(100);
        this.txtWebLinkDescr.setLayoutData((Object)data);
        this.baseControl = this.txtWebLinkUrl.getControl();
    }

    public void showDataObject() {
        this.baseControl = this.txtWebLinkUrl.getControl();
        for (Item item : this.items) {
            item.dispose();
        }
        this.items.clear();
        XWebLinkContainer container = this.getWebLinkContainer();
        if (container == null || container.getWebLinks().isEmpty()) {
            this.lblWarning = new MyLabel(this.parent, AUCUN_SITE_PRESENTEMENT, 0, this.toolkit);
        } else {
            for (XWebLink webLink : container.getWebLinks()) {
                this.addWebLinksItem(webLink);
            }
        }
        this.reflow();
    }

    private void addWebLinksItem(final XWebLink link) {
        final Item item = new Item(this.parent, this.toolkit, link);
        item.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                link.setDeleted();
                WebLinkEditor.this.checkDirty();
                item.setVisible(false);
                WebLinkEditor.this.reflow();
            }
        });
        item.hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)e.getHref().toString());
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(this.baseControl, UI.getAjustedPosition());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        item.setLayoutData(data);
        this.items.add(item);
        this.baseControl = item;
    }

    public String getEditorTitle() {
        return Messages.getString((String)"LIENS_INTERNET", (String[])new String[0]);
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/Internet-Real-icon32.png");
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PreferencesAccessorClient.getInstance();
    }

    public void initDataOverride() {
        block4: {
            JobCallback callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WebLinkEditor.this.initializeCompleteDataObject((EditableDataObject)((XWebLinkContainer)response.getObj()));
                        }
                    });
                }
            };
            try {
                PreferencesAccessorClient.getInstance().getWebLinks(Application.get().getGlobalInstances().getSession(), (ICallback)callback);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    public boolean isDataDirty() {
        XWebLinkContainer container = this.getWebLinkContainer();
        return container != null && container.isDirty();
    }

    public void setToolBarStatus() {
    }

    public XWebLinkContainer getWebLinkContainer() {
        return (XWebLinkContainer)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    private void reflow() {
        Composite c = this.getCompMain();
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this.getCompMain(); c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = this.getCompMain();
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    private class Item
    extends Composite {
        final Button button;
        final Label label;
        final Hyperlink hyperlink;

        public Item(Composite parent, FormToolkit toolkit, XWebLink link) {
            super(parent, 0);
            toolkit.adapt((Composite)this);
            this.button = new Button((Composite)this, 8);
            this.button.setImage(WebLinkEditor.this.delImage);
            if (link.getId() != null && link.getClientId() == null) {
                this.button.setEnabled(false);
            }
            this.hyperlink = toolkit.createHyperlink((Composite)this, Application.get().getGlobalInstances().inDebugMode() ? link.getId() + " " + link.getUrl() : link.getUrl(), 0);
            this.hyperlink.setHref((Object)link.getUrl());
            this.hyperlink.setToolTipText(link.getUrl());
            this.label = toolkit.createLabel((Composite)this, link.getDescription(), 16384);
            this.setLayout((Layout)new FormLayout());
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(0, rightBtn);
            data.height = heightBtn;
            this.button.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0, 2);
            data.left = new FormAttachment((Control)this.button, 3);
            data.right = new FormAttachment(60);
            this.hyperlink.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0, 2);
            data.left = new FormAttachment((Control)this.hyperlink, 2);
            data.right = new FormAttachment(100);
            this.label.setLayoutData((Object)data);
        }
    }
}

