/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.StringUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class MVProps {
    private static final Logger logger = Logger.getLogger(MVProps.class.getName());
    public static final Map<String, ConcurrentMap<String, Object>> mapStore = new HashMap<String, ConcurrentMap<String, Object>>(MAPS.values().length);
    private static Map<String, Object> dv = new HashMap<String, Object>();
    private GlobalInstancesAdapter globalInstancesListener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            if (MVProps.this.store == null) {
                MVProps.this.createStore();
            }
        }

        public void logout() {
            MVProps.this.closeStore();
        }
    };
    private MVStore store = null;
    ConcurrentMap<String, ConcurrentMap<String, Object>> memMap = null;

    static {
        dv.put("", Boolean.TRUE);
        dv.put("eventByDate", new Integer(0));
        dv.put("nbEvents", new Integer(5));
        dv.put("periodShown", new Double(2.0));
        dv.put("showDeletedForm", Boolean.FALSE);
        dv.put("docShowLab", Boolean.TRUE);
        dv.put("docShowDoc", Boolean.TRUE);
        dv.put("docToSee", Boolean.TRUE);
        dv.put("docToResolve", Boolean.FALSE);
        dv.put("superviseurId", Integer.MIN_VALUE);
        dv.put("filterFormAnd", Boolean.TRUE);
        dv.put("filterFormTerms", "");
        dv.put("ptedit_language", Boolean.TRUE);
        dv.put("ptedit_dob", Boolean.TRUE);
        dv.put("ptedit_numerised", Boolean.TRUE);
        dv.put("ptedit_sensible", Boolean.TRUE);
        dv.put("ptedit_sofy", Boolean.TRUE);
        dv.put("ptedit_lastVerif", Boolean.TRUE);
        dv.put("ptedit_lastActivity", Boolean.TRUE);
        dv.put("ptedit_professional", Boolean.TRUE);
        dv.put("ptedit_partner", Boolean.TRUE);
        dv.put("ptedit_mother", Boolean.TRUE);
        dv.put("ptedit_father", Boolean.TRUE);
        dv.put("ptedit_tutor", Boolean.TRUE);
        dv.put("ptedit_citizenship", Boolean.TRUE);
        dv.put("ptedit_race", Boolean.TRUE);
        dv.put("ptedit_civil", Boolean.TRUE);
        dv.put("ptedit_appMsg", Boolean.TRUE);
        dv.put("ptedit_childMsg", Boolean.TRUE);
        dv.put("ptedit_address", Boolean.TRUE);
        dv.put("ptedit_contacts", Boolean.TRUE);
        dv.put("ptedit_otherProf", Boolean.TRUE);
        dv.put("ptedit_sites", Boolean.TRUE);
        dv.put("ptedit_ident", Boolean.TRUE);
        dv.put("ptedit_pharma", Boolean.TRUE);
        dv.put("ptedit_alerts", Boolean.TRUE);
        dv.put("ptedit_limitations", Boolean.TRUE);
        dv.put("ptedit_fusion", Boolean.TRUE);
        dv.put("ptedit_note", Boolean.TRUE);
        dv.put("ptedit_inactive", Boolean.TRUE);
        dv.put("ptedit_isdead", Boolean.TRUE);
        dv.put("ptedit_gender", Boolean.TRUE);
        dv.put("ptedit_picture", Boolean.TRUE);
        dv.put("ptedit_popover", Boolean.TRUE);
        dv.put("form_cnesst_lang", "fr");
        dv.put("user_settings_ShowAllLabs", Boolean.FALSE);
        dv.put("user_settings_ShowRecPos", Boolean.FALSE);
        dv.put("user_settings_ShowSuggPos", Boolean.TRUE);
        dv.put("user_settings_AlwaysShowOtherProv", Boolean.FALSE);
        dv.put("user_settings_ShowMoreDemoData", Boolean.TRUE);
        dv.put("user_settings_ShowAllProfsInAppt", Boolean.TRUE);
        dv.put("user_settings_ShowCanceledAppt", Boolean.FALSE);
        dv.put("user_settings_ShowAllProfsInLaboDoc", Boolean.TRUE);
        dv.put("user_settings_ExcludeMySeenLaboDoc", Boolean.TRUE);
        dv.put("user_settings_ShowProfsReplacedInLaboDoc", Boolean.FALSE);
        dv.put("cnesstQuestions", "");
        dv.put("enc_Order", "");
        dv.put("mesure_system", new Integer(1));
        dv.put("et_empty", Boolean.FALSE);
        dv.put("et_SRV", Boolean.FALSE);
        dv.put("et_ordonnances", Boolean.FALSE);
        dv.put("et_telephone", Boolean.FALSE);
        dv.put("et_suiviGrossesse", Boolean.FALSE);
        dv.put("et_cnesst", Boolean.FALSE);
        dv.put("et_suiviAnnuel", Boolean.FALSE);
        dv.put("et_suiviClinique", Boolean.FALSE);
        dv.put("et_suiviDiabete", Boolean.FALSE);
        dv.put("et_suiviDiabeteCap", Boolean.FALSE);
        dv.put("et_glycCap", Boolean.FALSE);
        dv.put("et_suiviINR", Boolean.FALSE);
        dv.put("et_all", Boolean.FALSE);
        dv.put("et_immunization", Boolean.FALSE);
        dv.put("et_raisonNoteConcl", Boolean.FALSE);
        dv.put("fav_tab_active", "fav");
        dv.put("med_rx_times", new Integer(11));
        dv.put("med_rx_defaut", new Integer(11));
        dv.put("list_appt_size", new Integer(1));
        dv.put("list_pat_size", new Integer(1));
        dv.put("list_research_size", new Integer(1));
        dv.put("list_research_option_size", new Integer(1));
        dv.put("user_settings_SearchMdProvNB", Boolean.FALSE);
        dv.put("user_settings_SetSeenAuto", Boolean.FALSE);
        dv.put("user_settings_AlwaysAddBilling", Boolean.FALSE);
        dv.put("list_ress_size", new Integer(1));
        dv.put("user_settings_AddSvInEnc", Boolean.FALSE);
        dv.put("user_settings_AddMesuresInEnc", Boolean.FALSE);
        dv.put("user_settings_AddConclusionInEnc", Boolean.FALSE);
        dv.put("user_settings_DirectPrint", Boolean.FALSE);
        dv.put("user_settings_NoShowSignWarning", Boolean.FALSE);
        dv.put("task.toUserId", new Integer(-1));
        dv.put("task.toGroupId", new Integer(-1));
        dv.put("user_settings_LastUsedPrintFax", "P");
        dv.put("user_settings_ShowSummaryDxInEnc", Boolean.FALSE);
        dv.put("user_settings_labOneLine", Boolean.TRUE);
        dv.put("user_settings_docOneLine", Boolean.TRUE);
        dv.put("user_settings_showLaboDocComments", Boolean.FALSE);
        dv.put("user_settings_SiteAppointments", Boolean.FALSE);
        dv.put("user_settings_SiteLaboDocs", Boolean.FALSE);
        dv.put("user_settings_SitePatients", Boolean.FALSE);
        dv.put("user_settings_SiteMessages", Boolean.FALSE);
        dv.put("user_settings_SiteMessages", Boolean.FALSE);
        dv.put("user_settings_SiteTasks", Boolean.FALSE);
        dv.put("inspq_vaccin_tradeName", "");
        dv.put("inspq_vaccin_locationPref", "{\"country\":{\"id\":\"482502\",\"code\":\"CA\",\"display\":\"Canada\",\"version\":\"1.0.0\",\"system\":\"http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/vocabulary\"},\"province\":{\"id\":\"1016979\",\"code\":\"QC\",\"display\":\"Qu\u00e9bec\",\"version\":\"1.0.0\",\"system\":\"http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/vocabulary\"},\"city\":{\"id\":\"1064538\",\"code\":\"23027\",\"display\":\"Qu\u00e9bec\",\"version\":\"1.0.0\",\"system\":\"http://www.santepublique.rtss.qc.ca/sipmi/fa/1.0.0/vocabulary\"}}");
        dv.put("inspq_vaccin_performer", "");
        dv.put("inspq_vaccin_location", "");
        dv.put("schedule_settings_appointmentDayViewScale", new Integer(5));
        dv.put("schedule_settings_scheduleDayViewScale", new Integer(15));
        dv.put("schedule_settings_showAppTime", Boolean.TRUE);
        dv.put("schedule_settings_showDeletedAppt", Boolean.FALSE);
        dv.put("user_settings_UseNewPDFViewer", Boolean.TRUE);
        dv.put("user_settings_printReportProperties", new String[0]);
        dv.put("user_settings_chosenReports", "");
        dv.put("user_list_profFavorite", new Integer[0]);
        dv.put("user_list_multiProfFavorite", "");
        dv.put("et_Stylet", Boolean.FALSE);
        dv.put("task_settings_st0", "TASK_PROGRESS_SO");
        dv.put("task_settings_st1", "TASK_PROGRESS_RECU");
        dv.put("task_settings_st2", "TASK_PROGRESS_EN_COURS2");
        dv.put("task_settings_st20", "CAT. 1");
        dv.put("task_settings_st40", "CAT. 2");
        dv.put("task_settings_st60", "CAT. 3");
        dv.put("task_settings_st80", "CAT. 4");
        dv.put("task_settings_st100", "TASK_PROGRESS_EN_COURS100");
        dv.put("task_settings_stcol0", "#FFFFFF");
        dv.put("task_settings_stcol1", "#D3FDFE");
        dv.put("task_settings_stcol2", "#9EE4F9");
        dv.put("task_settings_stcol20", "#F6FB9B");
        dv.put("task_settings_stcol40", "#FFC300");
        dv.put("task_settings_stcol60", "#c0c4ff");
        dv.put("task_settings_stcol80", "#fbb3d7");
        dv.put("task_settings_stcol100", "#AAFBA1");
        dv.put("hideSuiviPrev", Boolean.FALSE);
        dv.put("labodoc_savenext", Boolean.TRUE);
    }

    public MVProps() {
        this.createStore();
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    public synchronized Object addObjectToMap(String mapName, String k, Object obj) {
        if (obj != null) {
            Object o;
            Object ko = dv.get(k);
            Object oooo = obj;
            if (ko != null && !ko.getClass().equals(String.class) && obj instanceof String) {
                try {
                    Method valueOf = ko.getClass().getMethod("valueOf", String.class);
                    oooo = valueOf.invoke(null, obj);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    System.out.println(this);
                }
            }
            if (this.memMap != null) {
                o = ((ConcurrentMap)this.memMap.get(mapName)).put(k, oooo);
            } else {
                o = mapStore.get(mapName).put(k, oooo);
                this.store.commit();
            }
            return o;
        }
        return null;
    }

    public synchronized Object getObjectFromMap(String mapName, String k) {
        ConcurrentMap<String, Object> mvMap;
        ConcurrentMap concurrentMap;
        Object object = null;
        if (this.memMap != null ? (concurrentMap = (ConcurrentMap)this.memMap.get(mapName)) != null && (object = concurrentMap.get(k)) == null && dv.containsKey(k) : (mvMap = mapStore.get(mapName)) != null && (object = mvMap.get(k)) == null && dv.containsKey(k)) {
            return dv.get(k);
        }
        return object;
    }

    public synchronized Object removeObjectFromMap(String mapName, String k) {
        Object remove = null;
        if (this.memMap != null) {
            ConcurrentMap concurrentMap = (ConcurrentMap)this.memMap.get(mapName);
            if (concurrentMap != null) {
                remove = concurrentMap.remove(k);
            }
        } else {
            remove = mapStore.get(mapName).remove(k);
            this.store.commit();
        }
        return remove;
    }

    public synchronized ConcurrentMap<String, Object> addMap(String mapName) {
        if (this.store == null) {
            ConcurrentHashMap concurrentMap;
            if (this.memMap == null) {
                this.memMap = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();
            }
            if ((concurrentMap = (ConcurrentHashMap)this.memMap.get(mapName)) == null) {
                concurrentMap = new ConcurrentHashMap();
                this.memMap.put(mapName, concurrentMap);
            }
            return concurrentMap;
        }
        MVMap openMap = this.store.openMap(mapName);
        mapStore.put(mapName, (ConcurrentMap<String, Object>)openMap);
        this.store.commit();
        return openMap;
    }

    public synchronized void delMap(String m) {
        if (this.store == null) {
            if (this.memMap != null) {
                this.memMap.remove(m);
            }
        } else if (this.store.hasMap(m)) {
            mapStore.remove(m);
            MVMap openMap = this.store.openMap(m);
            this.store.removeMap(openMap);
            this.store.commit();
        }
    }

    public synchronized void dispose() {
        this.closeStore();
    }

    public synchronized void closeStore() {
        if (this.store != null) {
            this.store.commit();
            mapStore.clear();
            this.store.close();
            this.store = null;
        }
    }

    private String getNewSessionName() {
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null && session.getUser() != null) {
                return session.getUser().name;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
        }
        return null;
    }

    public synchronized void createStore() {
        if (this.store != null) {
            throw new IllegalStateException("store is already created");
        }
        String newSessionName = this.getNewSessionName();
        if (newSessionName != null) {
            char[] storePassword = this.getStorePassword();
            String storeFileName = this.getStoreFileName();
            String file = String.valueOf(LibPlugin.OFYS_HOME) + storeFileName;
            try {
                try {
                    this.store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).open();
                }
                catch (Exception exception) {
                    this.store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).compress().open();
                }
            }
            catch (Exception e1) {
                Log.severe((String)("createStore pour " + newSessionName), (Exception)e1);
                File st = new File(file);
                boolean delete = st.delete();
                if (delete) {
                    try {
                        this.store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).open();
                    }
                    catch (IllegalStateException e2) {
                        Log.severe((String)("createStore delete pour " + newSessionName), (Exception)e2);
                    }
                    catch (Exception e3) {
                        Log.severe((String)("createStore delete pour " + newSessionName), (Exception)e3);
                    }
                }
                Log.severe((String)("cannot delete file for MVProps " + file));
            }
            MAPS[] mAPSArray = MAPS.values();
            int n = mAPSArray.length;
            int n2 = 0;
            while (n2 < n) {
                MAPS m = mAPSArray[n2];
                this.addMap(m.name());
                ++n2;
            }
        }
    }

    private char[] getStorePassword() {
        String nn = this.getNewSessionName().toLowerCase();
        String n = nn.toLowerCase().replace('0', 'j').replace('1', 'i').replace('2', 'h').replace('3', 'g').replace('4', 'f').replace('5', 'e').replace('6', 'd').replace('7', 'c').replace('8', 'b').replace('9', 'a').replace('-', 'z').replace('.', 'm');
        return n.toCharArray();
    }

    private String getStoreFileName() {
        String nn = this.getNewSessionName().toLowerCase();
        String n = nn.toLowerCase().replace('0', 'j').replace('1', 'i').replace('2', 'h').replace('3', 'g').replace('4', 'f').replace('5', 'e').replace('6', 'd').replace('7', 'c').replace('8', 'b').replace('9', 'a').replace('-', 'z').replace('.', 'm');
        String encName = "";
        int i = 0;
        while (i < n.length()) {
            int tmp = n.charAt(i) - 65;
            int rotated = (tmp - 4) % 25;
            int shift = rotated + 65;
            encName = String.valueOf(encName) + (char)shift;
            ++i;
        }
        if (StringUtils.isEmpty((String)encName)) {
            encName = n;
        }
        return encName.toLowerCase();
    }

    public static enum MAPS {
        USER,
        GLOBAL;

    }
}

