/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.simple;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.person.address2.SimplePatientAddressAdapter;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchComposite;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchView;
import ca.infodata.ofys.ui.person.simple.BaseSimplePatientControl;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimplePatientControl
extends BaseSimplePatientControl {
    public SimplePatientControl(Composite parent, FormToolkit toolkit, IBaseEditor parentEditor) {
        super(parent, toolkit, parentEditor);
    }

    @Override
    public void showDataObject() {
        IPatient patient = this.getPatient();
        this.txtNoteVariableReplacer.setDataObject((Object)patient);
        this.txtNoteVariableReplacer.setToday(LocalDate.today());
        Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
        boolean showPatient = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_PATIENT);
        boolean showPatientOther = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_PATIENT_OTHER);
        boolean showAddress = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_ADDRESS);
        boolean showComm = patient.hasActiveConsentement(idUser, XConsentement.RIGHT_COMMUNICATION);
        this.txtHealthInsuranceNumber.setVisible(!this.isOnlyAdmin && showPatient);
        this.txtTreatingProfessionnal.setVisible(!this.isOnlyAdmin && showPatientOther);
        this.cmbTypeContact1.setVisible(!this.isOnlyAdmin && showComm);
        this.txtContact1.setVisible(!this.isOnlyAdmin && showComm);
        this.txtNoteContact1.setVisible(!this.isOnlyAdmin && showComm);
        this.addressControlCompact.setVisible(!this.isOnlyAdmin && showAddress);
        if (patient == null || patient.getPatientRecordNumber() == null) {
            this.lblPatientRecordNumberMoreVisible.setText("Dossier.");
        } else {
            this.lblPatientRecordNumberMoreVisible.setText("Dossier.    " + patient.getPatientRecordNumber());
        }
        this.setLastNameControl();
        this.setFirstNameControl();
        this.setNoteControl();
        this.setBirthDateControl();
        this.setGenderControl();
        this.addressControlCompact.setAddress(new SimplePatientAddressAdapter(this.getController()));
        this.addressControlCompact.showCurrentAddress();
        XContactInformation firstContactInformation = patient.getFirstContactInformation();
        if (firstContactInformation == null) {
            this.cmbTypeContact1.select((Object)XContactInformation.CONTACT_TYPE_PHONE);
            this.txtContact1.setRawText("");
            this.txtNoteContact1.setText("");
            this.setMaskType(XContactInformation.CONTACT_TYPE_PHONE);
        } else {
            this.setMaskType(this.get(firstContactInformation.getTypeContact(), XContactInformation.CONTACT_TYPE_PHONE));
            this.cmbTypeContact1.select((Object)firstContactInformation.getTypeContact());
            this.txtContact1.setRawText(this.get(firstContactInformation.getContact(), ""));
            this.txtNoteContact1.setText(this.get(firstContactInformation.getNote(), ""));
        }
        this.txtPatientRecordNumber.setRawText(this.get(patient.getPatientRecordNumber(), ""));
        this.txtHealthInsuranceNumber.setText(this.get(patient.getHealthInsuranceNumber(), "").trim());
        this.txtTreatingProfessionnal.setDataObjectId(patient.getTreatingProfessionnal());
        this.txtExpirationCAM.setRawText(this.get(patient.getExpirationCAM(), ""));
    }

    private void setGenderControl() {
        XPerson.Gender selection = (XPerson.Gender)this.cmbGender.getSelection();
        XPerson.Gender gender = XPerson.Gender.from((String)this.getPatient().getGender());
        if (selection != null && selection != gender) {
            this.cmbGender.select((Object)gender);
        }
    }

    private void setBirthDateControl() {
        this.txtBirthDate.setDate((IPartialDate)this.getPatient().getBirthDate());
    }

    private void setNoteControl() {
        if (!this.txtNote.getText().equals(this.getPatient().getNote())) {
            this.txtNote.setText(this.get(this.getPatient().getNote(), ""));
        }
    }

    private void setFirstNameControl() {
        if (!this.txtFirstName.getText().equals(this.getPatient().getFirstName())) {
            this.txtFirstName.setRawText(this.get(this.getPatient().getFirstName(), ""));
        }
    }

    private void setLastNameControl() {
        String lastName;
        String text = this.txtLastName.getText();
        if (!text.equals(lastName = this.getPatient().getLastName())) {
            this.txtLastName.setRawText(this.get(lastName, ""));
        }
    }

    private <A> A get(A o, A defaultIfNull) {
        if (o == null) {
            return defaultIfNull;
        }
        return o;
    }

    protected String getFormatedPatientRecordNumberFromControl() {
        String strZero = "0000000000" + this.txtPatientRecordNumber.getText();
        return strZero.substring(strZero.length() - Application.get().getGlobalInstances().getSession().getClientPreferences().getPatientRecordNumberLength());
    }

    @Override
    protected void btnSearchTreatingProfessionnalSelected() {
        this.txtTreatingProfessionnal.setData("isTreatingProfessionnal", true);
        ProfessionnalSearchComposite professionnalSearch = this.getProfessionnalSearch();
        if (professionnalSearch != null) {
            professionnalSearch.setType(0);
            professionnalSearch.setReferenceControl(this.txtTreatingProfessionnal);
            professionnalSearch.setFocus();
        } else {
            ProfessionnalSearchView view = (ProfessionnalSearchView)BaseSearchView.openView(ProfessionnalSearchView.class, (Object)this.txtTreatingProfessionnal);
            view.setType(0);
        }
    }
}

