/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.professionnal;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.BaseProfessionnalEditor;
import java.util.Collections;

public class ProfessionnalEditor
extends BaseProfessionnalEditor {
    public ProfessionnalEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    public void showDataObjectOverride() {
        XPerson person = this.getPerson();
        this.personControl.showCurrentPerson();
        boolean showSectionUser = Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER);
        this.sectionUser.setVisible(showSectionUser);
        this.userControl.showCurrentUser();
        this.sectionSignatures.setVisible(this.sectionSignaturesEnabled());
        if (person == null) {
            this.replacementControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
            this.addressControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
            this.contactControl.setStatusList(EditableDataObjectList.EMPTY_LIST);
            this.chkAppointment.setSelection(false);
            this.chkAppointment.setEnabled(false);
            this.chkIsTreating.setSelection(false);
            this.chkIsTreating.setEnabled(false);
            this.chkIsSetSeenManual.setSelection(false);
            this.chkIsSetSeenManual.setEnabled(false);
            this.chkOnCallProfessionnal.setSelection(false);
            this.chkOnCallProfessionnal.setEnabled(false);
            this.professionnalControl.showCurrentProfessionnal();
            IEditableDataObjectList emptyList = EditableDataObjectList.emptyList();
            this.siteControl.setStatusList(emptyList);
        } else {
            this.siteControl.setStatusList(person.getLstSites());
            Collections.sort(this.getPerson().getLstAddress(), XPerson.compImportance);
            Collections.sort(this.getPerson().getLstContactInformation(), XPerson.compImportance);
            this.addressControl.setStatusList((IEditableDataObjectList)person.getLstAddress());
            this.contactControl.setStatusList((IEditableDataObjectList)person.getLstContactInformation());
            XProfessionnal professionnal = this.getProfessionnal();
            if (professionnal != null) {
                this.replacementControl.setStatusList((IEditableDataObjectList)professionnal.getListReplacements());
                this.chkAppointment.setSelection(professionnal.useAppointment());
                this.chkIsTreating.setSelection(professionnal.getIsProfTx());
                this.chkIsSetSeenManual.setSelection(professionnal.getIsSetSeenManual());
                this.chkOnCallProfessionnal.setEnabled(!Boolean.TRUE.equals(professionnal.getIsOnCallProfessionnal()));
                this.chkOnCallProfessionnal.setSelection(Boolean.TRUE.equals(professionnal.getIsOnCallProfessionnal()));
            }
            this.professionnalControl.showCurrentProfessionnal();
        }
        this.layoutSubControl();
    }

    public boolean sectionSignaturesEnabled() {
        XProfessionnal prof = this.getProfessionnal();
        return Application.get().getGlobalInstances().inDebugMode() && prof != null && prof.getId() != null && prof.getUser() != null && !Boolean.TRUE.equals(prof.getUser().getIsDeleted()) && (Application.get().getGlobalInstances().hasRight(XRight.EDIT_USER) || prof.equals((Object)PersonUiPlugin.getDefault().getSessionProfessionnal()));
    }

    public void load() {
    }
}

