/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.data.middle.dataobjects.export.XExportableField;
import ca.infodata.ofys.ui.person.patient.search.export.ExportBean;
import ca.infodata.ofys.ui.person.patient.search.export.H2Exporter;
import ca.infodata.util1.ClosureA;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class Xls97Exporter
extends H2Exporter {
    private File file;
    private HSSFWorkbook workBook;
    private HSSFSheet sheet;
    private List<String> fields;
    private int rowNum = -1;

    public Xls97Exporter(ExportBean bean) throws Exception {
        this.file = bean.toFile;
    }

    @Override
    public void appendDone() throws Exception {
        this.workBook = new HSSFWorkbook();
        this.sheet = this.workBook.createSheet();
        this.fields = this.h2.getCallerFields();
        final List<String> fieldOrder = Arrays.asList(XExportableField.FIRST_NAME.toString(), XExportableField.LAST_NAME.toString(), XExportableField.SEX.toString(), XExportableField.BIRTH_DATE.toString(), XExportableField.HIN.toString(), XExportableField.RECORDNUMBER.toString(), XExportableField.MOTHER_NAME.toString(), XExportableField.FATHER_NAME.toString(), XExportableField.TUTOR_NAME.toString(), XExportableField.IS_SCANNED.toString(), XExportableField.TREATING_PROFESSIONNAL.toString(), XExportableField.ADDRESSES.toString(), "Adresse", "Adresse Note", "Rue", "Ville", "Province", "Pays", "Code Postal", XExportableField.CONTACTS.toString(), "T\u00e9l\u00e9phone", "T\u00e9l\u00e9phone Note", "T\u00e9l\u00e9phone 2", "T\u00e9l\u00e9phone 2 Note", "T\u00e9l\u00e9avertisseur", "T\u00e9l\u00e9avertisseur Note", "T\u00e9l\u00e9copieur", "T\u00e9l\u00e9copieur Note", "Cellulaire/Texto", "Cellulaire/Texto Note", "Autre(s) cellulaire(s)", "Autre(s) cellulaire(s) Note", "Courriel principal", "Courriel principal Note", "Autre(s) courriel(s)", "Autre(s) courriel(s) Note", XExportableField.LAST_APPOINTMENT_DATE.toString(), XExportableField.NEXT_APPOINTMENT_DATE.toString(), XExportableField.NEXT_PATIENT_RECALL_DATE.toString(), XExportableField.SITE.toString(), XExportableField.NOTE.toString(), XExportableField.IDENTIFIERS.toString());
        Collections.sort(this.fields, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = fieldOrder.indexOf(o1);
                int i2 = fieldOrder.indexOf(o2);
                if (i1 < 0 && i2 < 0) {
                    return o1.compareTo(o2);
                }
                if (i1 < 0) {
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                return i1 - i2;
            }
        });
        ++this.rowNum;
        HSSFRow row = this.sheet.createRow(this.rowNum);
        int c = 0;
        while (c < this.fields.size()) {
            HSSFCell cell = row.createCell(c);
            cell.setCellValue(this.fields.get(c));
            ++c;
        }
        this.h2.iterate((ClosureA)new ClosureA<Map<String, String>>(){

            public void execute(Map<String, String> data) {
                try {
                    Xls97Exporter xls97Exporter = Xls97Exporter.this;
                    xls97Exporter.rowNum = xls97Exporter.rowNum + 1;
                    HSSFRow row = Xls97Exporter.this.sheet.createRow(Xls97Exporter.this.rowNum);
                    int c = 0;
                    while (c < Xls97Exporter.this.fields.size()) {
                        HSSFCell cell = row.createCell(c);
                        String field = (String)Xls97Exporter.this.fields.get(c);
                        String value = data.get(field);
                        if (value != null) {
                            value = value.replace("\n", "\r\n");
                        }
                        cell.setCellValue(value);
                        ++c;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        FileOutputStream fos = new FileOutputStream(this.file);
        this.workBook.write((OutputStream)fos);
        fos.flush();
        fos.close();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.workBook = null;
    }
}

