/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.MyEmptySelection;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyTable;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.search.export.ExportWizard;
import ca.infodata.ofys.ui.person.patient.search.export.ExportWizardDialog2;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.mb.listeners.GenListenerManager;

public class SearchResultView
extends ViewPart
implements ISelectionProvider,
IPatientRelated {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.patient.search.editor.SearchResultView");
    private static final int PAGE_SIZE = 30;
    private GenListenerManager<ISelectionChangedListener> selectionManager = new GenListenerManager(ISelectionChangedListener.class);
    private MyTable<XPatient> table;
    private MyButton btnNextPage;
    private MyButton btnPrevPage;
    private MyLabel lblPage;
    private MyButton btnExport;
    private List<Integer> ids;
    private List<Page> pages = new ArrayList<Page>();
    private int pageIndex;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        this.table = new MyTable(parent, 68356);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        this.table.setLabelProvider(SearchColumn.toTableLabelProvider(this.createTableColumns()));
        this.btnNextPage = new MyButton(parent, ">>", 8, toolkit);
        this.btnPrevPage = new MyButton(parent, "<<", 8, toolkit);
        this.lblPage = new MyLabel(parent, "", 0x1000000, toolkit);
        this.lblPage.setFont(3, 0);
        this.btnExport = new MyButton(parent, Messages.getString((String)"EXPORTER", (String[])new String[0]), 8, toolkit);
        toolkit.adapt(parent);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 20;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.width = 100;
        this.btnNextPage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 100;
        this.btnPrevPage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnPrevPage.getControl());
        data.right = new FormAttachment(this.btnNextPage.getControl());
        this.lblPage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNextPage.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(this.btnExport.getControl());
        this.table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.btnExport.setLayoutData((Object)data);
        this.btnNextPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchResultView.this.next();
            }
        });
        this.btnPrevPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchResultView.this.previous();
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchResultView.this.doExport();
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ISelectionChangedListener)SearchResultView.this.selectionManager.getProxy()).selectionChanged(new SelectionChangedEvent((ISelectionProvider)SearchResultView.this, SearchResultView.this.getSelection()));
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    protected void doExport() {
        try {
            ExportWizardDialog2 dialog = new ExportWizardDialog2(this.getSite().getShell(), new ExportWizard(this.getIds()));
            dialog.open();
        }
        catch (Exception e) {
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    protected void previous() {
        if (this.pageIndex > 0) {
            this.pageIndex = Math.max(this.pageIndex - 1, 0);
            this.loadPage(this.pages.get(this.pageIndex));
        }
        this.updateNavigationControls();
    }

    protected void next() {
        if (this.pageIndex < this.pages.size() - 1) {
            this.pageIndex = Math.min(this.pageIndex + 1, this.pages.size() - 1);
            this.loadPage(this.pages.get(this.pageIndex));
        }
        this.updateNavigationControls();
    }

    private void updateNavigationControls() {
        this.btnPrevPage.setEnabled(this.pageIndex > 0);
        this.btnNextPage.setEnabled(this.pageIndex < this.pages.size() - 1);
        if (this.ids.size() == 0) {
            this.lblPage.setText("Liste vide");
        } else {
            this.lblPage.setText(String.valueOf(this.pages.get((int)this.pageIndex).start) + Messages.getString((String)"A", (String[])new String[0]) + " " + this.pages.get((int)this.pageIndex).end + Messages.getString((String)"SUR", (String[])new String[0]) + this.ids.size());
        }
    }

    private void loadPage(Page page) {
        List<Integer> list = this.ids.subList(page.start, page.end);
        JobCallback callback = new JobCallback(){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XPatient[] pts = new XPatient[]{};
                        pts = response.getObj() instanceof List ? ((List)response.getObj()).toArray(pts) : (XPatient[])response.getObj();
                        SearchResultView.this.fill(pts);
                    }
                });
            }

            public void exception(Exception e) {
                super.exception(e);
            }
        };
        try {
            PatientAccessorClient.getInstance().getSimplePatients(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, list);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            callback.kill();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get simple patients from ids " + page, e);
            callback.kill();
        }
    }

    protected void fill(XPatient[] xPatients) {
        this.table.setItems((Object[])xPatients);
        UI.autoAdjustColumnWidthToContent((Table)this.table.getControl());
    }

    public void setFocus() {
        this.table.setFocus();
    }

    protected ArrayList<SearchColumn<XPatient>> createTableColumns() {
        ArrayList<SearchColumn<XPatient>> tableColumns = new ArrayList<SearchColumn<XPatient>>();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            tableColumns.add(new SearchColumn<XPatient>(this.table, "ID"){

                public String getText(XPatient e) {
                    return String.valueOf(e.getId());
                }
            });
        }
        SearchColumn<XPatient> sc = new SearchColumn<XPatient>(this.table, "NOM"){

            public String getText(XPatient e) {
                return e.getName();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        tableColumns.add(sc);
        tableColumns.add(new SearchColumn<XPatient>(this.table, "DDN", "DATE DE NAISSANCE"){

            public String getText(XPatient e) {
                return LocalDateFormat.nullSafeFormat((LocalDate)e.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "G", "GENRE"){

            public String getText(XPatient e) {
                return e.getGender();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "NO", "NO DOSSIER"){

            public String getText(XPatient e) {
                return e.getPatientRecordNumber();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "NAM"){

            public String getText(XPatient e) {
                return e.getFormatedHealthInsuranceNumber();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "TEL"){

            public String getText(XPatient e) {
                return e.getFirstPhoneNumberContact();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "TELNOTE"){

            public String getText(XPatient e) {
                return e.getFirstPhoneNumberContactNote();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, "PROF", "PROFESSIONNEL TRAITANT"){

            public String getText(XPatient e) {
                XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(e.getTreatingProfessionnal());
                return prof == null ? "" : prof.getName();
            }
        });
        tableColumns.add(new SearchColumn<XPatient>(this.table, Messages.getString((String)"INSCRIT", (String[])new String[0])){

            public String getText(XPatient e) {
                XInscriptionStatus s = e.getB2bStatus();
                return s == null || s != XInscriptionStatus.INSCRIT_CONFIRME ? "" : "\u221a";
            }
        });
        return tableColumns;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public void setIds(List<Integer> list) {
        this.ids = list;
        this.pages.clear();
        int total = list.size();
        int pageCount = total / 30;
        if (total % 30 != 0) {
            ++pageCount;
        }
        int start = 0;
        int i = 0;
        while (i < pageCount) {
            Page page = new Page(start, Math.min(start + 30, total));
            this.pages.add(page);
            start += 30;
            ++i;
        }
        this.pageIndex = 0;
        this.updateNavigationControls();
        if (this.pages.size() > 0) {
            this.loadPage(this.pages.get(this.pageIndex));
        } else {
            this.fill(new XPatient[0]);
        }
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public IPatient getPatient() {
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Object item = ((IStructuredSelection)selection).getFirstElement();
        if (item instanceof IPatientRelated) {
            return ((IPatientRelated)item).getPatient();
        }
        return (IPatient)item;
    }

    public MessageLink getMessageLink() {
        return null;
    }

    public ISelection getSelection() {
        List selection = this.table.getSelection();
        if (selection == null || selection.isEmpty()) {
            return new MyEmptySelection();
        }
        return new StructuredSelection(selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionManager.addListener((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionManager.removeListener((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    private static class Page {
        final int start;
        final int end;

        public Page(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

