/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientHaveAppRecall;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientInactiveRaison;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.BaseMultiEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.person.patient.BasePatientEditor;
import ca.infodata.ofys.ui.person.patient.PatientInactiationDialog;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PatientEditor
extends BasePatientEditor {
    private static final String VERIFICATION_DES_INFORMATIONS_RENDEZ_VOUS_ET_RAPPEL = Messages.getString((String)"PatientEditor.VERIFICATION_DES_INFORMATIONS_RENDEZ_VOUS_ET_RAPPEL", (String[])new String[0]);
    private static final String CE_CLIENT_A_DES_RENDEZ_VOUS_FUTURS = Messages.getString((String)"PatientEditor.CE_CLIENT_A_DES_RENDEZ_VOUS_FUTURS", (String[])new String[0]);
    private static final String CE_CLIENT_A_DES_RAPPELS = Messages.getString((String)"PatientEditor.CE_CLIENT_A_DES_RAPPELS", (String[])new String[0]);
    private static final String NOTE_DE_DESACTIVATION = Messages.getString((String)"PatientEditor.NOTE_DE_DESACTIVATION", (String[])new String[0]);
    private static final String MOIS = " " + Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase();
    private static final String ANS = " " + Messages.getString((String)"Client.AGE_ANS", (String[])new String[0]).toLowerCase();
    private static final String AN = " " + Messages.getString((String)"Client.AGE_ANS", (String[])new String[0]).replace("s", "").toLowerCase();
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.person.patient.PatientEditor");

    public PatientEditor(BaseMultiEditor parentEditor) {
        super(parentEditor);
    }

    @Override
    protected XPatient getPatient() {
        return (XPatient)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    @Override
    protected XPerson getPerson() {
        return this.getPatient();
    }

    public void load() {
    }

    public void showDataObjectOverride() {
        XPatient patient = this.getPatient();
        if (patient != null && patient.getPatientRecordNumber() != null) {
            this.sectionPerson.setText(PERSONNE);
        } else {
            this.sectionPerson.setText(PERSONNE);
        }
        boolean showPatient = true;
        boolean showPatientOther = true;
        boolean showAddress = true;
        boolean showComm = true;
        if (patient != null) {
            boolean showToAll = true;
            XConsentement consent = null;
            Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
            if (patient.getConsentement() != null && patient.getConsentement().size() > 0) {
                showToAll = false;
                for (XConsentement consentement : patient.getConsentement()) {
                    if (!consentement.getIdUserAnchor().equals(idUser)) continue;
                    consent = consentement;
                    break;
                }
            }
            boolean checkDroit = false;
            if (!showToAll && consent != null) {
                checkDroit = true;
            }
            showPatient = showToAll || checkDroit && consent.hasRightPatient();
            showPatientOther = showToAll || checkDroit && consent.hasRightPatientOther();
            showAddress = showToAll || checkDroit && consent.hasRightAddres();
            showComm = showToAll || checkDroit && consent.hasRightComm();
            String ageLabel = "";
            String dcd = "";
            if (patient.getBirthDate() != null) {
                int yearDiff;
                LocalDate dateDecesOrToday = LocalDate.today();
                if (patient.getInactiveDate() != null) {
                    Long dateDeces = patient.getInactiveDate().toAbsoluteDate().toTimeInMillisUTC();
                    if (XPatientInactiveRaison.DCD.equals((Object)patient.getInactiveRaison())) {
                        dateDecesOrToday = LocalDate.fromTimeInMillisUTC((Long)dateDeces);
                        dcd = " " + XPatientInactiveRaison.DCD.toString() + " " + LocalDateFormat.format((LocalDate)dateDecesOrToday, (String)FormatDateProvider.getFormatDate().toString());
                    }
                }
                if ((yearDiff = dateDecesOrToday.getYearDiff(patient.getBirthDate())) > 0) {
                    ageLabel = String.valueOf(yearDiff) + (yearDiff > 1 ? ANS : AN);
                } else {
                    int monthDiff = dateDecesOrToday.getMonthDiff(patient.getBirthDate());
                    ageLabel = String.valueOf(monthDiff) + MOIS;
                }
            }
            this.personControl.setAgeLabel(String.valueOf(ageLabel) + dcd);
            this.personControl.showCurrentPerson();
            Collections.sort(this.getPerson().getLstAddress(), XPerson.compImportance);
            Collections.sort(this.getPerson().getLstContactInformation(), XPerson.compImportance);
            this.addressControl.setStatusList((IEditableDataObjectList)this.getPerson().getLstAddress());
            this.addressControl.setVisible(!this.isOnlyAdmin && showAddress);
            this.contactControl.setStatusList((IEditableDataObjectList)this.getPerson().getLstContactInformation());
            this.contactControl.setVisible(!this.isOnlyAdmin && showComm);
            this.siteControl.setStatusList(this.getPerson().getLstSites());
            this.siteControl.setVisible(!this.isOnlyAdmin && showPatientOther);
            this.patient.showCurrentPatient();
            this.patient.setVisible(!this.isOnlyAdmin && showPatient);
            if (this.getPatient().getMotherId() != null && this.getPatient().getMother() == null) {
                this.patient.txtMother.setDataObjectId(this.getPatient().getMotherId());
            }
            if (this.getPatient().getFatherId() != null && this.getPatient().getFather() == null) {
                this.patient.txtFather.setDataObjectId(this.getPatient().getFatherId());
            }
            if (this.getPatient().getTutorId() != null && this.getPatient().getTutor() == null) {
                this.patient.txtTutor.setDataObjectId(this.getPatient().getTutorId());
            }
            this.patientProfessionnalControl.setStatusList(this.getPatient().getLstPatientProfessionnal());
            this.patientProfessionnalControl.setVisible(!this.isOnlyAdmin && showPatientOther);
            this.patientIdentifiersControl.setStatusList(this.getPatient().getLstPatientIdentifier());
            this.patientIdentifiersControl.setVisible(!this.isOnlyAdmin && showPatientOther);
            this.patientAlertsControl.setStatusList(this.getPatient().getLstPatientAlerts());
            this.patientAlertsControl.setVisible(!this.isOnlyAdmin && showPatientOther);
            this.drugStoreSiteControl.setStatusList(this.getPatient().getLstSites());
            this.drugStoreSiteControl.setVisible(!this.isOnlyAdmin && showPatientOther);
            this.patientConsentsControl.setStatusList(this.getPatient().getConsentement());
        }
    }

    public String getInactiveText() {
        XPatient pat = this.getPatient();
        if (pat != null) {
            String txt = "";
            if (pat.getInactiveRaison() != null) {
                txt = pat.getInactiveRaison().toString();
                if (pat.getInactiveDate() != null) {
                    txt = String.valueOf(txt) + " (" + pat.getInactiveDate().formatSlash() + ")";
                }
            }
            return txt;
        }
        return "";
    }

    public void setInactiveRaison(XPatientInactiveRaison r) {
        XPatient pat = this.getPatient();
        if (pat != null) {
            pat.setInactiveRaison(r);
        }
    }

    public XPatientInactiveRaison getInactiveRaison() {
        XPatient pat = this.getPatient();
        if (pat != null) {
            return pat.getInactiveRaison();
        }
        return null;
    }

    public boolean showInactivationCondition(boolean forDcd) {
        final XPatient pat = this.getPatient();
        XPatientInactiveRaison reason = pat.getInactiveRaison();
        StringBuilder sb = new StringBuilder();
        if (reason == null) {
            final XPatientHaveAppRecall haveIt = new XPatientHaveAppRecall(false, false);
            MyProgressMonitorDialog monitorDialog = new MyProgressMonitorDialog(this.parentComposite.getShell());
            final InactiveCallBackJob callbackApp = new InactiveCallBackJob(this, VERIFICATION_DES_INFORMATIONS_RENDEZ_VOUS_ET_RAPPEL){

                public void responseReceived(ReturnObject response) {
                    XPatientHaveAppRecall xphar = (XPatientHaveAppRecall)response.getObj();
                    haveIt.haveAppointment = xphar.haveAppointment;
                    haveIt.haveRecall = xphar.haveRecall;
                    this.workedWell = true;
                }
            };
            try {
                monitorDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            if (pat.getId() != null) {
                                AppointmentAccessorClient.getInstance().countPatientRecallAndFutureAppointmentSync(Application.get().getGlobalInstances().getSession(), (ICallback)callbackApp, pat.getId().intValue());
                            }
                        }
                        catch (CannotConnectToServerException cannotConnectToServerException) {
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to get appointment or patient recall : " + pat, e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (callbackApp != null && !callbackApp.killed()) {
                    callbackApp.kill();
                }
                logger.log(Level.SEVERE, "Couldn't check for appointment and recall on delete : " + pat, e);
            }
            if (haveIt.haveAppointment || haveIt.haveRecall || !callbackApp.workedWell) {
                if (haveIt.haveAppointment) {
                    sb.append(CE_CLIENT_A_DES_RENDEZ_VOUS_FUTURS);
                }
                if (haveIt.haveRecall) {
                    if (sb.toString().length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(CE_CLIENT_A_DES_RAPPELS);
                }
            }
        }
        PatientInactiationDialog dialog = new PatientInactiationDialog(this.parentComposite.getShell(), sb.toString()){

            @Override
            protected void onFinsh(boolean mustDeleteAppRec, XPatientInactiveRaison raison, IPartialDate date, String comments) {
                XPatient pat = PatientEditor.this.getPatient();
                if (pat != null) {
                    if (raison != null) {
                        pat.setInactiveRaison(raison);
                    }
                    if (date != null) {
                        pat.setInactiveDate(date);
                    }
                    if (mustDeleteAppRec) {
                        pat.mustDeleteFutureAppointmentAndReccallOnDelete = true;
                    }
                    if (StringUtils.isNotBlank((String)comments)) {
                        String nNote = "";
                        if (StringUtils.isNotBlank((String)pat.getNote())) {
                            nNote = String.valueOf(pat.getNote()) + "\n";
                        }
                        nNote = String.valueOf(nNote) + "---- " + NOTE_DE_DESACTIVATION + " / " + LocalDate.today().formatSlash() + " ----\n";
                        nNote = String.valueOf(nNote) + comments;
                        pat.setNote(nNote);
                    }
                }
            }
        };
        if (forDcd) {
            if (!XPatientInactiveRaison.DCD.equals((Object)pat.getInactiveRaison())) {
                dialog.setInactionRaison(XPatientInactiveRaison.DCD);
            } else {
                dialog.setInactionDate(pat.getInactiveDate());
            }
            dialog.fromDcd(true);
        } else {
            if (pat.getInactiveRaison() != null) {
                dialog.setInactionRaison(pat.getInactiveRaison());
            }
            if (pat.getInactiveDate() != null) {
                dialog.setInactionDate(pat.getInactiveDate());
            }
            dialog.fromDcd(false);
        }
        return dialog.open();
    }

    private abstract class InactiveCallBackJob
    extends JobCallback {
        public boolean workedWell;

        public InactiveCallBackJob(String title) {
            super(title);
            this.workedWell = false;
        }
    }
}

