/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu.element;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XUserDashboardCounts;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.util.MiscUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class ProfessionnalElements
extends AbstractTreeElement {
    private static final Logger logger = Logger.getLogger(ProfessionnalElements.class.getName());
    private XUserDashboardCounts userCnts = null;
    private XBaseProfessionnal professionnal;
    private EditorInput editorInput;
    protected final boolean usingTabletPerspective;
    protected final IConsumerListener consumerListener;

    public ProfessionnalElements(ITreeElements parent, XBaseProfessionnal professionnal) {
        super(parent);
        this.professionnal = professionnal;
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective")) {
            this.usingTabletPerspective = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer treeViewer = DossierPlugin.getDefault().getTreeViewer();
                    Tree tree = treeViewer.getTree();
                    if (tree != null && !tree.isDisposed()) {
                        treeViewer.setExpandedState((Object)ProfessionnalElements.this, true);
                    }
                }
            });
        } else {
            this.usingTabletPerspective = false;
        }
        this.consumerListener = new IConsumerListener(){

            public void handleOther(Notification notification) {
            }

            public void handle(DataObjectUpdatedNotification notification) {
                try {
                    if (notification != null) {
                        XProfessionnal professionnal2;
                        if (notification.getObject() instanceof XBaseProfessionnal) {
                            XBaseProfessionnal professionnal22 = (XBaseProfessionnal)notification.getObject();
                            if (professionnal22.equals((Object)ProfessionnalElements.this.professionnal)) {
                                this.updateProfessionnalFromCache();
                                DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)ProfessionnalElements.this);
                            }
                        } else if (notification.getObject() instanceof XProfessionnal && new XBaseProfessionnal(professionnal2 = (XProfessionnal)notification.getObject()).equals((Object)ProfessionnalElements.this.professionnal)) {
                            this.updateProfessionnalFromCache();
                            DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)ProfessionnalElements.this);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in ProfessionnalElements.handle", e);
                }
            }

            private void updateProfessionnalFromCache() {
                XBaseProfessionnal professionnal2;
                if (ProfessionnalElements.this.professionnal != null && (professionnal2 = PersonUiPlugin.getDefault().getBaseProfessionnal(ProfessionnalElements.this.professionnal.getId())) != null) {
                    ProfessionnalElements.this.professionnal = professionnal2;
                }
            }

            public void forceRefresh() {
                try {
                    if (ProfessionnalElements.this.professionnal != null) {
                        this.updateProfessionnalFromCache();
                        DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)ProfessionnalElements.this);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in ProfessionnalElements.forceRefresh", e);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.consumerListener);
    }

    public Object[] getChildren() {
        System.out.println("PatientRootElement.getChildren");
        if (this.hasChildren()) {
            System.out.println("this.children == null");
            List listChild = this.getChildrenByExtension();
            return listChild.toArray(new ITreeElements[listChild.size()]);
        }
        return null;
    }

    public boolean hasChildren() {
        return this.professionnal != null && this.professionnal.getId() != null && this.professionnal.getId() != -1;
    }

    public String getText() {
        String text = "";
        text = this.professionnal.getId() == null ? Messages.getString((String)"NOUVEAU_PROFESSIONNEL", (String[])new String[0]) : String.valueOf(this.professionnal.getName()) + " : " + this.professionnal.getCode();
        return text;
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/stethoscope-icon16.png");
    }

    public String getEditorClass() {
        String editor = "ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor";
        if (this.professionnal.getId() != null && this.professionnal.getId() == -1) {
            editor = "VIEW:ca.infodata.ofys.ui.person.search.ProfessionnalSearchView";
        }
        return editor;
    }

    public IEditorInput getEditorInput() {
        if (Application.get().getGlobalInstances().hasRight(XRight.EDIT_PROF) || this.professionnal != null && MiscUtil.areObjectsEquals((Object)PersonUiPlugin.getDefault().getSessionProfessionnal(), (Object)this.professionnal)) {
            this.editorInput = new EditorInput((IDataObject)this.professionnal);
            return this.editorInput;
        }
        return null;
    }

    public XImageDecorator getDecorators() {
        if (this.professionnal.getId() == null) {
            return new XImageDecorator(null, null, null, "ajouter_decorator.gif");
        }
        return this.professionnal.getDecorators();
    }

    public XBaseProfessionnal getProfessionnal() {
        return this.professionnal;
    }

    public void showContextMenu(Control control) {
        this.extendsContextMenuWithContributions(control);
        control.setMenu(null);
    }

    public int hashCode() {
        this.professionnal.hashCode();
        int hashCode = this.professionnal == null ? "ProfessionnalNull".hashCode() : this.professionnal.hashCode();
        return new String(String.valueOf(this.getParent().hashCode()) + " " + hashCode + " " + ((Object)((Object)this)).getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ProfessionnalElements && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

