/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.UserAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class UserCache
extends ObjectCache<XBaseUser> {
    private static final String TAG_PERSON = "user-person";
    private static final String TAG = "user";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public UserCache() {
        super(TAG);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAllAsync(session, callback, TAG);
    }

    protected void add(Map<ObjectCache.Key, XBaseUser> map, XBaseUser e) {
        if (e != null) {
            map.put(new ObjectCache.Key(TAG, e.getId()), e);
            if (e.getIdPerson() != null) {
                map.put(new ObjectCache.Key(TAG_PERSON, e.getIdPerson()), e);
            }
        }
    }

    public XBaseUser getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public XBaseUser getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseUser)this.get(new ObjectCache.Key(TAG, id), logIfNotFound, mustTryToFindServer);
    }

    public XBaseUser getByIdPerson(Integer id, boolean logIfNotFound) {
        return this.getByIdPerson(id, logIfNotFound, true);
    }

    public XBaseUser getByIdPerson(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseUser)this.get(new ObjectCache.Key(TAG_PERSON, id), logIfNotFound, mustTryToFindServer);
    }

    protected XBaseUser loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (TAG.equals(key.type)) {
            return UserAccessorClient.getInstance().getBaseUserSync(session, key.id);
        }
        if (TAG_PERSON.equals(key.type)) {
            return UserAccessorClient.getInstance().getBaseUserByIdPersonSync(session, key.id);
        }
        return null;
    }

    public Set<XBaseUser> getAll() {
        return new HashSet<XBaseUser>(this.getMap().values());
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAll(session, callback, TAG);
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                IDataObject object;
                if (notification != null && (object = notification.getObject()) instanceof XBaseUser) {
                    UserCache.this.add((Map<ObjectCache.Key, XBaseUser>)UserCache.this.getMap(), (XBaseUser)object);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                UserCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in UserCache.forceRefresh", e);
            }
        }
    }
}

