/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.encounter.DIN;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.Operator;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.encounter.patient.search.DINSearchPopupFeature;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.util1.IPair;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutablePair;
import ca.infodata.util1.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DrugDINCriteria
extends AbstractCriteria {
    public DrugDINCriteria() {
        super(CID.DRUG_DIN);
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IN);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.IN;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        final MutablePair value = (MutablePair)(valueReference == null ? new MutablePair() : valueReference);
        value.first = value.first == null ? new LinkedHashSet() : (Set)value.first;
        value.second = value.second == null ? "" : (String)value.second;
        final Label label = new Label(parent, 18432);
        label.setText(this.computeLabel((Set)value.getFirst(), (String)value.getSecond()));
        final DINSearchPopupFeature feature = new DINSearchPopupFeature((Control)label, (Set)value.getFirst(), (String)value.getSecond()){

            @Override
            protected void modelModified() {
                value.second = this.getAlias();
                label.setText(DrugDINCriteria.this.computeLabel((Set)value.getFirst(), (String)value.getSecond()));
            }
        };
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                feature.openPopupWindow();
            }
        });
        return value;
    }

    protected String computeLabel(Set<DIN> list, String alias) {
        if (StringUtils.isNotBlank((String)alias)) {
            return alias;
        }
        JoinList joinList = new JoinList(",", list.size());
        for (DIN e : list) {
            joinList.add((CharSequence)e.commercialName);
        }
        if (joinList.size() == 0) {
            return "Cliquez ici pour ouvrir le dialogue de s\u00e9lection";
        }
        return joinList.toString();
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        ServerCriteria c = new ServerCriteria();
        c.id = this.cid;
        c.operator = Operator.IN;
        HashSet<Integer> dins = new HashSet<Integer>(((Set)value.getFirst()).size());
        for (DIN din : (Set)value.getFirst()) {
            dins.add(din.din);
        }
        c.value = dins;
        return c;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        HashMap<String, String> map = new HashMap<String, String>();
        JoinList joinList = new JoinList(",");
        if (value.getFirst() != null) {
            for (DIN din : (Set)value.getFirst()) {
                joinList.add((CharSequence)new JoinList(";", new Object[]{din.din, din.genericName, din.genericName}).toString());
            }
        }
        map.put("dins", joinList.toString());
        map.put("alias", (String)value.getSecond());
        return map;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        MutablePair value = new MutablePair();
        value.first = new LinkedHashSet();
        value.second = map.remove("alias");
        String sdins = map.get("dins");
        if (StringUtils.isNotBlank((String)sdins)) {
            String[] split;
            String[] stringArray = split = sdins.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String sdin = stringArray[n2];
                DIN a = new DIN();
                String[] split2 = StringUtils.splitNonDescructive((String)sdin, (char)';');
                if (split2.length > 0) {
                    a.din = Integer.parseInt(split2[0]);
                    if (split2.length > 1) {
                        a.genericName = split2[1];
                        if (split2.length > 2) {
                            a.commercialName = split2[1];
                        }
                    }
                    ((Set)value.first).add(a);
                }
                ++n2;
            }
        }
        return value;
    }
}

